/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import groovy.lang.Binding;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.Messages;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.MailAddressResolver;
import hudson.util.FormValidation;
import hudson.util.Scrambler;
import hudson.util.spring.BeanBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import jenkins.model.Jenkins;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapTemplate;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    public final String server;
    public final String rootDN;
    public final boolean inhibitInferRootDN;
    public final String userSearchBase;
    public final String userSearch;
    public final String groupSearchBase;
    public final String groupSearchFilter;
    public final String groupMembershipFilter;
    public final String managerDN;
    private final String managerPassword;
    private transient LdapTemplate ldapTemplate;
    public final boolean disableMailAddressResolver;
    private final CacheConfiguration cache;
    private transient Map<String, CacheEntry<LdapUserDetails>> userDetailsCache = null;
    private transient Map<String, CacheEntry<Set<String>>> groupDetailsCache = null;
    private final Map<String, String> extraEnvVars;
    private static final Logger LOGGER = Logger.getLogger(LDAPSecurityRealm.class.getName());
    public static String GROUP_SEARCH = System.getProperty(LDAPSecurityRealm.class.getName() + ".groupSearch", "(& (cn={0}) (| (objectclass=groupOfNames) (objectclass=groupOfUniqueNames) (objectclass=posixGroup)))");

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, false);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, null, null, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache, null);
    }

    @DataBoundConstructor
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties) {
        this.server = server.trim();
        this.managerDN = Util.fixEmpty((String)managerDN);
        this.managerPassword = Scrambler.scramble((String)Util.fixEmpty((String)managerPassword));
        this.inhibitInferRootDN = inhibitInferRootDN;
        if (!inhibitInferRootDN && Util.fixEmptyAndTrim((String)rootDN) == null) {
            rootDN = Util.fixNull((String)this.inferRootDN(server));
        }
        this.rootDN = rootDN.trim();
        this.userSearchBase = Util.fixNull((String)userSearchBase).trim();
        this.userSearch = (userSearch = Util.fixEmptyAndTrim((String)userSearch)) != null ? userSearch : "uid={0}";
        this.groupSearchBase = Util.fixEmptyAndTrim((String)groupSearchBase);
        this.groupSearchFilter = Util.fixEmptyAndTrim((String)groupSearchFilter);
        this.groupMembershipFilter = Util.fixEmptyAndTrim((String)groupMembershipFilter);
        this.disableMailAddressResolver = disableMailAddressResolver;
        this.cache = cache;
        this.extraEnvVars = environmentProperties == null || environmentProperties.length == 0 ? null : EnvironmentProperty.toMap(Arrays.asList(environmentProperties));
    }

    public String getServerUrl() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : this.server.split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(LDAPSecurityRealm.addPrefix(s));
        }
        return buf.toString();
    }

    public CacheConfiguration getCache() {
        return this.cache;
    }

    public Integer getCacheSize() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getSize());
    }

    public Integer getCacheTTL() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getTtl());
    }

    public String getGroupMembershipFilter() {
        return this.groupMembershipFilter;
    }

    public String getGroupSearchFilter() {
        return this.groupSearchFilter;
    }

    public Map<String, String> getExtraEnvVars() {
        return this.extraEnvVars == null || this.extraEnvVars.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.extraEnvVars);
    }

    public EnvironmentProperty[] getEnvironmentProperties() {
        if (this.extraEnvVars == null || this.extraEnvVars.isEmpty()) {
            return new EnvironmentProperty[0];
        }
        EnvironmentProperty[] result = new EnvironmentProperty[this.extraEnvVars.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : this.extraEnvVars.entrySet()) {
            result[i++] = new EnvironmentProperty(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private String inferRootDN(String server) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            if (this.managerDN != null) {
                props.put("java.naming.security.principal", this.managerDN);
                props.put("java.naming.security.credentials", this.getManagerPassword());
            }
            props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            props.put("java.naming.provider.url", LDAPSecurityRealm.toProviderUrl(this.getServerUrl(), ""));
            InitialDirContext ctx = new InitialDirContext(props);
            Attributes atts = ctx.getAttributes("");
            Attribute a = atts.get("defaultNamingContext");
            if (a != null && a.get() != null) {
                return a.get().toString();
            }
            a = atts.get("namingcontexts");
            if (a == null) {
                LOGGER.warning("namingcontexts attribute not found in root DSE of " + server);
                return null;
            }
            return a.get().toString();
        }
        catch (NamingException e) {
            LOGGER.log(Level.WARNING, "Failed to connect to LDAP to infer Root DN for " + server, e);
            return null;
        }
    }

    private static String toProviderUrl(String serverUrl, String rootDN) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : serverUrl.split("\\s+")) {
            if (s.trim().length() == 0) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            s = LDAPSecurityRealm.addPrefix(s);
            buf.append(s);
            if (!s.endsWith("/")) {
                buf.append('/');
            }
            buf.append(Util.fixNull((String)rootDN));
        }
        return buf.toString();
    }

    public String getManagerPassword() {
        return Scrambler.descramble((String)this.managerPassword);
    }

    public String getLDAPURL() {
        return LDAPSecurityRealm.toProviderUrl(this.getServerUrl(), Util.fixNull((String)this.rootDN));
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        Binding binding = new Binding();
        binding.setVariable("instance", (Object)this);
        BeanBuilder builder = new BeanBuilder(Jenkins.getInstance().pluginManager.uberClassLoader);
        String fileName = "LDAPBindSecurityRealm.groovy";
        try {
            File override = new File(Jenkins.getInstance().getRootDir(), fileName);
            builder.parse((InputStream)(override.exists() ? new AutoCloseInputStream((InputStream)new FileInputStream(override)) : ((Object)((Object)this)).getClass().getResourceAsStream(fileName)), binding);
        }
        catch (FileNotFoundException e) {
            throw new Error("Failed to load " + fileName, e);
        }
        WebApplicationContext appContext = builder.createApplicationContext();
        this.ldapTemplate = new LdapTemplate((InitialDirContextFactory)LDAPSecurityRealm.findBean(InitialDirContextFactory.class, (ApplicationContext)appContext));
        if (this.groupMembershipFilter != null) {
            AuthoritiesPopulatorImpl authoritiesPopulator = (AuthoritiesPopulatorImpl)((Object)LDAPSecurityRealm.findBean(AuthoritiesPopulatorImpl.class, (ApplicationContext)appContext));
            authoritiesPopulator.setGroupSearchFilter(this.groupMembershipFilter);
        }
        return new SecurityRealm.SecurityComponents((AuthenticationManager)LDAPSecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)appContext), (UserDetailsService)new LDAPUserDetailsService(appContext));
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        return (UserDetails)this.getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password)).getPrincipal();
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.getSecurityComponents().userDetails.loadUserByUsername(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        Set groups;
        Set cachedGroups;
        if (this.cache != null) {
            CacheEntry<Set<String>> cached;
            LDAPSecurityRealm lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                cached = this.groupDetailsCache != null ? this.groupDetailsCache.get(groupname) : null;
            }
            cachedGroups = cached != null && cached.isValid() ? cached.getValue() : null;
        } else {
            cachedGroups = null;
        }
        String searchBase = this.groupSearchBase != null ? this.groupSearchBase : "";
        String searchFilter = this.groupSearchFilter != null ? this.groupSearchFilter : GROUP_SEARCH;
        Set set = groups = cachedGroups != null ? cachedGroups : this.ldapTemplate.searchForSingleAttributeValues(searchBase, searchFilter, (Object[])new String[]{groupname}, "cn");
        if (this.cache != null && cachedGroups == null && !groups.isEmpty()) {
            LDAPSecurityRealm lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                if (this.groupDetailsCache == null) {
                    this.groupDetailsCache = new CacheMap<String, Set<String>>(this.cache.getSize());
                }
                this.groupDetailsCache.put(groupname, new CacheEntry<Set>(this.cache.getTtl(), groups));
            }
        }
        if (groups.isEmpty()) {
            throw new UsernameNotFoundException(groupname);
        }
        return new GroupDetails(){

            public String getName() {
                return (String)groups.iterator().next();
            }
        };
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnvironmentProperty
    extends AbstractDescribableImpl<EnvironmentProperty>
    implements Serializable {
        private final String name;
        private final String value;

        @DataBoundConstructor
        public EnvironmentProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, String> toMap(List<EnvironmentProperty> properties) {
            if (properties != null) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                for (EnvironmentProperty property : properties) {
                    result.put(property.getName(), property.getValue());
                }
                return result;
            }
            return null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        @Extension
        public static class DescriptorImpl
        extends Descriptor<EnvironmentProperty> {
            public String getDisplayName() {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheMap<K, V>
    extends LinkedHashMap<K, CacheEntry<V>> {
        private final int cacheSize;

        public CacheMap(int cacheSize) {
            super(cacheSize + 1);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<V>> eldest) {
            return this.size() > this.cacheSize || eldest.getValue() == null || !eldest.getValue().isValid();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheEntry<T> {
        private final long expires;
        private final T value;

        public CacheEntry(int ttlSeconds, T value) {
            this.expires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttlSeconds);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isValid() {
            return System.currentTimeMillis() < this.expires;
        }
    }

    public static class CacheConfiguration {
        private final int size;
        private final int ttl;

        @DataBoundConstructor
        public CacheConfiguration(int size, int ttl) {
            this.size = Math.max(10, Math.min(size, 1000));
            this.ttl = Math.max(30, Math.min(ttl, 3600));
        }

        public int getSize() {
            return this.size;
        }

        public int getTtl() {
            return this.ttl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return Messages.LDAPSecurityRealm_DisplayName();
        }

        public FormValidation doServerCheck(@QueryParameter String server, @QueryParameter String managerDN, @QueryParameter String managerPassword) {
            if (!Jenkins.getInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                Hashtable<String, String> props = new Hashtable<String, String>();
                if (managerDN != null && managerDN.trim().length() > 0 && !"undefined".equals(managerDN)) {
                    props.put("java.naming.security.principal", managerDN);
                }
                if (managerPassword != null && managerPassword.trim().length() > 0 && !"undefined".equals(managerPassword)) {
                    props.put("java.naming.security.credentials", managerPassword);
                }
                props.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                props.put("java.naming.provider.url", LDAPSecurityRealm.toProviderUrl(server, ""));
                InitialDirContext ctx = new InitialDirContext(props);
                ctx.getAttributes("");
                return FormValidation.ok();
            }
            catch (NamingException e) {
                Matcher m = Pattern.compile("(ldaps?://)?([^:]+)(?:\\:(\\d+))?(\\s+(ldaps?://)?([^:]+)(?:\\:(\\d+))?)*").matcher(server.trim());
                if (!m.matches()) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_SyntaxOfServerField());
                }
                try {
                    int port;
                    InetAddress adrs = InetAddress.getByName(m.group(2));
                    int n = port = m.group(1) != null ? 636 : 389;
                    if (m.group(3) != null) {
                        port = Integer.parseInt(m.group(3));
                    }
                    Socket s = new Socket(adrs, port);
                    s.close();
                }
                catch (UnknownHostException x) {
                    return FormValidation.error((String)Messages.LDAPSecurityRealm_UnknownHost((Object)x.getMessage()));
                }
                catch (IOException x) {
                    return FormValidation.error((Throwable)x, (String)Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)x.getMessage()));
                }
                return FormValidation.error((Throwable)e, (String)Messages.LDAPSecurityRealm_UnableToConnect((Object)server, (Object)e));
            }
            catch (NumberFormatException x) {
                return FormValidation.error((String)Messages.LDAPSecurityRealm_InvalidPortNumber());
            }
        }
    }

    public static final class AuthoritiesPopulatorImpl
    extends DefaultLdapAuthoritiesPopulator {
        String rolePrefix = "ROLE_";
        boolean convertToUpperCase = true;

        public AuthoritiesPopulatorImpl(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
            super(initialDirContextFactory, Util.fixNull((String)groupSearchBase));
            super.setRolePrefix("");
            super.setConvertToUpperCase(false);
        }

        protected Set getAdditionalRoles(LdapUserDetails ldapUser) {
            return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY);
        }

        public void setRolePrefix(String rolePrefix) {
            this.rolePrefix = rolePrefix;
        }

        public void setConvertToUpperCase(boolean convertToUpperCase) {
            this.convertToUpperCase = convertToUpperCase;
        }

        public Set getGroupMembershipRoles(String userDn, String username) {
            Set names = super.getGroupMembershipRoles(userDn, username);
            HashSet<GrantedAuthorityImpl> r = new HashSet<GrantedAuthorityImpl>(names.size() * 2);
            r.addAll(names);
            for (GrantedAuthority ga : names) {
                String role = ga.getAuthority();
                if (this.convertToUpperCase) {
                    role = role.toUpperCase();
                }
                r.add(new GrantedAuthorityImpl(this.rolePrefix + role));
            }
            return r;
        }
    }

    @Extension
    public static final class MailAdressResolverImpl
    extends MailAddressResolver {
        public String findMailAddressFor(User u) {
            SecurityRealm realm = Jenkins.getInstance().getSecurityRealm();
            if (!(realm instanceof LDAPSecurityRealm)) {
                return null;
            }
            if (((LDAPSecurityRealm)realm).disableMailAddressResolver) {
                LOGGER.info("LDAPSecurityRealm MailAddressResolver is disabled");
                return null;
            }
            try {
                LdapUserDetails details = (LdapUserDetails)realm.getSecurityComponents().userDetails.loadUserByUsername(u.getId());
                Attribute mail = details.getAttributes().get("mail");
                if (mail == null) {
                    return null;
                }
                return (String)mail.get();
            }
            catch (UsernameNotFoundException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (DataAccessException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (NamingException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
            catch (AcegiSecurityException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
        }
    }

    public static class LDAPUserDetailsService
    implements UserDetailsService {
        public final LdapUserSearch ldapSearch;
        public final LdapAuthoritiesPopulator authoritiesPopulator;
        private final LRUMap attributesCache = new LRUMap(32);

        LDAPUserDetailsService(WebApplicationContext appContext) {
            this.ldapSearch = (LdapUserSearch)SecurityRealm.findBean(LdapUserSearch.class, (ApplicationContext)appContext);
            this.authoritiesPopulator = (LdapAuthoritiesPopulator)SecurityRealm.findBean(LdapAuthoritiesPopulator.class, (ApplicationContext)appContext);
        }

        LDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator) {
            this.ldapSearch = ldapSearch;
            this.authoritiesPopulator = authoritiesPopulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LdapUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            try {
                LDAPSecurityRealm ldapSecurityRealm;
                LdapUserDetails ldapUser;
                LDAPSecurityRealm lDAPSecurityRealm;
                LDAPSecurityRealm ldapSecurityRealm2;
                SecurityRealm securityRealm;
                SecurityRealm securityRealm2 = securityRealm = Jenkins.getInstance() == null ? null : Jenkins.getInstance().getSecurityRealm();
                if (securityRealm instanceof LDAPSecurityRealm && securityRealm.getSecurityComponents().userDetails == this && (ldapSecurityRealm2 = (LDAPSecurityRealm)securityRealm).cache != null) {
                    CacheEntry cached;
                    lDAPSecurityRealm = ldapSecurityRealm2;
                    synchronized (lDAPSecurityRealm) {
                        cached = ldapSecurityRealm2.userDetailsCache != null ? (CacheEntry)ldapSecurityRealm2.userDetailsCache.get(username) : null;
                    }
                    if (cached != null && cached.isValid()) {
                        return (LdapUserDetails)cached.getValue();
                    }
                }
                if ((ldapUser = this.ldapSearch.searchForUser(username)) != null) {
                    GrantedAuthority[] extraAuthorities;
                    LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
                    Attributes v = ldapUser.getAttributes();
                    if (v instanceof BasicAttributes) {
                        LRUMap lRUMap = this.attributesCache;
                        synchronized (lRUMap) {
                            Attributes vv = (Attributes)this.attributesCache.get((Object)v);
                            if (vv == null) {
                                vv = v;
                                this.attributesCache.put((Object)v, (Object)vv);
                            }
                            user.setAttributes(vv);
                        }
                    }
                    for (GrantedAuthority extraAuthority : extraAuthorities = this.authoritiesPopulator.getGrantedAuthorities(ldapUser)) {
                        user.addAuthority(extraAuthority);
                    }
                    ldapUser = user.createUserDetails();
                }
                if (securityRealm instanceof LDAPSecurityRealm && securityRealm.getSecurityComponents().userDetails == this && (ldapSecurityRealm = (LDAPSecurityRealm)securityRealm).cache != null) {
                    lDAPSecurityRealm = ldapSecurityRealm;
                    synchronized (lDAPSecurityRealm) {
                        if (ldapSecurityRealm.userDetailsCache == null) {
                            ldapSecurityRealm.userDetailsCache = new CacheMap(ldapSecurityRealm.cache.getSize());
                        }
                        ldapSecurityRealm.userDetailsCache.put(username, new CacheEntry<LdapUserDetails>(ldapSecurityRealm.cache.getTtl(), ldapUser));
                    }
                }
                return ldapUser;
            }
            catch (LdapDataAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to search LDAP for username=" + username, e);
                throw new UserMayOrMayNotExistException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

