/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Main;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.AbstractPasswordBasedSecurityRealm;
import hudson.security.GroupDetails;
import hudson.security.Messages;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.tasks.MailAddressResolver;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Scrambler;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import jenkins.model.IdStrategy;
import jenkins.model.Jenkins;
import jenkins.security.plugins.ldap.FromGroupSearchLDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPConfiguration;
import jenkins.security.plugins.ldap.LDAPExtendedTemplate;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapEntryMapper;
import org.acegisecurity.ldap.LdapUserSearch;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.ldap.LdapAuthenticationProvider;
import org.acegisecurity.providers.ldap.LdapAuthenticator;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.web.context.WebApplicationContext;

public class LDAPSecurityRealm
extends AbstractPasswordBasedSecurityRealm {
    private static final boolean FORCE_USERNAME_LOWERCASE = Boolean.getBoolean(LDAPSecurityRealm.class.getName() + ".forceUsernameLowercase");
    private static final boolean FORCE_GROUPNAME_LOWERCASE = Boolean.getBoolean(LDAPSecurityRealm.class.getName() + ".forceGroupnameLowercase");
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient String server;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient String rootDN;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient boolean inhibitInferRootDN;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient String userSearchBase;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient String userSearch;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient String groupSearchBase;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient String groupSearchFilter;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public transient String groupMembershipFilter;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient LDAPGroupMembershipStrategy groupMembershipStrategy;
    @Deprecated
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    @Restricted(value={NoExternalUse.class})
    public transient String managerDN;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    private transient String managerPassword;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient Secret managerPasswordSecret;
    @SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="This public field is exposed to the plugin's API")
    public final boolean disableMailAddressResolver;
    private List<LDAPConfiguration> configurations;
    private final CacheConfiguration cache;
    private transient Map<String, CacheEntry<LdapUserDetails>> userDetailsCache = null;
    private transient Map<String, CacheEntry<GroupDetailsImpl>> groupDetailsCache = null;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient Map<String, String> extraEnvVars;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient String displayNameAttributeName;
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    private transient String mailAddressAttributeName;
    private final IdStrategy userIdStrategy;
    private final IdStrategy groupIdStrategy;
    private boolean disableRolePrefixing;
    @Restricted(value={NoExternalUse.class})
    public static final Logger LOGGER = Logger.getLogger(LDAPSecurityRealm.class.getName());
    public static final String GROUP_SEARCH = System.getProperty(LDAPSecurityRealm.class.getName() + ".groupSearch", "(& (cn={0}) (| (objectclass=groupOfNames) (objectclass=groupOfUniqueNames) (objectclass=posixGroup)))");

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, false);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, null, null, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, managerPassword, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, null, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, String managerPassword, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipFilter, managerDN, Secret.fromString((String)managerPassword), inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, null, null);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, String groupMembershipFilter, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, new FromGroupSearchLDAPGroupMembershipStrategy(groupMembershipFilter), managerDN, managerPasswordSecret, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, displayNameAttributeName, mailAddressAttributeName);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        this(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipStrategy, managerDN, managerPasswordSecret, inhibitInferRootDN, disableMailAddressResolver, cache, environmentProperties, displayNameAttributeName, mailAddressAttributeName, IdStrategy.CASE_INSENSITIVE, IdStrategy.CASE_INSENSITIVE);
    }

    @Deprecated
    public LDAPSecurityRealm(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, boolean disableMailAddressResolver, CacheConfiguration cache, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName, IdStrategy userIdStrategy, IdStrategy groupIdStrategy) {
        this(LDAPSecurityRealm.createLdapConfiguration(server, rootDN, userSearchBase, userSearch, groupSearchBase, groupSearchFilter, groupMembershipStrategy, managerDN, managerPasswordSecret, inhibitInferRootDN, environmentProperties, displayNameAttributeName, mailAddressAttributeName), disableMailAddressResolver, cache, userIdStrategy, groupIdStrategy);
    }

    @DataBoundConstructor
    public LDAPSecurityRealm(List<LDAPConfiguration> configurations, boolean disableMailAddressResolver, CacheConfiguration cache, IdStrategy userIdStrategy, IdStrategy groupIdStrategy) {
        if (configurations == null || configurations.isEmpty()) {
            throw new IllegalArgumentException(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AtLeastOne());
        }
        if (!(configurations.size() <= 1 || Main.isUnitTest && Boolean.getBoolean(LDAPSecurityRealm.class.getName() + "do a bad thing during testing"))) {
            for (int i = 0; i < configurations.size(); ++i) {
                LDAPConfiguration ci = configurations.get(i);
                for (int k = i + 1; k < configurations.size(); ++k) {
                    LDAPConfiguration ck = configurations.get(k);
                    if (!ci.isConfiguration(ck.getId())) continue;
                    throw new IllegalArgumentException(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NotSameServer());
                }
            }
        }
        this.configurations = configurations;
        this.disableMailAddressResolver = disableMailAddressResolver;
        this.cache = cache;
        this.userIdStrategy = userIdStrategy;
        this.groupIdStrategy = groupIdStrategy;
    }

    private static List<LDAPConfiguration> createLdapConfiguration(String server, String rootDN, String userSearchBase, String userSearch, String groupSearchBase, String groupSearchFilter, LDAPGroupMembershipStrategy groupMembershipStrategy, String managerDN, Secret managerPasswordSecret, boolean inhibitInferRootDN, EnvironmentProperty[] environmentProperties, String displayNameAttributeName, String mailAddressAttributeName) {
        LDAPConfiguration conf = new LDAPConfiguration(server, rootDN, inhibitInferRootDN, managerDN, managerPasswordSecret);
        conf.setUserSearchBase(userSearchBase);
        conf.setUserSearch(userSearch);
        conf.setGroupSearchBase(groupSearchBase);
        conf.setGroupSearchFilter(groupSearchFilter);
        conf.setGroupMembershipStrategy(groupMembershipStrategy);
        conf.setEnvironmentProperties(environmentProperties);
        conf.setDisplayNameAttributeName(displayNameAttributeName);
        conf.setMailAddressAttributeName(mailAddressAttributeName);
        return Collections.singletonList(conf);
    }

    public List<LDAPConfiguration> getConfigurations() {
        return this.configurations;
    }

    private boolean hasConfiguration() {
        return this.configurations != null && !this.configurations.isEmpty();
    }

    public boolean isDisableRolePrefixing() {
        return this.disableRolePrefixing;
    }

    @DataBoundSetter
    public void setDisableRolePrefixing(boolean disableRolePrefixing) {
        this.disableRolePrefixing = disableRolePrefixing;
    }

    private Object readResolve() {
        if (this.managerPassword != null) {
            this.managerPasswordSecret = Secret.fromString((String)Scrambler.descramble((String)this.managerPassword));
            this.managerPassword = null;
        }
        if (this.server != null) {
            LDAPConfiguration conf = new LDAPConfiguration(this.server, this.rootDN, this.inhibitInferRootDN, this.managerDN, this.managerPasswordSecret);
            this.server = null;
            this.rootDN = null;
            this.managerDN = null;
            this.managerPasswordSecret = null;
            conf.setMailAddressAttributeName(this.mailAddressAttributeName);
            this.mailAddressAttributeName = null;
            conf.setDisplayNameAttributeName(this.displayNameAttributeName);
            this.displayNameAttributeName = null;
            conf.setExtraEnvVars(this.extraEnvVars);
            this.extraEnvVars = null;
            if (this.groupMembershipStrategy == null) {
                conf.setGroupMembershipStrategy(new FromGroupSearchLDAPGroupMembershipStrategy(this.groupMembershipFilter));
                this.groupMembershipFilter = null;
            } else {
                conf.setGroupMembershipStrategy(this.groupMembershipStrategy);
                this.groupMembershipStrategy = null;
            }
            conf.setGroupSearchBase(this.groupSearchBase);
            this.groupSearchBase = null;
            conf.setGroupSearchFilter(this.groupSearchFilter);
            this.groupSearchFilter = null;
            conf.setUserSearch(this.userSearch);
            this.userSearch = null;
            conf.setUserSearchBase(this.userSearchBase);
            this.userSearchBase = null;
            this.configurations = new ArrayList<LDAPConfiguration>();
            this.configurations.add(conf);
        }
        return this;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getServerUrl() {
        return this.hasConfiguration() ? this.configurations.get(0).getServerUrl() : null;
    }

    public IdStrategy getUserIdStrategy() {
        return this.userIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.userIdStrategy;
    }

    public IdStrategy getGroupIdStrategy() {
        return this.groupIdStrategy == null ? IdStrategy.CASE_INSENSITIVE : this.groupIdStrategy;
    }

    public CacheConfiguration getCache() {
        return this.cache;
    }

    public Integer getCacheSize() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getSize());
    }

    public Integer getCacheTTL() {
        return this.cache == null ? null : Integer.valueOf(this.cache.getTtl());
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getGroupMembershipFilter() {
        return this.hasConfiguration() ? this.configurations.get(0).getGroupSearchFilter() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public LDAPGroupMembershipStrategy getGroupMembershipStrategy() {
        return this.hasConfiguration() ? this.configurations.get(0).getGroupMembershipStrategy() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getGroupSearchFilter() {
        return this.hasConfiguration() ? this.configurations.get(0).getGroupSearchFilter() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public Map<String, String> getExtraEnvVars() {
        return this.hasConfiguration() ? this.configurations.get(0).getExtraEnvVars() : Collections.emptyMap();
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public EnvironmentProperty[] getEnvironmentProperties() {
        return this.hasConfiguration() ? this.configurations.get(0).getEnvironmentProperties() : new EnvironmentProperty[]{};
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getManagerPassword() {
        return this.hasConfiguration() ? this.configurations.get(0).getManagerPassword() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public Secret getManagerPasswordSecret() {
        return this.hasConfiguration() ? this.configurations.get(0).getManagerPasswordSecret() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getLDAPURL() {
        return this.hasConfiguration() ? this.configurations.get(0).getLDAPURL() : null;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getDisplayNameAttributeName() {
        return this.hasConfiguration() ? this.configurations.get(0).getDisplayNameAttributeName() : "displayname";
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public String getMailAddressAttributeName() {
        return this.hasConfiguration() ? this.configurations.get(0).getMailAddressAttributeName() : "mail";
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public LDAPConfiguration getConfigurationFor(LdapUserDetails d) {
        if (d instanceof DelegatedLdapUserDetails) {
            return this.getConfigurationFor(((DelegatedLdapUserDetails)d).getConfigurationId());
        }
        if (this.hasConfiguration() && this.configurations.size() == 1) {
            return this.configurations.get(0);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean hasMultiConfiguration() {
        return this.hasConfiguration() && this.configurations.size() > 1;
    }

    @CheckForNull
    @Restricted(value={NoExternalUse.class})
    public LDAPConfiguration getConfigurationFor(String configurationId) {
        if (this.configurations != null) {
            for (LDAPConfiguration configuration : this.configurations) {
                if (!configuration.isConfiguration(configurationId)) continue;
                return configuration;
            }
            if (this.configurations.size() == 1) {
                return this.configurations.get(0);
            }
        }
        return null;
    }

    @CheckForNull
    private static LDAPConfiguration _getConfigurationFor(String configurationId) {
        SecurityRealm securityRealm = Jenkins.getActiveInstance().getSecurityRealm();
        if (securityRealm instanceof LDAPSecurityRealm) {
            return ((LDAPSecurityRealm)securityRealm).getConfigurationFor(configurationId);
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static String toProviderUrl(String serverUrl, String rootDN) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String s : serverUrl.split("\\s+")) {
            if (s.trim().length() == 0 || (s = LDAPSecurityRealm.getProviderUrl(s, rootDN)) == null) continue;
            if (first) {
                first = false;
            } else {
                buf.append(' ');
            }
            buf.append(s);
        }
        return buf.toString();
    }

    private static String getProviderUrl(String server, String rootDN) {
        if (!(server = LDAPSecurityRealm.addPrefix(server)).endsWith("/")) {
            server = server + '/';
        }
        if (rootDN != null && !(rootDN = rootDN.trim()).isEmpty()) {
            try {
                server = server + new URI(null, null, rootDN, null).toASCIIString();
            }
            catch (URISyntaxException e) {
                LOGGER.log(Level.WARNING, "Unable to build URL with rootDN: " + server, e);
                return null;
            }
        }
        return server;
    }

    @Nonnull
    public SecurityRealm.SecurityComponents createSecurityComponents() {
        if (this.configurations.size() > 1) {
            DelegateLDAPUserDetailsService details = new DelegateLDAPUserDetailsService();
            LDAPAuthenticationManager manager = new LDAPAuthenticationManager(details);
            for (LDAPConfiguration conf : this.configurations) {
                WebApplicationContext appContext = conf.createApplicationContext(this, false);
                manager.addDelegate((AuthenticationManager)LDAPSecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)appContext), conf.getId());
                details.addDelegate(new LDAPUserDetailsService(appContext, conf.getGroupMembershipStrategy(), conf.getId()));
            }
            return new SecurityRealm.SecurityComponents((AuthenticationManager)manager, (UserDetailsService)details);
        }
        LDAPConfiguration conf = this.configurations.get(0);
        WebApplicationContext appContext = conf.createApplicationContext(this, true);
        LDAPAuthenticationManager manager = new LDAPAuthenticationManager();
        manager.addDelegate((AuthenticationManager)LDAPSecurityRealm.findBean(AuthenticationManager.class, (ApplicationContext)appContext), "");
        return new SecurityRealm.SecurityComponents((AuthenticationManager)manager, (UserDetailsService)new LDAPUserDetailsService(appContext, conf.getGroupMembershipStrategy(), null));
    }

    protected UserDetails authenticate(String username, String password) throws AuthenticationException {
        return this.updateUserDetails((UserDetails)this.getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)LDAPSecurityRealm.fixUsername(username), (Object)password)).getPrincipal());
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.updateUserDetails(this.getSecurityComponents().userDetails.loadUserByUsername(LDAPSecurityRealm.fixUsername(username)));
    }

    public Authentication updateUserDetails(Authentication authentication) {
        this.updateUserDetails((UserDetails)authentication.getPrincipal());
        return authentication;
    }

    public UserDetails updateUserDetails(UserDetails userDetails) {
        if (userDetails instanceof LdapUserDetails) {
            this.updateUserDetails((LdapUserDetails)userDetails);
        }
        return userDetails;
    }

    public LdapUserDetails updateUserDetails(LdapUserDetails d) {
        Attribute attribute;
        String mailAddressAttributeName;
        String displayNameAttributeName;
        User u = User.get((String)LDAPSecurityRealm.fixUsername(d.getUsername()));
        LDAPConfiguration configuration = this.getConfigurationFor(d);
        if (configuration != null) {
            displayNameAttributeName = configuration.getDisplayNameAttributeName();
            mailAddressAttributeName = configuration.getMailAddressAttributeName();
            if (StringUtils.isEmpty((String)displayNameAttributeName)) {
                displayNameAttributeName = "displayname";
            }
            if (StringUtils.isEmpty((String)mailAddressAttributeName)) {
                mailAddressAttributeName = "mail";
            }
        } else {
            displayNameAttributeName = "displayname";
            mailAddressAttributeName = "mail";
        }
        try {
            String displayName;
            attribute = d.getAttributes().get(displayNameAttributeName);
            String string = displayName = attribute == null ? null : (String)attribute.get();
            if (StringUtils.isNotBlank((String)displayName) && u.getId().equals(u.getFullName()) && !u.getFullName().equals(displayName)) {
                u.setFullName(displayName);
            }
        }
        catch (NamingException e) {
            LOGGER.log(Level.FINEST, "Could not retrieve display name attribute", e);
        }
        if (!this.disableMailAddressResolver) {
            try {
                Mailer.UserProperty existing;
                String mailAddress;
                attribute = d.getAttributes().get(mailAddressAttributeName);
                String string = mailAddress = attribute == null ? null : (String)attribute.get();
                if (StringUtils.isNotBlank((String)mailAddress) && ((existing = (Mailer.UserProperty)u.getProperty(Mailer.UserProperty.class)) == null || !existing.hasExplicitlyConfiguredAddress())) {
                    u.addProperty((UserProperty)new Mailer.UserProperty(mailAddress));
                }
            }
            catch (NamingException e) {
                LOGGER.log(Level.FINEST, "Could not retrieve email address attribute", e);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to associate the e-mail address", e);
            }
        }
        return d;
    }

    public GroupDetails loadGroupByGroupname(String groupname) throws UsernameNotFoundException, DataAccessException {
        return this.loadGroupByGroupname(groupname, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupDetails loadGroupByGroupname(String groupname, boolean fetchMembers) throws UsernameNotFoundException, DataAccessException {
        GroupDetailsImpl group;
        GroupDetailsImpl cachedGroup;
        LDAPSecurityRealm lDAPSecurityRealm;
        groupname = LDAPSecurityRealm.fixGroupname(groupname);
        if (this.cache != null) {
            CacheEntry<GroupDetailsImpl> cached;
            lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                cached = this.groupDetailsCache != null ? this.groupDetailsCache.get(groupname) : null;
            }
            if (cached != null && cached.isValid()) {
                GroupDetailsImpl cachedValue = cached.getValue();
                cachedGroup = !fetchMembers || cachedValue.getMembers() != null ? cachedValue : null;
            } else {
                cachedGroup = null;
            }
        } else {
            cachedGroup = null;
        }
        GroupDetailsImpl groupDetailsImpl = group = cachedGroup != null ? cachedGroup : this.searchForGroupName(groupname, fetchMembers);
        if (this.cache != null && cachedGroup == null) {
            lDAPSecurityRealm = this;
            synchronized (lDAPSecurityRealm) {
                if (this.groupDetailsCache == null) {
                    this.groupDetailsCache = new CacheMap<String, GroupDetailsImpl>(this.cache.getSize());
                }
                this.groupDetailsCache.put(groupname, new CacheEntry<GroupDetailsImpl>(this.cache.getTtl(), group));
            }
        }
        return group;
    }

    @Nonnull
    private GroupDetailsImpl searchForGroupName(String groupname, boolean fetchMembers) throws UsernameNotFoundException, DataAccessException {
        for (LDAPConfiguration conf : this.configurations) {
            try {
                String searchBase = conf.getGroupSearchBase() != null ? conf.getGroupSearchBase() : "";
                String searchFilter = conf.getGroupSearchFilter() != null ? conf.getGroupSearchFilter() : GROUP_SEARCH;
                LDAPExtendedTemplate template = conf.getLdapTemplate();
                GroupDetailsImpl groupDetails = (GroupDetailsImpl)((Object)template.searchForFirstEntry(searchBase, searchFilter, new Object[]{groupname}, new String[0], new GroupDetailsMapper()));
                if (groupDetails == null) continue;
                if (fetchMembers) {
                    Set<String> members = conf.getGroupMembershipStrategy().getGroupMembers(groupDetails.getDn(), conf);
                    groupDetails = new GroupDetailsImpl(groupDetails.getDn(), groupDetails.getName(), members);
                }
                return groupDetails;
            }
            catch (DataAccessException e) {
                LOGGER.log(Level.WARNING, String.format("Failed communication with ldap server %s (%s)", conf.getId(), conf.getServer()), e);
                throw e;
            }
        }
        throw new UsernameNotFoundException(groupname);
    }

    private static String fixGroupname(String groupname) {
        return FORCE_GROUPNAME_LOWERCASE ? groupname.toLowerCase() : groupname;
    }

    private static String fixUsername(String username) {
        return FORCE_USERNAME_LOWERCASE ? username.toLowerCase() : username;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private static String addPrefix(String server) {
        if (server.contains("://")) {
            return server;
        }
        return "ldap://" + server;
    }

    public static class EnvironmentProperty
    extends AbstractDescribableImpl<EnvironmentProperty>
    implements Serializable {
        private final String name;
        private final String value;

        @DataBoundConstructor
        public EnvironmentProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public static Map<String, String> toMap(List<EnvironmentProperty> properties) {
            if (properties != null) {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                for (EnvironmentProperty property : properties) {
                    result.put(property.getName(), property.getValue());
                }
                return result;
            }
            return null;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<EnvironmentProperty> {
            public String getDisplayName() {
                return "";
            }
        }
    }

    private static class CacheMap<K, V>
    extends LinkedHashMap<K, CacheEntry<V>> {
        private final int cacheSize;

        public CacheMap(int cacheSize) {
            super(cacheSize + 1);
            this.cacheSize = cacheSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, CacheEntry<V>> eldest) {
            return this.size() > this.cacheSize || eldest.getValue() == null || !eldest.getValue().isValid();
        }
    }

    private static class CacheEntry<T> {
        private final long expires;
        private final T value;

        public CacheEntry(int ttlSeconds, T value) {
            this.expires = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(ttlSeconds);
            this.value = value;
        }

        public T getValue() {
            return this.value;
        }

        public boolean isValid() {
            return System.currentTimeMillis() < this.expires;
        }
    }

    public static class CacheConfiguration
    extends AbstractDescribableImpl<CacheConfiguration> {
        private final int size;
        private final int ttl;

        @DataBoundConstructor
        public CacheConfiguration(int size, int ttl) {
            this.size = Math.max(10, Math.min(size, 1000));
            this.ttl = Math.max(30, Math.min(ttl, 3600));
        }

        public int getSize() {
            return this.size;
        }

        public int getTtl() {
            return this.ttl;
        }

        @Extension
        public static class DescriptorImpl
        extends Descriptor<CacheConfiguration> {
            public String getDisplayName() {
                return "";
            }

            public ListBoxModel doFillSizeItems() {
                ListBoxModel m = new ListBoxModel();
                m.add("10");
                m.add("20");
                m.add("50");
                m.add("100");
                m.add("200");
                m.add("500");
                m.add("1000");
                return m;
            }

            public ListBoxModel doFillTtlItems() {
                ListBoxModel m = new ListBoxModel();
                for (int ttl : new int[]{30, 60, 120, 300, 600, 900, 1800, 3600}) {
                    m.add(Util.getTimeSpanString((long)((long)ttl * 1000L)), Integer.toString(ttl));
                }
                return m;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public static final String DEFAULT_DISPLAYNAME_ATTRIBUTE_NAME = "displayname";
        public static final String DEFAULT_MAILADDRESS_ATTRIBUTE_NAME = "mail";
        public static final String DEFAULT_USER_SEARCH = "uid={0}";

        public String getDisplayName() {
            return Messages.LDAPSecurityRealm_DisplayName();
        }

        public IdStrategy getDefaultIdStrategy() {
            return IdStrategy.CASE_INSENSITIVE;
        }

        public SecurityRealm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (!formData.has("configurations")) {
                throw new Descriptor.FormException(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
            }
            Object configurations = formData.get("configurations");
            if (configurations instanceof JSONArray) {
                if (((JSONArray)configurations).isEmpty()) {
                    throw new Descriptor.FormException(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
                }
                if (((JSONArray)configurations).size() > 1) {
                    List confs = req.bindJSONToList(LDAPConfiguration.class, configurations);
                    for (int i = 0; i < confs.size(); ++i) {
                        LDAPConfiguration ci = (LDAPConfiguration)((Object)confs.get(i));
                        for (int k = i + 1; k < confs.size(); ++k) {
                            LDAPConfiguration ck = (LDAPConfiguration)((Object)confs.get(k));
                            if (!ci.isConfiguration(ck.getId())) continue;
                            throw new Descriptor.FormException(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NotSameServer(), "configurations");
                        }
                    }
                }
            } else {
                if (!(configurations instanceof JSONObject)) {
                    throw new Descriptor.FormException(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
                }
                if (((JSONObject)configurations).isNullObject()) {
                    throw new Descriptor.FormException(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AtLeastOne(), "configurations");
                }
            }
            return (SecurityRealm)super.newInstance(req, formData);
        }

        public boolean hasCustomBindScript() {
            return LDAPConfiguration.getLdapBindOverrideFile(Jenkins.getActiveInstance()).exists();
        }

        @RequirePOST
        public FormValidation doValidate(StaplerRequest req) throws Exception {
            if (!Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            JSONObject json = JSONObject.fromObject((Object)IOUtils.toString((InputStream)req.getInputStream()));
            String user = json.getString("testUser");
            String password = json.getString("testPassword");
            JSONObject realmCfg = json.getJSONObject("useSecurity").getJSONObject("realm");
            LDAPSecurityRealm realm = (LDAPSecurityRealm)((Object)req.bindJSON(LDAPSecurityRealm.class, realmCfg));
            return this.validate(realm, user, password);
        }

        private void rsp(StringBuilder response, String kind, String testId, String message, Object ... extras) {
            response.append("<div class='").append(kind).append("' data-test='");
            response.append(Util.escape((String)testId));
            response.append("'>");
            response.append(message);
            boolean needBr = true;
            for (Object extra : extras) {
                if (extra instanceof String) {
                    if (needBr) {
                        response.append("<br/>");
                    }
                    response.append(extra);
                    needBr = true;
                    continue;
                }
                if (!(extra instanceof Collection)) continue;
                response.append("<ul>");
                for (String item : (Collection)extra) {
                    response.append("<li>");
                    response.append(item);
                    response.append("</li>");
                }
                response.append("</ul>");
                needBr = false;
            }
            response.append("</div>");
        }

        private void ok(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "validation-ok", testId, message, extras);
        }

        private void warning(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "warning", testId, message, extras);
        }

        private void error(StringBuilder response, String testId, String message, Object ... extras) {
            this.rsp(response, "error", testId, message, extras);
        }

        public FormValidation validate(LDAPSecurityRealm realm, String user, String password) {
            LDAPConfiguration.LDAPConfigurationDescriptor confDescriptor = (LDAPConfiguration.LDAPConfigurationDescriptor)Jenkins.getActiveInstance().getDescriptorByType(LDAPConfiguration.LDAPConfigurationDescriptor.class);
            for (LDAPConfiguration configuration : realm.getConfigurations()) {
                FormValidation connnectionCheck = confDescriptor.doCheckServer(configuration.getServerUrl(), configuration.getManagerDN(), configuration.getManagerPasswordSecret());
                if (connnectionCheck.kind == FormValidation.Kind.OK) continue;
                return connnectionCheck;
            }
            StringBuilder response = new StringBuilder(1024);
            response.append("<div>").append(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_LoginHeader()).append("</div>");
            boolean potentialLockout = false;
            boolean likelyLockout = false;
            LdapUserDetails loginDetails = null;
            try {
                loginDetails = (LdapUserDetails)realm.getSecurityComponents().manager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)LDAPSecurityRealm.fixUsername(user), (Object)password)).getPrincipal();
                this.ok(response, "authentication", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AuthenticationSuccessful(), new Object[0]);
            }
            catch (AuthenticationException e) {
                if (StringUtils.isBlank((String)password)) {
                    this.warning(response, "authentication", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AuthenticationFailedEmptyPass(user), new Object[0]);
                }
                this.error(response, "authentication", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AuthenticationFailed(user), new Object[0]);
                potentialLockout = true;
                likelyLockout = true;
            }
            HashSet<String> loginAuthorities = new HashSet<String>();
            if (loginDetails != null) {
                this.ok(response, "authentication-username", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserId(Util.escape((String)loginDetails.getUsername())), new Object[0]);
                this.ok(response, "authentication-dn", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserDn(Util.escape((String)loginDetails.getDn())), new Object[0]);
                LDAPConfiguration loginConfiguration = realm.getConfigurationFor(loginDetails);
                assert (loginConfiguration != null);
                if (realm.hasMultiConfiguration()) {
                    this.ok(response, "authentication-configuration", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserConfiguration(Util.escape((String)loginConfiguration.getServer())), new Object[0]);
                }
                this.validateDisplayName(loginConfiguration, response, loginDetails, "authentication-displayname");
                if (!realm.disableMailAddressResolver) {
                    this.validateEmailAddress(loginConfiguration, response, loginDetails, "authentication-email");
                }
                for (GrantedAuthority a : loginDetails.getAuthorities()) {
                    loginAuthorities.add(a.getAuthority());
                }
                if (loginDetails.getAuthorities().length < 1) {
                    this.error(response, "authentication-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoGroupMembership(), new Object[0]);
                } else if (loginDetails.getAuthorities().length == 1) {
                    this.warning(response, "authentication-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembership(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembershipDetail());
                } else {
                    ArrayList<String> authorities = new ArrayList<String>();
                    for (GrantedAuthority a : loginDetails.getAuthorities()) {
                        if (SecurityRealm.AUTHENTICATED_AUTHORITY.equals(a)) continue;
                        authorities.add("<code>" + Util.escape((String)a.getAuthority()) + "</code>");
                    }
                    this.ok(response, "authentication-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembership(), authorities);
                }
            }
            response.append("<div>").append(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_LookupHeader()).append("</div>");
            LdapUserDetails lookUpDetails = null;
            try {
                lookUpDetails = (LdapUserDetails)realm.getSecurityComponents().userDetails.loadUserByUsername(LDAPSecurityRealm.fixUsername(user));
                this.ok(response, "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupSuccessful(), new Object[0]);
            }
            catch (UserMayOrMayNotExistException e1) {
                this.rsp(response, loginDetails == null ? "warning" : "error", "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupInconclusive(user), this.isAnyManagerBlank(realm) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnRequired() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions());
            }
            catch (UsernameNotFoundException e1) {
                this.rsp(response, loginDetails == null ? "warning" : "error", "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupDoesNotExist(user), this.isAnyManagerBlank(realm) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnRequired() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupSettingsCorrect());
            }
            catch (LdapDataAccessException e) {
                Throwable cause;
                for (cause = e.getCause(); cause != null && !(cause instanceof BadCredentialsException); cause = cause.getCause()) {
                }
                if (cause != null) {
                    this.error(response, "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupBadCredentials(), this.isAnyManagerBlank(realm) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnCorrect() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupManagerDnPermissions());
                    potentialLockout = true;
                }
                this.error(response, "lookup", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserLookupFailed(user), Util.escape((String)e.getLocalizedMessage()));
                potentialLockout = true;
            }
            if (loginDetails == null && lookUpDetails != null) {
                this.ok(response, "lookup-username", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserId(Util.escape((String)lookUpDetails.getUsername())), new Object[0]);
                this.ok(response, "lookup-dn", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserDn(Util.escape((String)lookUpDetails.getDn())), new Object[0]);
                LDAPConfiguration lookupConfiguration = realm.getConfigurationFor(lookUpDetails);
                assert (lookupConfiguration != null);
                if (realm.hasMultiConfiguration()) {
                    this.ok(response, "lookup-configuration", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserConfiguration(Util.escape((String)lookupConfiguration.getServer())), new Object[0]);
                }
                this.validateDisplayName(lookupConfiguration, response, lookUpDetails, "lookup-displayname");
                if (!realm.disableMailAddressResolver) {
                    this.validateEmailAddress(lookupConfiguration, response, lookUpDetails, "lookup-email");
                }
            }
            HashSet<String> lookupAuthorities = new HashSet<String>();
            if (lookUpDetails != null) {
                for (GrantedAuthority a : lookUpDetails.getAuthorities()) {
                    lookupAuthorities.add(a.getAuthority());
                }
                if (loginDetails == null || !loginAuthorities.equals(lookupAuthorities)) {
                    if (lookUpDetails.getAuthorities().length < 1) {
                        this.error(response, "lookup-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoGroupMembership(), new Object[0]);
                    } else if (lookUpDetails.getAuthorities().length == 1) {
                        this.warning(response, "lookup-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembership(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_BasicGroupMembershipDetail());
                    } else {
                        ArrayList<String> authorities = new ArrayList<String>();
                        for (GrantedAuthority a : lookUpDetails.getAuthorities()) {
                            if (SecurityRealm.AUTHENTICATED_AUTHORITY.equals(a)) continue;
                            authorities.add("<code>" + Util.escape((String)a.getAuthority()) + "</code>");
                        }
                        this.ok(response, "lookup-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembership(), authorities);
                    }
                }
            }
            if (loginDetails != null && lookUpDetails != null) {
                Class<?> lookUpValue;
                Attribute lookUpAttr;
                LDAPConfiguration loginConfiguration = realm.getConfigurationFor(loginDetails);
                LDAPConfiguration lookupConfiguration = realm.getConfigurationFor(lookUpDetails);
                assert (loginConfiguration == lookupConfiguration) : "The lookup user details and login user details are not from the same server configuration";
                if (!StringUtils.equals((String)loginDetails.getUsername(), (String)lookUpDetails.getUsername())) {
                    this.error(response, "consistency-username", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UsernameMismatch(loginDetails.getUsername(), lookUpDetails.getUsername()), new Object[0]);
                    potentialLockout = true;
                }
                if (!StringUtils.equals((String)loginDetails.getDn(), (String)lookUpDetails.getDn())) {
                    this.error(response, "consistency-dn", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_DnMismatch(loginDetails.getDn(), lookUpDetails.getDn()), new Object[0]);
                    potentialLockout = true;
                }
                if (StringUtils.isNotBlank((String)loginConfiguration.getDisplayNameAttributeName())) {
                    Class<?> loginValue;
                    Attribute loginAttr = loginDetails.getAttributes().get(loginConfiguration.getDisplayNameAttributeName());
                    try {
                        loginValue = loginAttr == null ? null : loginAttr.get();
                    }
                    catch (NamingException e) {
                        loginValue = e.getClass();
                    }
                    lookUpAttr = lookUpDetails.getAttributes().get(lookupConfiguration.getDisplayNameAttributeName());
                    try {
                        lookUpValue = lookUpAttr == null ? null : lookUpAttr.get();
                    }
                    catch (NamingException e) {
                        lookUpValue = e.getClass();
                    }
                    if (loginValue == null ? lookUpValue != null : !loginValue.equals(lookUpValue)) {
                        this.error(response, "consistency-displayname", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_DisplayNameMismatch(loginValue, lookUpValue), new Object[0]);
                        potentialLockout = true;
                    }
                }
                if (!realm.disableMailAddressResolver && StringUtils.isNotBlank((String)loginConfiguration.getMailAddressAttributeName())) {
                    Class<?> loginValue;
                    Attribute loginAttr = loginDetails.getAttributes().get(loginConfiguration.getMailAddressAttributeName());
                    try {
                        loginValue = loginAttr == null ? null : loginAttr.get();
                    }
                    catch (NamingException e) {
                        loginValue = e.getClass();
                    }
                    lookUpAttr = lookUpDetails.getAttributes().get(lookupConfiguration.getMailAddressAttributeName());
                    try {
                        lookUpValue = lookUpAttr == null ? null : lookUpAttr.get();
                    }
                    catch (NamingException e) {
                        lookUpValue = e.getClass();
                    }
                    if (loginValue == null ? lookUpValue != null : !loginValue.equals(lookUpValue)) {
                        this.error(response, "consistency-email", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_EmailAddressMismatch(loginValue, lookUpValue), new Object[0]);
                        potentialLockout = true;
                    }
                }
                if (loginAuthorities.equals(lookupAuthorities)) {
                    this.ok(response, "consistency", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembershipMatch(), new Object[0]);
                } else {
                    this.error(response, "consistency", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupMembershipMismatch(), new Object[0]);
                    potentialLockout = true;
                }
            }
            HashSet<String> groups = new HashSet<String>(loginAuthorities);
            TreeSet<String> badGroups = new TreeSet<String>();
            groups.addAll(lookupAuthorities);
            groups.remove(SecurityRealm.AUTHENTICATED_AUTHORITY.getAuthority());
            for (String group : groups) {
                try {
                    realm.loadGroupByGroupname(group);
                }
                catch (UsernameNotFoundException e) {
                    badGroups.add(group);
                }
            }
            if (groups.isEmpty()) {
                this.warning(response, "resolve-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupNotPossible(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupNotPossibleDetail());
            } else if (badGroups.isEmpty()) {
                this.ok(response, "resolve-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupSuccessful(groups.size()), new Object[0]);
            } else {
                ArrayList<String> escaped = new ArrayList<String>(badGroups.size());
                for (String group : badGroups) {
                    escaped.add("<code>" + Util.escape((String)group) + "</code>");
                }
                this.warning(response, "resolve-groups", jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupFailed(badGroups.size()), escaped, this.isAnyManagerBlank(realm) ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupManagerDnRequired() : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupManagerDnPermissions(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_GroupLookupSettingsCorrect());
            }
            if (potentialLockout) {
                response.append("<div>").append(jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_LockoutHeader()).append("</div>");
                this.error(response, "lockout", likelyLockout ? jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_PotentialLockout(user) : jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_PotentialLockout2(user), new Object[0]);
            }
            return FormValidation.okWithMarkup((String)response.toString());
        }

        private boolean isAnyManagerBlank(LDAPSecurityRealm realm) {
            for (LDAPConfiguration configuration : realm.getConfigurations()) {
                if (!StringUtils.isBlank((String)configuration.getManagerDN())) continue;
                return true;
            }
            return false;
        }

        private void validateEmailAddress(LDAPConfiguration configuration, StringBuilder response, LdapUserDetails details, String testId) {
            Attribute attribute = details.getAttributes().get(configuration.getMailAddressAttributeName());
            if (attribute == null) {
                ArrayList<String> alternatives = new ArrayList<String>();
                for (Attribute attribute2 : Collections.list(details.getAttributes().getAll())) {
                    alternatives.add("<code>" + Util.escape((String)attribute2.getID()) + "</code>");
                }
                this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoEmailAddress(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getMailAddressAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
            } else {
                try {
                    String mailAddress = (String)attribute.get();
                    if (StringUtils.isNotBlank((String)mailAddress)) {
                        this.ok(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserEmail(Util.escape((String)mailAddress)), new Object[0]);
                    } else {
                        ArrayList<String> alternatives = new ArrayList<String>();
                        for (Attribute attribute3 : Collections.list(details.getAttributes().getAll())) {
                            alternatives.add("<code>" + Util.escape((String)attribute3.getID()) + "</code>");
                        }
                        this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_EmptyEmailAddress(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getMailAddressAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                    }
                }
                catch (NamingException e) {
                    ArrayList<String> alternatives = new ArrayList<String>();
                    for (Attribute attribute4 : Collections.list(details.getAttributes().getAll())) {
                        alternatives.add("<code>" + Util.escape((String)attribute4.getID()) + "</code>");
                    }
                    this.error(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_CouldNotRetrieveEmailAddress(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getMailAddressAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                }
            }
        }

        private void validateDisplayName(LDAPConfiguration configuration, StringBuilder response, LdapUserDetails details, String testId) {
            Attribute attribute = details.getAttributes().get(configuration.getDisplayNameAttributeName());
            if (attribute == null) {
                ArrayList<String> alternatives = new ArrayList<String>();
                for (Attribute attribute2 : Collections.list(details.getAttributes().getAll())) {
                    alternatives.add("<code>" + Util.escape((String)attribute2.getID()) + "</code>");
                }
                this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_NoDisplayName(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getDisplayNameAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
            } else {
                try {
                    String displayName = (String)attribute.get();
                    if (displayName != null) {
                        this.ok(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_UserDisplayName(Util.escape((String)displayName)), new Object[0]);
                    } else {
                        ArrayList<String> alternatives = new ArrayList<String>();
                        for (Attribute attribute3 : Collections.list(details.getAttributes().getAll())) {
                            alternatives.add("<code>" + Util.escape((String)attribute3.getID()) + "</code>");
                        }
                        this.warning(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_EmptyDisplayName(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getDisplayNameAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                    }
                }
                catch (NamingException e) {
                    ArrayList<String> alternatives = new ArrayList<String>();
                    for (Attribute attribute4 : Collections.list(details.getAttributes().getAll())) {
                        alternatives.add("<code>" + Util.escape((String)attribute4.getID()) + "</code>");
                    }
                    this.error(response, testId, jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_CouldNotRetrieveDisplayName(), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_IsAttributeNameCorrect(Util.escape((String)configuration.getDisplayNameAttributeName())), jenkins.security.plugins.ldap.Messages.LDAPSecurityRealm_AvailableAttributes(), alternatives);
                }
            }
        }
    }

    public static final class AuthoritiesPopulatorImpl
    extends DefaultLdapAuthoritiesPopulator {
        String rolePrefix = "ROLE_";
        boolean convertToUpperCase = true;
        private GrantedAuthority defaultRole = null;

        public AuthoritiesPopulatorImpl(InitialDirContextFactory initialDirContextFactory, String groupSearchBase) {
            super(initialDirContextFactory, Util.fixNull((String)groupSearchBase));
            super.setRolePrefix("");
            super.setConvertToUpperCase(false);
        }

        public Set getAdditionalRoles(LdapUserDetails ldapUser) {
            return Collections.singleton(SecurityRealm.AUTHENTICATED_AUTHORITY);
        }

        public void setRolePrefix(String rolePrefix) {
            this.rolePrefix = rolePrefix;
        }

        public void setConvertToUpperCase(boolean convertToUpperCase) {
            this.convertToUpperCase = convertToUpperCase;
        }

        public Set getGroupMembershipRoles(String userDn, String username) {
            Set names = super.getGroupMembershipRoles(userDn, username);
            HashSet<GrantedAuthorityImpl> r = new HashSet<GrantedAuthorityImpl>(names.size() * 2);
            r.addAll(names);
            if (this.isGeneratingPrefixRoles()) {
                for (GrantedAuthority ga : names) {
                    String role = ga.getAuthority();
                    if (this.convertToUpperCase) {
                        role = role.toUpperCase();
                    }
                    r.add(new GrantedAuthorityImpl(this.rolePrefix + role));
                }
            }
            return r;
        }

        public boolean isGeneratingPrefixRoles() {
            return StringUtils.isNotBlank((String)this.rolePrefix) || this.convertToUpperCase;
        }

        public boolean isConvertToUpperCase() {
            return this.convertToUpperCase;
        }

        public String getRolePrefix() {
            return this.rolePrefix;
        }

        public GrantedAuthority getDefaultRole() {
            return this.defaultRole;
        }

        public void setDefaultRole(String defaultRole) {
            super.setDefaultRole(defaultRole);
            this.defaultRole = new GrantedAuthorityImpl(defaultRole);
        }
    }

    private static final class WrappedAuthoritiesPopulator
    implements LdapAuthoritiesPopulator {
        private final LDAPGroupMembershipStrategy strategy;
        private final LdapAuthoritiesPopulator populator;

        private WrappedAuthoritiesPopulator(LDAPGroupMembershipStrategy strategy, LdapAuthoritiesPopulator populator) {
            this.strategy = strategy;
            this.populator = populator;
            strategy.setAuthoritiesPopulator(populator);
        }

        public GrantedAuthority[] getGrantedAuthorities(LdapUserDetails userDetails) throws LdapDataAccessException {
            if (this.strategy.getAuthoritiesPopulator() != this.populator) {
                this.strategy.setAuthoritiesPopulator(this.populator);
            }
            return this.strategy.getGrantedAuthorities(userDetails);
        }
    }

    public static final class LdapAuthenticationProviderImpl
    extends LdapAuthenticationProvider {
        public LdapAuthenticationProviderImpl(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, LDAPGroupMembershipStrategy groupMembershipStrategy) {
            super(authenticator, (LdapAuthoritiesPopulator)(groupMembershipStrategy != null ? new WrappedAuthoritiesPopulator(groupMembershipStrategy, authoritiesPopulator) : authoritiesPopulator));
        }
    }

    @Extension
    public static final class MailAdressResolverImpl
    extends MailAddressResolver {
        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only on newer core versions")
        public String findMailAddressFor(User u) {
            Jenkins jenkins = Jenkins.getInstance();
            if (jenkins == null) {
                return null;
            }
            SecurityRealm realm = jenkins.getSecurityRealm();
            if (!(realm instanceof LDAPSecurityRealm)) {
                return null;
            }
            if (((LDAPSecurityRealm)realm).disableMailAddressResolver) {
                LOGGER.info("LDAPSecurityRealm MailAddressResolver is disabled");
                return null;
            }
            try {
                Attribute mail;
                String attr;
                LdapUserDetails details = (LdapUserDetails)realm.getSecurityComponents().userDetails.loadUserByUsername(u.getId());
                LDAPConfiguration configuration = ((LDAPSecurityRealm)realm).getConfigurationFor(details);
                if (configuration != null) {
                    attr = configuration.getMailAddressAttributeName();
                    if (StringUtils.isEmpty((String)attr)) {
                        attr = "mail";
                    }
                } else {
                    attr = "mail";
                }
                if ((mail = details.getAttributes().get(attr)) == null) {
                    return null;
                }
                return (String)mail.get();
            }
            catch (NamingException | AcegiSecurityException | DataAccessException e) {
                LOGGER.log(Level.FINE, "Failed to look up LDAP for e-mail address", e);
                return null;
            }
        }
    }

    public static class LDAPUserDetailsService
    implements UserDetailsService {
        public final LdapUserSearch ldapSearch;
        public final LdapAuthoritiesPopulator authoritiesPopulator;
        public final LDAPGroupMembershipStrategy groupMembershipStrategy;
        public final String configurationId;
        private final LRUMap attributesCache = new LRUMap(32);

        @Deprecated
        LDAPUserDetailsService(WebApplicationContext appContext) {
            this(appContext, null, null);
        }

        @Deprecated
        LDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator) {
            this(ldapSearch, authoritiesPopulator, null, null);
        }

        LDAPUserDetailsService(LdapUserSearch ldapSearch, LdapAuthoritiesPopulator authoritiesPopulator, LDAPGroupMembershipStrategy groupMembershipStrategy, String configurationId) {
            this.ldapSearch = ldapSearch;
            this.authoritiesPopulator = authoritiesPopulator;
            this.groupMembershipStrategy = groupMembershipStrategy;
            this.configurationId = configurationId;
        }

        @Deprecated
        public LDAPUserDetailsService(WebApplicationContext appContext, LDAPGroupMembershipStrategy groupMembershipStrategy) {
            this((LdapUserSearch)SecurityRealm.findBean(LdapUserSearch.class, (ApplicationContext)appContext), (LdapAuthoritiesPopulator)SecurityRealm.findBean(LdapAuthoritiesPopulator.class, (ApplicationContext)appContext), groupMembershipStrategy, null);
        }

        public LDAPUserDetailsService(WebApplicationContext appContext, LDAPGroupMembershipStrategy groupMembershipStrategy, String configurationId) {
            this((LdapUserSearch)SecurityRealm.findBean(LdapUserSearch.class, (ApplicationContext)appContext), (LdapAuthoritiesPopulator)SecurityRealm.findBean(LdapAuthoritiesPopulator.class, (ApplicationContext)appContext), groupMembershipStrategy, configurationId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Only on newer core versions")
        public LdapUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            username = LDAPSecurityRealm.fixUsername(username);
            try {
                LDAPSecurityRealm ldapSecurityRealm;
                LdapUserDetails ldapUser;
                LDAPSecurityRealm lDAPSecurityRealm;
                LDAPSecurityRealm ldapSecurityRealm2;
                SecurityRealm securityRealm;
                Jenkins jenkins = Jenkins.getInstance();
                SecurityRealm securityRealm2 = securityRealm = jenkins == null ? null : jenkins.getSecurityRealm();
                if (securityRealm instanceof LDAPSecurityRealm && (securityRealm.getSecurityComponents().userDetails == this || securityRealm.getSecurityComponents().userDetails instanceof DelegateLDAPUserDetailsService && ((DelegateLDAPUserDetailsService)securityRealm.getSecurityComponents().userDetails).contains(this)) && (ldapSecurityRealm2 = (LDAPSecurityRealm)securityRealm).cache != null) {
                    CacheEntry cached;
                    lDAPSecurityRealm = ldapSecurityRealm2;
                    synchronized (lDAPSecurityRealm) {
                        cached = ldapSecurityRealm2.userDetailsCache != null ? (CacheEntry)ldapSecurityRealm2.userDetailsCache.get(username) : null;
                    }
                    if (cached != null && cached.isValid()) {
                        return (LdapUserDetails)cached.getValue();
                    }
                }
                if ((ldapUser = this.ldapSearch.searchForUser(username)) != null) {
                    GrantedAuthority[] extraAuthorities;
                    LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence(ldapUser);
                    Attributes v = ldapUser.getAttributes();
                    if (v instanceof BasicAttributes) {
                        LRUMap lRUMap = this.attributesCache;
                        synchronized (lRUMap) {
                            Attributes vv = (Attributes)this.attributesCache.get((Object)v);
                            if (vv == null) {
                                vv = v;
                                this.attributesCache.put((Object)v, (Object)vv);
                            }
                            user.setAttributes(vv);
                        }
                    }
                    for (GrantedAuthority extraAuthority : extraAuthorities = this.groupMembershipStrategy == null ? this.authoritiesPopulator.getGrantedAuthorities(ldapUser) : this.groupMembershipStrategy.getGrantedAuthorities(ldapUser)) {
                        if (FORCE_GROUPNAME_LOWERCASE) {
                            user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl(extraAuthority.getAuthority().toLowerCase()));
                            continue;
                        }
                        user.addAuthority(extraAuthority);
                    }
                    ldapUser = StringUtils.isNotEmpty((String)this.configurationId) ? new DelegatedLdapUserDetails(user.createUserDetails(), this.configurationId) : user.createUserDetails();
                }
                if (securityRealm instanceof LDAPSecurityRealm && (securityRealm.getSecurityComponents().userDetails == this || securityRealm.getSecurityComponents().userDetails instanceof DelegateLDAPUserDetailsService && ((DelegateLDAPUserDetailsService)securityRealm.getSecurityComponents().userDetails).contains(this)) && (ldapSecurityRealm = (LDAPSecurityRealm)securityRealm).cache != null) {
                    lDAPSecurityRealm = ldapSecurityRealm;
                    synchronized (lDAPSecurityRealm) {
                        if (ldapSecurityRealm.userDetailsCache == null) {
                            ldapSecurityRealm.userDetailsCache = new CacheMap(ldapSecurityRealm.cache.getSize());
                        }
                        ldapSecurityRealm.userDetailsCache.put(username, new CacheEntry<LdapUserDetails>(ldapSecurityRealm.cache.getTtl(), ldapSecurityRealm.updateUserDetails(ldapUser)));
                    }
                }
                return ldapUser;
            }
            catch (LdapDataAccessException e) {
                LOGGER.log(Level.WARNING, "Failed to search LDAP for username=" + username, e);
                throw new UserMayOrMayNotExistException(e.getMessage(), (Throwable)e);
            }
            catch (UsernameNotFoundException x) {
                throw x;
            }
            catch (DataAccessException x) {
                throw x;
            }
            catch (RuntimeException x) {
                throw new LdapDataAccessException("Failed to search LDAP for " + username + ": " + x, (Throwable)x);
            }
        }
    }

    private static class DelegateLDAPUserDetailsService
    implements UserDetailsService {
        private final List<LDAPUserDetailsService> delegates = new ArrayList<LDAPUserDetailsService>();

        public void addDelegate(LDAPUserDetailsService delegate) {
            this.delegates.add(delegate);
        }

        public boolean contains(LDAPUserDetailsService delegate) {
            return this.delegates.contains(delegate);
        }

        public DelegatedLdapUserDetails loadUserByUsername(String configurationId, String username) throws UsernameNotFoundException, DataAccessException {
            for (LDAPUserDetailsService delegate : this.delegates) {
                if (!delegate.configurationId.equals(configurationId)) continue;
                try {
                    LdapUserDetails userDetails = delegate.loadUserByUsername(username);
                    if (userDetails instanceof DelegatedLdapUserDetails) {
                        return (DelegatedLdapUserDetails)userDetails;
                    }
                    return new DelegatedLdapUserDetails(userDetails, delegate.configurationId);
                }
                catch (DataAccessException e) {
                    LDAPConfiguration configuration = LDAPSecurityRealm._getConfigurationFor(delegate.configurationId);
                    LOGGER.log(Level.WARNING, String.format("Failed communication with ldap server %s (%s)", delegate.configurationId, configuration != null ? configuration.getServer() : "null"), e);
                    throw e;
                }
            }
            return null;
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            UsernameNotFoundException lastUNFE = null;
            for (LDAPUserDetailsService delegate : this.delegates) {
                try {
                    LdapUserDetails userDetails = delegate.loadUserByUsername(username);
                    if (userDetails instanceof DelegatedLdapUserDetails) {
                        return userDetails;
                    }
                    return new DelegatedLdapUserDetails(userDetails, delegate.configurationId);
                }
                catch (UsernameNotFoundException e) {
                    lastUNFE = e;
                }
                catch (DataAccessException e) {
                    LDAPConfiguration configuration = LDAPSecurityRealm._getConfigurationFor(delegate.configurationId);
                    LOGGER.log(Level.WARNING, "LDAP connection " + delegate.configurationId + (configuration != null ? "(" + configuration.getServer() + ")" : "") + " seems to be broken, will _not_ try the next configuration.", e);
                    throw e;
                }
            }
            if (lastUNFE != null) {
                throw lastUNFE;
            }
            throw new UsernameNotFoundException(username);
        }
    }

    static class DelegatedLdapUserDetails
    implements LdapUserDetails,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final LdapUserDetails userDetails;
        private final String configurationId;

        public DelegatedLdapUserDetails(@Nonnull LdapUserDetails userDetails, @Nonnull String configurationId) {
            this.userDetails = userDetails;
            this.configurationId = configurationId;
        }

        public Attributes getAttributes() {
            return this.userDetails.getAttributes();
        }

        public Control[] getControls() {
            return this.userDetails.getControls();
        }

        public String getDn() {
            return this.userDetails.getDn();
        }

        public GrantedAuthority[] getAuthorities() {
            return this.userDetails.getAuthorities();
        }

        public String getPassword() {
            return this.userDetails.getPassword();
        }

        public String getUsername() {
            return this.userDetails.getUsername();
        }

        public boolean isAccountNonExpired() {
            return this.userDetails.isAccountNonExpired();
        }

        public boolean isAccountNonLocked() {
            return this.userDetails.isAccountNonLocked();
        }

        public boolean isCredentialsNonExpired() {
            return this.userDetails.isCredentialsNonExpired();
        }

        public boolean isEnabled() {
            return this.userDetails.isEnabled();
        }

        public LdapUserDetails getUserDetails() {
            return this.userDetails;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }
    }

    static class DelegatedLdapAuthentication
    implements Authentication {
        private final Authentication delegate;
        private final String configurationId;

        public DelegatedLdapAuthentication(Authentication delegate, String configurationId) {
            this.delegate = delegate;
            this.configurationId = configurationId;
        }

        public GrantedAuthority[] getAuthorities() {
            return this.delegate.getAuthorities();
        }

        public Object getCredentials() {
            return this.delegate.getCredentials();
        }

        public Object getDetails() {
            return this.delegate.getDetails();
        }

        public Object getPrincipal() {
            Object principal = this.delegate.getPrincipal();
            if (principal instanceof LdapUserDetails && !(principal instanceof DelegatedLdapUserDetails)) {
                return new DelegatedLdapUserDetails((LdapUserDetails)principal, this.configurationId);
            }
            return principal;
        }

        public boolean isAuthenticated() {
            return this.delegate.isAuthenticated();
        }

        public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
            this.delegate.setAuthenticated(isAuthenticated);
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Authentication getDelegate() {
            return this.delegate;
        }

        public String getConfigurationId() {
            return this.configurationId;
        }
    }

    private class LDAPAuthenticationManager
    implements AuthenticationManager {
        private final List<ManagerEntry> delegates = new ArrayList<ManagerEntry>();
        private final DelegateLDAPUserDetailsService detailsService;

        private LDAPAuthenticationManager() {
            this.detailsService = null;
        }

        private LDAPAuthenticationManager(DelegateLDAPUserDetailsService detailsService) {
            this.detailsService = detailsService;
        }

        private void addDelegate(AuthenticationManager delegate, String configurationId) {
            this.delegates.add(new ManagerEntry(delegate, configurationId));
        }

        public Authentication authenticate(Authentication authentication) throws AuthenticationException {
            if (this.delegates.size() == 1) {
                try {
                    return LDAPSecurityRealm.this.updateUserDetails(this.delegates.get((int)0).delegate.authenticate(authentication));
                }
                catch (AuthenticationServiceException e) {
                    LOGGER.log(Level.WARNING, "Failed communication with ldap server.", e);
                    throw e;
                }
            }
            BadCredentialsException lastException = null;
            for (ManagerEntry delegate : this.delegates) {
                try {
                    Authentication a = delegate.delegate.authenticate(authentication);
                    return LDAPSecurityRealm.this.updateUserDetails(new DelegatedLdapAuthentication(a, delegate.configurationId));
                }
                catch (BadCredentialsException e) {
                    if (this.detailsService != null && this.delegates.size() > 1) {
                        try {
                            DelegatedLdapUserDetails details = this.detailsService.loadUserByUsername(delegate.configurationId, String.valueOf(authentication.getPrincipal()));
                            if (details == null) continue;
                            throw e;
                        }
                        catch (UsernameNotFoundException e1) {
                            lastException = e;
                            continue;
                        }
                    }
                    lastException = e;
                }
                catch (AuthenticationServiceException e) {
                    LDAPConfiguration configuration = LDAPSecurityRealm.this.getConfigurationFor(delegate.configurationId);
                    LOGGER.log(Level.WARNING, String.format("Failed communication with ldap server %s (%s)", delegate.configurationId, configuration != null ? configuration.getServer() : "null"), e);
                    throw e;
                }
            }
            if (lastException != null) {
                throw lastException;
            }
            throw new UserMayOrMayNotExistException("No ldap server configuration", (Object)authentication);
        }

        private class ManagerEntry {
            final AuthenticationManager delegate;
            final String configurationId;

            public ManagerEntry(AuthenticationManager delegate, String configurationId) {
                this.delegate = delegate;
                this.configurationId = configurationId;
            }
        }
    }

    private static class GroupDetailsMapper
    implements LdapEntryMapper {
        private GroupDetailsMapper() {
        }

        public GroupDetailsImpl mapAttributes(String dn, Attributes attributes) throws NamingException {
            LdapName name = new LdapName(dn);
            String groupName = LDAPSecurityRealm.fixGroupname(String.valueOf(name.getRdn(name.size() - 1).getValue()));
            return new GroupDetailsImpl(dn, groupName);
        }
    }

    private static class GroupDetailsImpl
    extends GroupDetails {
        private final String dn;
        private final String name;
        private final Set<String> members;

        public GroupDetailsImpl(String dn, String name) {
            this(dn, name, null);
        }

        public GroupDetailsImpl(String dn, String name, Set<String> members) {
            this.dn = dn;
            this.name = name;
            this.members = members;
        }

        public String getDn() {
            return this.dn;
        }

        public String getName() {
            return this.name;
        }

        public Set<String> getMembers() {
            return this.members;
        }
    }
}

