/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import hudson.Extension;
import hudson.security.LDAPSecurityRealm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategyDescriptor;
import jenkins.security.plugins.ldap.Messages;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class FromUserRecordLDAPGroupMembershipStrategy
extends LDAPGroupMembershipStrategy {
    private static final Logger LOGGER = Logger.getLogger(FromUserRecordLDAPGroupMembershipStrategy.class.getName());
    private final String attributeName;

    @DataBoundConstructor
    public FromUserRecordLDAPGroupMembershipStrategy(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAttributeName() {
        return StringUtils.defaultIfEmpty((String)this.attributeName, (String)"memberOf");
    }

    @Override
    public GrantedAuthority[] getGrantedAuthorities(LdapUserDetails ldapUser) {
        Attribute attribute;
        ArrayList<Object> result = new ArrayList<Object>();
        Attributes attributes = ldapUser.getAttributes();
        String attributeName = this.getAttributeName();
        Attribute attribute2 = attribute = attributes == null ? null : attributes.get(attributeName);
        if (attribute != null) {
            try {
                for (Object value : Collections.list(attribute.getAll())) {
                    String groupName = String.valueOf(value);
                    try {
                        LdapName dn = new LdapName(groupName);
                        groupName = String.valueOf(dn.getRdn(dn.size() - 1).getValue());
                    }
                    catch (InvalidNameException e) {
                        LOGGER.log(Level.FINEST, "Expected a Group DN but found: {0}", groupName);
                    }
                    result.add(new GrantedAuthorityImpl(groupName));
                }
            }
            catch (NamingException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Failed to retrieve member of attribute ({0}) from LDAP user details");
                lr.setThrown(e);
                lr.setParameters(new Object[]{attributeName});
                LOGGER.log(lr);
            }
        }
        if (this.getAuthoritiesPopulator() instanceof LDAPSecurityRealm.AuthoritiesPopulatorImpl) {
            LDAPSecurityRealm.AuthoritiesPopulatorImpl authoritiesPopulatorImpl = (LDAPSecurityRealm.AuthoritiesPopulatorImpl)this.getAuthoritiesPopulator();
            if (authoritiesPopulatorImpl.isGeneratingPrefixRoles()) {
                for (GrantedAuthority ga : new ArrayList(result)) {
                    String role = ga.getAuthority();
                    if (authoritiesPopulatorImpl.isConvertToUpperCase()) {
                        role = role.toUpperCase();
                    }
                    GrantedAuthorityImpl extraAuthority = new GrantedAuthorityImpl(authoritiesPopulatorImpl.getRolePrefix() + role);
                    result.add(extraAuthority);
                }
            }
            result.addAll(authoritiesPopulatorImpl.getAdditionalRoles(ldapUser));
            GrantedAuthority defaultRole = authoritiesPopulatorImpl.getDefaultRole();
            if (defaultRole != null) {
                result.add(defaultRole);
            }
        }
        return result.toArray(new GrantedAuthority[result.size()]);
    }

    @Extension
    public static class DescriptorImpl
    extends LDAPGroupMembershipStrategyDescriptor {
        public String getDisplayName() {
            return Messages.FromUserRecordLDAPGroupMembershipStrategy_DisplayName();
        }
    }
}

