/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security.plugins.ldap;

import hudson.Extension;
import hudson.security.LDAPSecurityRealm;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategy;
import jenkins.security.plugins.ldap.LDAPGroupMembershipStrategyDescriptor;
import jenkins.security.plugins.ldap.Messages;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class FromGroupSearchLDAPGroupMembershipStrategy
extends LDAPGroupMembershipStrategy {
    private final String filter;

    @DataBoundConstructor
    public FromGroupSearchLDAPGroupMembershipStrategy(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    @Override
    public void setAuthoritiesPopulator(LdapAuthoritiesPopulator authoritiesPopulator) {
        if (authoritiesPopulator instanceof LDAPSecurityRealm.AuthoritiesPopulatorImpl && StringUtils.isNotBlank((String)this.filter)) {
            ((LDAPSecurityRealm.AuthoritiesPopulatorImpl)authoritiesPopulator).setGroupSearchFilter(this.filter);
        }
        super.setAuthoritiesPopulator(authoritiesPopulator);
    }

    @Override
    public GrantedAuthority[] getGrantedAuthorities(LdapUserDetails ldapUser) {
        return this.getAuthoritiesPopulator().getGrantedAuthorities(ldapUser);
    }

    @Extension
    public static class DescriptorImpl
    extends LDAPGroupMembershipStrategyDescriptor {
        public String getDisplayName() {
            return Messages.FromGroupSearchLDAPGroupMembershipStrategy_DisplayName();
        }
    }
}

