/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.cli;

import hudson.Extension;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.kubernetes.cli.GenericBuildStep;
import org.jenkinsci.plugins.kubernetes.cli.KubectlCredential;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class MultiKubectlBuildStep
extends Step {
    @DataBoundSetter
    public List<KubectlCredential> kubectlCredentials;

    @DataBoundConstructor
    public MultiKubectlBuildStep(List<KubectlCredential> kubectlCredentials) {
        if (kubectlCredentials == null || kubectlCredentials.size() == 0) {
            throw new RuntimeException("[kubernetes-cli] credentials list cannot be empty");
        }
        this.kubectlCredentials = kubectlCredentials;
    }

    public final StepExecution start(StepContext context) throws Exception {
        return new GenericBuildStep(this.kubectlCredentials, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Configure Kubernetes CLI (kubectl) with multiple credentials";
        }

        public String getFunctionName() {
            return "withKubeCredentials";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet();
        }
    }
}

