/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.cli;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.kubernetes.cli.KubeConfigExpander;
import org.jenkinsci.plugins.kubernetes.cli.KubectlCredential;
import org.jenkinsci.plugins.kubernetes.cli.kubeconfig.KubeConfigWriter;
import org.jenkinsci.plugins.kubernetes.cli.kubeconfig.KubeConfigWriterFactory;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class GenericBuildStep
extends AbstractStepExecutionImpl {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="not needed on deserialization")
    private transient List<KubectlCredential> kubectlCredentials;

    public GenericBuildStep(List<KubectlCredential> credentials, StepContext context) {
        super(context);
        this.kubectlCredentials = credentials;
    }

    public boolean start() throws Exception {
        ArrayList<String> configFiles = new ArrayList<String>();
        for (KubectlCredential cred : this.kubectlCredentials) {
            KubeConfigWriter kubeConfigWriter = KubeConfigWriterFactory.get(cred.serverUrl, cred.credentialsId, cred.caCertificate, cred.clusterName, cred.contextName, cred.namespace, this.getContext());
            configFiles.add(kubeConfigWriter.writeKubeConfig());
        }
        String configFileList = String.join((CharSequence)File.pathSeparator, configFiles);
        EnvironmentExpander envExpander = EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new KubeConfigExpander(configFileList));
        this.getContext().newBodyInvoker().withContext((Object)envExpander).withCallback((BodyExecutionCallback)new Callback(configFiles)).start();
        return false;
    }

    public void stop(@Nonnull Throwable cause) throws Exception {
        this.getContext().onFailure(cause);
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        private final List<String> configFiles;

        Callback(List<String> configFiles) {
            this.configFiles = configFiles;
        }

        protected void finished(StepContext context) throws Exception {
            for (String configFile : this.configFiles) {
                ((FilePath)context.get(FilePath.class)).child(configFile).delete();
            }
            ((TaskListener)context.get(TaskListener.class)).getLogger().println("[kubernetes-cli] kubectl configuration cleaned up");
        }
    }
}

