/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.google.common.base.Preconditions;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceManager;
import com.microsoft.jenkins.kubernetes.wrapper.V1beta2ResourceUpdateMonitor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1beta2Api;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1beta2DaemonSet;
import io.kubernetes.client.openapi.models.V1beta2Deployment;
import io.kubernetes.client.openapi.models.V1beta2ReplicaSet;
import io.kubernetes.client.openapi.models.V1beta2StatefulSet;

public class V1beta2ResourceManager
extends ResourceManager {
    private final AppsV1beta2Api appsV1beta2Api;
    private V1beta2ResourceUpdateMonitor resourceUpdateMonitor = V1beta2ResourceUpdateMonitor.NOOP;

    public V1beta2ResourceManager(ApiClient client) {
        super(true);
        Preconditions.checkNotNull((Object)client);
        this.appsV1beta2Api = new AppsV1beta2Api(client);
    }

    public V1beta2ResourceManager(ApiClient client, boolean pretty) {
        super(pretty);
        Preconditions.checkNotNull((Object)client);
        this.appsV1beta2Api = new AppsV1beta2Api(client);
    }

    public V1beta2ResourceUpdateMonitor getResourceUpdateMonitor() {
        return this.resourceUpdateMonitor;
    }

    public V1beta2ResourceManager withResourceUpdateMonitor(V1beta2ResourceUpdateMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor);
        this.resourceUpdateMonitor = monitor;
        return this;
    }

    class StatefulSetUpdater
    extends ResourceManager.ResourceUpdater<V1beta2StatefulSet> {
        StatefulSetUpdater(V1beta2StatefulSet namespace) {
            super(namespace);
        }

        @Override
        V1beta2StatefulSet getCurrentResource() {
            V1beta2StatefulSet result = null;
            try {
                result = V1beta2ResourceManager.this.appsV1beta2Api.readNamespacedStatefulSet(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1beta2StatefulSet applyResource(V1beta2StatefulSet original, V1beta2StatefulSet current) {
            V1beta2StatefulSet result = null;
            try {
                result = V1beta2ResourceManager.this.appsV1beta2Api.replaceNamespacedStatefulSet(this.getName(), this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1beta2StatefulSet createResource(V1beta2StatefulSet current) {
            V1beta2StatefulSet result = null;
            try {
                result = V1beta2ResourceManager.this.appsV1beta2Api.createNamespacedStatefulSet(this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1beta2StatefulSet current) {
            V1Status result = null;
            try {
                result = V1beta2ResourceManager.this.appsV1beta2Api.deleteNamespacedStatefulSet(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta2StatefulSet original, V1beta2StatefulSet current) {
            V1beta2ResourceManager.this.resourceUpdateMonitor.onStatefulSetUpdate(original, current);
        }
    }

    class ReplicaSetUpdater
    extends ResourceManager.ResourceUpdater<V1beta2ReplicaSet> {
        ReplicaSetUpdater(V1beta2ReplicaSet replicaSet) {
            super(replicaSet);
        }

        @Override
        V1beta2ReplicaSet getCurrentResource() {
            V1beta2ReplicaSet replicaSet = null;
            try {
                replicaSet = V1beta2ResourceManager.this.appsV1beta2Api.readNamespacedReplicaSet(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return replicaSet;
        }

        @Override
        V1beta2ReplicaSet applyResource(V1beta2ReplicaSet original, V1beta2ReplicaSet current) {
            V1beta2ReplicaSet replicaSet = null;
            try {
                replicaSet = V1beta2ResourceManager.this.appsV1beta2Api.replaceNamespacedReplicaSet(this.getName(), this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return replicaSet;
        }

        @Override
        V1beta2ReplicaSet createResource(V1beta2ReplicaSet current) {
            V1beta2ReplicaSet replicaSet = null;
            try {
                replicaSet = V1beta2ResourceManager.this.appsV1beta2Api.createNamespacedReplicaSet(this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return replicaSet;
        }

        @Override
        V1Status deleteResource(V1beta2ReplicaSet current) {
            V1Status result = null;
            try {
                result = V1beta2ResourceManager.this.appsV1beta2Api.deleteNamespacedReplicaSet(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta2ReplicaSet original, V1beta2ReplicaSet current) {
            V1beta2ResourceManager.this.resourceUpdateMonitor.onReplicaSetUpdate(original, current);
        }
    }

    class DaemonSetUpdater
    extends ResourceManager.ResourceUpdater<V1beta2DaemonSet> {
        DaemonSetUpdater(V1beta2DaemonSet daemonSet) {
            super(daemonSet);
        }

        @Override
        V1beta2DaemonSet getCurrentResource() {
            V1beta2DaemonSet daemonSet = null;
            try {
                daemonSet = V1beta2ResourceManager.this.appsV1beta2Api.readNamespacedDaemonSet(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return daemonSet;
        }

        @Override
        V1beta2DaemonSet applyResource(V1beta2DaemonSet original, V1beta2DaemonSet current) {
            V1beta2DaemonSet daemonSet = null;
            try {
                daemonSet = V1beta2ResourceManager.this.appsV1beta2Api.replaceNamespacedDaemonSet(this.getName(), this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return daemonSet;
        }

        @Override
        V1beta2DaemonSet createResource(V1beta2DaemonSet current) {
            V1beta2DaemonSet daemonSet = null;
            try {
                daemonSet = V1beta2ResourceManager.this.appsV1beta2Api.createNamespacedDaemonSet(this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return daemonSet;
        }

        @Override
        V1Status deleteResource(V1beta2DaemonSet current) {
            V1Status result = null;
            try {
                result = V1beta2ResourceManager.this.appsV1beta2Api.deleteNamespacedDaemonSet(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta2DaemonSet original, V1beta2DaemonSet current) {
            V1beta2ResourceManager.this.resourceUpdateMonitor.onDaemonSetUpdate(original, current);
        }
    }

    class DeploymentUpdater
    extends ResourceManager.ResourceUpdater<V1beta2Deployment> {
        DeploymentUpdater(V1beta2Deployment deployment) {
            super(deployment);
        }

        @Override
        V1beta2Deployment getCurrentResource() {
            V1beta2Deployment deployment = null;
            try {
                deployment = V1beta2ResourceManager.this.appsV1beta2Api.readNamespacedDeployment(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return deployment;
        }

        @Override
        V1beta2Deployment applyResource(V1beta2Deployment original, V1beta2Deployment current) {
            V1beta2Deployment deployment = null;
            try {
                deployment = V1beta2ResourceManager.this.appsV1beta2Api.replaceNamespacedDeployment(this.getName(), this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        V1beta2Deployment createResource(V1beta2Deployment current) {
            V1beta2Deployment deployment = null;
            try {
                deployment = V1beta2ResourceManager.this.appsV1beta2Api.createNamespacedDeployment(this.getNamespace(), current, V1beta2ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        V1Status deleteResource(V1beta2Deployment current) {
            V1Status result = null;
            try {
                result = V1beta2ResourceManager.this.appsV1beta2Api.deleteNamespacedDeployment(this.getName(), this.getNamespace(), V1beta2ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta2ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta2Deployment original, V1beta2Deployment current) {
            V1beta2ResourceManager.this.resourceUpdateMonitor.onDeploymentUpdate(original, current);
        }
    }
}

