/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.google.common.base.Preconditions;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceManager;
import com.microsoft.jenkins.kubernetes.wrapper.V1beta1ResourceUpdateMonitor;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.AppsV1beta1Api;
import io.kubernetes.client.openapi.apis.BatchV1beta1Api;
import io.kubernetes.client.openapi.apis.ExtensionsV1beta1Api;
import io.kubernetes.client.openapi.apis.NetworkingV1beta1Api;
import io.kubernetes.client.openapi.models.AppsV1beta1Deployment;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1Deployment;
import io.kubernetes.client.openapi.models.ExtensionsV1beta1Ingress;
import io.kubernetes.client.openapi.models.NetworkingV1beta1Ingress;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1beta1CronJob;
import io.kubernetes.client.openapi.models.V1beta1DaemonSet;
import io.kubernetes.client.openapi.models.V1beta1ReplicaSet;
import io.kubernetes.client.openapi.models.V1beta1StatefulSet;

public class V1beta1ResourceManager
extends ResourceManager {
    private final ExtensionsV1beta1Api extensionsV1beta1Api;
    private final AppsV1beta1Api appsV1beta1Api;
    private final BatchV1beta1Api batchV1beta1Api;
    private final NetworkingV1beta1Api networkingV1beta1Api;
    private V1beta1ResourceUpdateMonitor resourceUpdateMonitor = V1beta1ResourceUpdateMonitor.NOOP;

    public V1beta1ResourceManager(ApiClient client) {
        super(true);
        Preconditions.checkNotNull((Object)client);
        this.extensionsV1beta1Api = new ExtensionsV1beta1Api(client);
        this.appsV1beta1Api = new AppsV1beta1Api(client);
        this.batchV1beta1Api = new BatchV1beta1Api(client);
        this.networkingV1beta1Api = new NetworkingV1beta1Api(client);
    }

    public V1beta1ResourceManager(ApiClient client, boolean pretty) {
        super(pretty);
        Preconditions.checkNotNull((Object)client);
        this.extensionsV1beta1Api = new ExtensionsV1beta1Api(client);
        this.appsV1beta1Api = new AppsV1beta1Api(client);
        this.batchV1beta1Api = new BatchV1beta1Api(client);
        this.networkingV1beta1Api = new NetworkingV1beta1Api(client);
    }

    public V1beta1ResourceUpdateMonitor getResourceUpdateMonitor() {
        return this.resourceUpdateMonitor;
    }

    public V1beta1ResourceManager withResourceUpdateMonitor(V1beta1ResourceUpdateMonitor monitor) {
        Preconditions.checkNotNull((Object)monitor);
        this.resourceUpdateMonitor = monitor;
        return this;
    }

    class CronJobUpdater
    extends ResourceManager.ResourceUpdater<V1beta1CronJob> {
        CronJobUpdater(V1beta1CronJob namespace) {
            super(namespace);
        }

        @Override
        V1beta1CronJob getCurrentResource() {
            V1beta1CronJob result = null;
            try {
                result = V1beta1ResourceManager.this.batchV1beta1Api.readNamespacedCronJob(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1beta1CronJob applyResource(V1beta1CronJob original, V1beta1CronJob current) {
            V1beta1CronJob result = null;
            try {
                result = V1beta1ResourceManager.this.batchV1beta1Api.replaceNamespacedCronJob(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1beta1CronJob createResource(V1beta1CronJob current) {
            V1beta1CronJob result = null;
            try {
                result = V1beta1ResourceManager.this.batchV1beta1Api.createNamespacedCronJob(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1beta1CronJob current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.batchV1beta1Api.deleteNamespacedCronJob(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta1CronJob original, V1beta1CronJob current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onCronJobUpdate(original, current);
        }
    }

    class StatefulSetUpdater
    extends ResourceManager.ResourceUpdater<V1beta1StatefulSet> {
        StatefulSetUpdater(V1beta1StatefulSet namespace) {
            super(namespace);
        }

        @Override
        V1beta1StatefulSet getCurrentResource() {
            V1beta1StatefulSet result = null;
            try {
                result = V1beta1ResourceManager.this.appsV1beta1Api.readNamespacedStatefulSet(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        V1beta1StatefulSet applyResource(V1beta1StatefulSet original, V1beta1StatefulSet current) {
            V1beta1StatefulSet result = null;
            try {
                result = V1beta1ResourceManager.this.appsV1beta1Api.replaceNamespacedStatefulSet(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1beta1StatefulSet createResource(V1beta1StatefulSet current) {
            V1beta1StatefulSet result = null;
            try {
                result = V1beta1ResourceManager.this.appsV1beta1Api.createNamespacedStatefulSet(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return result;
        }

        @Override
        V1Status deleteResource(V1beta1StatefulSet current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.appsV1beta1Api.deleteNamespacedStatefulSet(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta1StatefulSet original, V1beta1StatefulSet current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onStatefulSetUpdate(original, current);
        }
    }

    class AppsDeploymentUpdater
    extends ResourceManager.ResourceUpdater<AppsV1beta1Deployment> {
        AppsDeploymentUpdater(AppsV1beta1Deployment deployment) {
            super(deployment);
        }

        @Override
        AppsV1beta1Deployment getCurrentResource() {
            AppsV1beta1Deployment deployment = null;
            try {
                deployment = V1beta1ResourceManager.this.appsV1beta1Api.readNamespacedDeployment(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return deployment;
        }

        @Override
        AppsV1beta1Deployment applyResource(AppsV1beta1Deployment original, AppsV1beta1Deployment current) {
            AppsV1beta1Deployment deployment = null;
            try {
                deployment = V1beta1ResourceManager.this.appsV1beta1Api.replaceNamespacedDeployment(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        AppsV1beta1Deployment createResource(AppsV1beta1Deployment current) {
            AppsV1beta1Deployment deployment = null;
            try {
                deployment = V1beta1ResourceManager.this.appsV1beta1Api.createNamespacedDeployment(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        V1Status deleteResource(AppsV1beta1Deployment current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.appsV1beta1Api.deleteNamespacedDeployment(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(AppsV1beta1Deployment original, AppsV1beta1Deployment current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onDeploymentUpdate(original, current);
        }
    }

    class ExtensionsDeploymentUpdater
    extends ResourceManager.ResourceUpdater<ExtensionsV1beta1Deployment> {
        ExtensionsDeploymentUpdater(ExtensionsV1beta1Deployment deployment) {
            super(deployment);
        }

        @Override
        ExtensionsV1beta1Deployment getCurrentResource() {
            ExtensionsV1beta1Deployment deployment = null;
            try {
                deployment = V1beta1ResourceManager.this.extensionsV1beta1Api.readNamespacedDeployment(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return deployment;
        }

        @Override
        ExtensionsV1beta1Deployment applyResource(ExtensionsV1beta1Deployment original, ExtensionsV1beta1Deployment current) {
            ExtensionsV1beta1Deployment deployment = null;
            try {
                deployment = V1beta1ResourceManager.this.extensionsV1beta1Api.replaceNamespacedDeployment(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        ExtensionsV1beta1Deployment createResource(ExtensionsV1beta1Deployment current) {
            ExtensionsV1beta1Deployment deployment = null;
            try {
                deployment = V1beta1ResourceManager.this.extensionsV1beta1Api.createNamespacedDeployment(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return deployment;
        }

        @Override
        V1Status deleteResource(ExtensionsV1beta1Deployment current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.extensionsV1beta1Api.deleteNamespacedDeployment(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(ExtensionsV1beta1Deployment original, ExtensionsV1beta1Deployment current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onDeploymentUpdate(original, current);
        }
    }

    class NetworkingIngressUpdater
    extends ResourceManager.ResourceUpdater<NetworkingV1beta1Ingress> {
        NetworkingIngressUpdater(NetworkingV1beta1Ingress ingress) {
            super(ingress);
        }

        @Override
        NetworkingV1beta1Ingress getCurrentResource() {
            NetworkingV1beta1Ingress ingress = null;
            try {
                ingress = V1beta1ResourceManager.this.networkingV1beta1Api.readNamespacedIngress(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return ingress;
        }

        @Override
        NetworkingV1beta1Ingress applyResource(NetworkingV1beta1Ingress original, NetworkingV1beta1Ingress current) {
            NetworkingV1beta1Ingress ingress = null;
            try {
                ingress = V1beta1ResourceManager.this.networkingV1beta1Api.replaceNamespacedIngress(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return ingress;
        }

        @Override
        NetworkingV1beta1Ingress createResource(NetworkingV1beta1Ingress current) {
            NetworkingV1beta1Ingress ingress = null;
            try {
                ingress = V1beta1ResourceManager.this.networkingV1beta1Api.createNamespacedIngress(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return ingress;
        }

        @Override
        V1Status deleteResource(NetworkingV1beta1Ingress current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.networkingV1beta1Api.deleteNamespacedIngress(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(NetworkingV1beta1Ingress original, NetworkingV1beta1Ingress current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onNetworkingIngressUpdate(original, current);
        }
    }

    class ExtensionsIngressUpdater
    extends ResourceManager.ResourceUpdater<ExtensionsV1beta1Ingress> {
        ExtensionsIngressUpdater(ExtensionsV1beta1Ingress ingress) {
            super(ingress);
        }

        @Override
        ExtensionsV1beta1Ingress getCurrentResource() {
            ExtensionsV1beta1Ingress ingress = null;
            try {
                ingress = V1beta1ResourceManager.this.extensionsV1beta1Api.readNamespacedIngress(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return ingress;
        }

        @Override
        ExtensionsV1beta1Ingress applyResource(ExtensionsV1beta1Ingress original, ExtensionsV1beta1Ingress current) {
            ExtensionsV1beta1Ingress ingress = null;
            try {
                ingress = V1beta1ResourceManager.this.extensionsV1beta1Api.replaceNamespacedIngress(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return ingress;
        }

        @Override
        ExtensionsV1beta1Ingress createResource(ExtensionsV1beta1Ingress current) {
            ExtensionsV1beta1Ingress ingress = null;
            try {
                ingress = V1beta1ResourceManager.this.extensionsV1beta1Api.createNamespacedIngress(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return ingress;
        }

        @Override
        V1Status deleteResource(ExtensionsV1beta1Ingress current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.extensionsV1beta1Api.deleteNamespacedIngress(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(ExtensionsV1beta1Ingress original, ExtensionsV1beta1Ingress current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onExtensionsIngressUpdate(original, current);
        }
    }

    class DaemonSetUpdater
    extends ResourceManager.ResourceUpdater<V1beta1DaemonSet> {
        DaemonSetUpdater(V1beta1DaemonSet daemonSet) {
            super(daemonSet);
        }

        @Override
        V1beta1DaemonSet getCurrentResource() {
            V1beta1DaemonSet daemonSet = null;
            try {
                daemonSet = V1beta1ResourceManager.this.extensionsV1beta1Api.readNamespacedDaemonSet(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return daemonSet;
        }

        @Override
        V1beta1DaemonSet applyResource(V1beta1DaemonSet original, V1beta1DaemonSet current) {
            V1beta1DaemonSet daemonSet = null;
            try {
                daemonSet = V1beta1ResourceManager.this.extensionsV1beta1Api.replaceNamespacedDaemonSet(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return daemonSet;
        }

        @Override
        V1beta1DaemonSet createResource(V1beta1DaemonSet current) {
            V1beta1DaemonSet daemonSet = null;
            try {
                daemonSet = V1beta1ResourceManager.this.extensionsV1beta1Api.createNamespacedDaemonSet(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return daemonSet;
        }

        @Override
        V1Status deleteResource(V1beta1DaemonSet current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.extensionsV1beta1Api.deleteNamespacedDaemonSet(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta1DaemonSet original, V1beta1DaemonSet current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onDaemonSetUpdate(original, current);
        }
    }

    class ReplicaSetUpdater
    extends ResourceManager.ResourceUpdater<V1beta1ReplicaSet> {
        ReplicaSetUpdater(V1beta1ReplicaSet replicaSet) {
            super(replicaSet);
        }

        @Override
        V1beta1ReplicaSet getCurrentResource() {
            V1beta1ReplicaSet replicaSet = null;
            try {
                replicaSet = V1beta1ResourceManager.this.extensionsV1beta1Api.readNamespacedReplicaSet(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), Boolean.valueOf(true), Boolean.valueOf(true));
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return replicaSet;
        }

        @Override
        V1beta1ReplicaSet applyResource(V1beta1ReplicaSet original, V1beta1ReplicaSet current) {
            V1beta1ReplicaSet replicaSet = null;
            try {
                replicaSet = V1beta1ResourceManager.this.extensionsV1beta1Api.replaceNamespacedReplicaSet(this.getName(), this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return replicaSet;
        }

        @Override
        V1beta1ReplicaSet createResource(V1beta1ReplicaSet current) {
            V1beta1ReplicaSet replicaSet = null;
            try {
                replicaSet = V1beta1ResourceManager.this.extensionsV1beta1Api.createNamespacedReplicaSet(this.getNamespace(), current, V1beta1ResourceManager.this.getPretty(), null, null);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiException(e);
            }
            return replicaSet;
        }

        @Override
        V1Status deleteResource(V1beta1ReplicaSet current) {
            V1Status result = null;
            try {
                result = V1beta1ResourceManager.this.extensionsV1beta1Api.deleteNamespacedReplicaSet(this.getName(), this.getNamespace(), V1beta1ResourceManager.this.getPretty(), null, null, null, null, Constants.BACKGROUND_DELETEION);
            }
            catch (ApiException e) {
                V1beta1ResourceManager.this.handleApiExceptionExceptNotFound(e);
            }
            return result;
        }

        @Override
        void notifyUpdate(V1beta1ReplicaSet original, V1beta1ReplicaSet current) {
            V1beta1ResourceManager.this.resourceUpdateMonitor.onReplicaSetUpdate(original, current);
        }
    }
}

