/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.google.common.base.Preconditions;
import com.google.gson.JsonSyntaxException;
import com.microsoft.jenkins.kubernetes.wrapper.Messages;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Status;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceManager {
    private PrintStream consoleLogger = System.out;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManager.class);
    private final String pretty;

    ResourceManager(boolean pretty) {
        this.pretty = String.valueOf(pretty);
    }

    public String getPretty() {
        return this.pretty;
    }

    public PrintStream getConsoleLogger() {
        return this.consoleLogger;
    }

    public ResourceManager setConsoleLogger(PrintStream log) {
        this.consoleLogger = log;
        return this;
    }

    protected void handleApiExceptionExceptNotFound(ApiException e) throws RuntimeException {
        int code = e.getCode();
        if (code == 404) {
            return;
        }
        String responseBody = e.getResponseBody();
        this.getConsoleLogger().println(Messages.KubernetesClientWrapper_apiException(code, responseBody));
        throw new RuntimeException((Throwable)e);
    }

    protected void handleApiException(ApiException e) throws RuntimeException {
        int code = e.getCode();
        String responseBody = e.getResponseBody();
        this.getConsoleLogger().println(Messages.KubernetesClientWrapper_apiException(code, responseBody));
        throw new RuntimeException((Throwable)e);
    }

    protected abstract class ResourceUpdater<T> {
        private final T resource;
        private final V1ObjectMeta metadata;

        ResourceUpdater(T resource) {
            Preconditions.checkNotNull(resource);
            this.resource = resource;
            V1ObjectMeta meta = null;
            try {
                Method method = resource.getClass().getMethod("getMetadata", new Class[0]);
                meta = (V1ObjectMeta)method.invoke(resource, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                ResourceManager.this.consoleLogger.println(String.format("Fail to fetch meta data for %s", resource));
            }
            this.metadata = meta;
            Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.getName()), (String)Messages.KubernetesClientWrapper_noName(), (Object)this.getKind(), resource);
        }

        final String getNamespace() {
            if (this.metadata != null) {
                if (this.metadata.getNamespace() != null) {
                    return this.metadata.getNamespace();
                }
                return "default";
            }
            return "default";
        }

        final T get() {
            return this.resource;
        }

        final String getName() {
            String name = null;
            if (this.metadata != null) {
                name = this.metadata.getName();
            }
            return name;
        }

        final String getKind() {
            return this.resource.getClass().getSimpleName();
        }

        final void createOrApply() {
            T updated;
            T original = this.getCurrentResource();
            T current = this.get();
            if (original != null) {
                updated = this.applyResource(original, current);
                this.logApplied(updated);
            } else {
                updated = this.createResource(this.get());
                this.logCreated(updated);
            }
            this.notifyUpdate(original, updated);
        }

        final void delete() {
            try {
                V1Status status = this.deleteResource(this.get());
                this.logDeleted(status);
            }
            catch (JsonSyntaxException e) {
                if (e.getCause() instanceof IllegalStateException) {
                    IllegalStateException ise = (IllegalStateException)e.getCause();
                    if (ise.getMessage() != null && ise.getMessage().contains("Expected a string but was BEGIN_OBJECT")) {
                        LOGGER.debug("Catching exception because of issue https://github.com/kubernetes-client/java/issues/86", (Throwable)e);
                        ResourceManager.this.consoleLogger.println(Messages.KubernetesClientWrapper_deleted(this.get(), null));
                    }
                    throw e;
                }
                throw e;
            }
        }

        abstract T getCurrentResource();

        abstract T applyResource(T var1, T var2);

        abstract T createResource(T var1);

        abstract V1Status deleteResource(T var1);

        abstract void notifyUpdate(T var1, T var2);

        void logApplied(T res) {
            ResourceManager.this.getConsoleLogger().println(Messages.KubernetesClientWrapper_applied(res.getClass().getSimpleName(), res));
        }

        void logCreated(T res) {
            ResourceManager.this.getConsoleLogger().println(Messages.KubernetesClientWrapper_created(res.getClass().getSimpleName(), res));
        }

        void logDeleted(V1Status status) {
            if (status != null) {
                ResourceManager.this.getConsoleLogger().println(Messages.KubernetesClientWrapper_deleted(this.get().getClass().getSimpleName(), status));
            } else {
                ResourceManager.this.getConsoleLogger().println(Messages.KubernetesClientWrapper_resourceNotFound(this.get().getClass().getSimpleName(), this.getName()));
            }
        }
    }
}

