/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.wrapper;

import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import com.microsoft.jenkins.kubernetes.util.CommonUtils;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.util.DockerConfigBuilder;
import com.microsoft.jenkins.kubernetes.wrapper.Messages;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceManager;
import com.microsoft.jenkins.kubernetes.wrapper.ResourceUpdaterMap;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.util.VariableResolver;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1Namespace;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretBuilder;
import io.kubernetes.client.openapi.models.V1SecretFluent;
import io.kubernetes.client.util.ClientBuilder;
import io.kubernetes.client.util.Config;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.Yaml;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.ClientCertificateAuthentication;
import io.kubesphere.jenkins.kubernetes.generated.KubernetesModelClasses;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesClientWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesClientWrapper.class);
    private final ApiClient client;
    private PrintStream logger = System.out;
    private VariableResolver<String> variableResolver;
    private boolean deleteResource;
    private static Map<String, String> apiGroups = new HashMap<String, String>();
    private static List<String> apiVersions = new ArrayList<String>();

    private static void initApiGroupMap() {
        apiGroups.put("Admissionregistration", "admissionregistration.k8s.io");
        apiGroups.put("Apiextensions", "apiextensions.k8s.io");
        apiGroups.put("Apiregistration", "apiregistration.k8s.io");
        apiGroups.put("Apps", "apps");
        apiGroups.put("Authentication", "authentication.k8s.io");
        apiGroups.put("Authorization", "authorization.k8s.io");
        apiGroups.put("Autoscaling", "autoscaling");
        apiGroups.put("Extensions", "extensions");
        apiGroups.put("Batch", "batch");
        apiGroups.put("Certificates", "certificates.k8s.io");
        apiGroups.put("Networking", "networking.k8s.io");
        apiGroups.put("Policy", "policy");
        apiGroups.put("RbacAuthorization", "rbac.authorization.k8s.io");
        apiGroups.put("Scheduling", "scheduling.k8s.io");
        apiGroups.put("Settings", "settings.k8s.io");
        apiGroups.put("Storage", "storage.k8s.io");
    }

    private static void initApiVersionList() {
        apiVersions.add("V2beta1");
        apiVersions.add("V2beta2");
        apiVersions.add("V2alpha1");
        apiVersions.add("V1beta2");
        apiVersions.add("V1beta1");
        apiVersions.add("V1alpha1");
        apiVersions.add("V1");
    }

    private static Pair<String, String> getApiGroup(String name) {
        MutablePair parts = new MutablePair();
        for (Map.Entry<String, String> apiGroup : apiGroups.entrySet()) {
            if (!name.startsWith(apiGroup.getKey())) continue;
            parts.left = apiGroup.getValue();
            parts.right = name.substring(apiGroup.getKey().length());
            break;
        }
        if (parts.left == null) {
            parts.right = name;
        }
        return parts;
    }

    private static Pair<String, String> getApiVersion(String name) {
        MutablePair parts = new MutablePair();
        for (String version : apiVersions) {
            if (!name.startsWith(version)) continue;
            parts.left = version.toLowerCase();
            parts.right = name.substring(version.length());
            break;
        }
        if (parts.left == null) {
            parts.right = name;
        }
        return parts;
    }

    private static void initModelMap() throws IOException {
        KubernetesClientWrapper.initApiGroupMap();
        KubernetesClientWrapper.initApiVersionList();
        for (Class clazz : KubernetesModelClasses.getAllClasses()) {
            String apiGroupVersion = "";
            String kind = "";
            Pair<String, String> nameParts = KubernetesClientWrapper.getApiGroup(clazz.getSimpleName());
            apiGroupVersion = apiGroupVersion + (nameParts.getLeft() == null ? "" : (String)nameParts.getLeft() + "/");
            nameParts = KubernetesClientWrapper.getApiVersion((String)nameParts.getRight());
            apiGroupVersion = apiGroupVersion + (nameParts.getLeft() == null ? "" : (String)nameParts.getLeft());
            kind = kind + (String)nameParts.getRight();
            Yaml.addModelMap((String)apiGroupVersion, (String)kind, (Class)clazz);
        }
    }

    public KubernetesClientWrapper(String kubeConfig) {
        File file = new File(kubeConfig);
        if (file.exists()) {
            try (FileInputStream in = new FileInputStream(file);){
                kubeConfig = IOUtils.toString((InputStream)in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        KubeConfig config = KubeConfig.loadKubeConfig((Reader)new StringReader(kubeConfig));
        try {
            this.client = Config.fromConfig((KubeConfig)config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public KubernetesClientWrapper(Reader kubeConfigReader) {
        KubeConfig config = KubeConfig.loadKubeConfig((Reader)kubeConfigReader);
        try {
            this.client = Config.fromConfig((KubeConfig)config);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public KubernetesClientWrapper(String server, String certificateAuthorityData, String clientCertificateData, String clientKeyData) {
        ClientCertificateAuthentication authentication = new ClientCertificateAuthentication(clientCertificateData.getBytes(StandardCharsets.UTF_8), clientKeyData.getBytes(StandardCharsets.UTF_8));
        this.client = new ClientBuilder().setBasePath(server).setAuthentication((Authentication)authentication).setCertificateAuthority(certificateAuthorityData.getBytes(StandardCharsets.UTF_8)).build();
    }

    public ApiClient getClient() {
        return this.client;
    }

    public PrintStream getLogger() {
        return this.logger;
    }

    public boolean isDeleteResource() {
        return this.deleteResource;
    }

    public KubernetesClientWrapper withDeleteResource(boolean isDeleteResource) {
        this.deleteResource = isDeleteResource;
        return this;
    }

    public KubernetesClientWrapper withLogger(PrintStream log) {
        this.logger = log;
        return this;
    }

    public VariableResolver<String> getVariableResolver() {
        return this.variableResolver;
    }

    public KubernetesClientWrapper withVariableResolver(VariableResolver<String> resolver) {
        this.variableResolver = resolver;
        return this;
    }

    public void apply(FilePath[] configFiles) throws IOException, InterruptedException, ApiException {
        for (FilePath path : configFiles) {
            List resources;
            this.log(Messages.KubernetesClientWrapper_loadingConfiguration(path));
            try {
                InputStream inputStream = CommonUtils.replaceMacro(path.read(), this.variableResolver);
                resources = Yaml.loadAll((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new IOException(Messages.KubernetesClientWrapper_invalidYaml(path.getName(), e));
            }
            if (resources.isEmpty()) {
                this.log(Messages.KubernetesClientWrapper_noResourceLoadedFrom(path));
                continue;
            }
            Iterator iterator = resources.iterator();
            while (iterator.hasNext()) {
                Object resource = iterator.next();
                if (!(resource instanceof V1Namespace)) continue;
                this.handleResource(resource);
                iterator.remove();
            }
            for (Object resource : resources) {
                this.handleResource(resource);
            }
        }
    }

    private void handleResource(Object resource) {
        Pair<Class<? extends ResourceManager>, Class<? extends ResourceManager.ResourceUpdater>> updaterPair = ResourceUpdaterMap.getUnmodifiableInstance().get(resource.getClass());
        ResourceManager.ResourceUpdater updater = null;
        if (updaterPair != null) {
            try {
                Constructor constructor = ((Class)updaterPair.getRight()).getDeclaredConstructor((Class)updaterPair.getLeft(), resource.getClass());
                Constructor resourceManagerConstructor = ((Class)updaterPair.getLeft()).getConstructor(ApiClient.class);
                ResourceManager resourceManager = (ResourceManager)resourceManagerConstructor.newInstance(this.getClient());
                resourceManager.setConsoleLogger(this.getLogger());
                updater = (ResourceManager.ResourceUpdater)constructor.newInstance(resourceManager, resource);
            }
            catch (Exception e) {
                this.log(Messages.KubernetesClientWrapper_illegalUpdater(resource, e));
            }
            if (updater != null && !this.deleteResource) {
                updater.createOrApply();
            } else if (updater != null && this.deleteResource) {
                updater.delete();
            } else {
                this.log(Messages.KubernetesClientWrapper_illegalUpdater(resource, null));
            }
        } else {
            this.log(Messages.KubernetesClientWrapper_skipped(resource));
        }
    }

    public void createOrReplaceSecrets(String kubernetesNamespace, String secretName, List<ResolvedDockerRegistryEndpoint> credentials) throws IOException, ApiException {
        this.log(Messages.KubernetesClientWrapper_prepareSecretsWithName(secretName));
        DockerConfigBuilder dockerConfigBuilder = new DockerConfigBuilder(credentials);
        String dockercfg = dockerConfigBuilder.buildDockercfgString();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(".dockercfg", dockercfg);
        V1Secret secret = ((V1SecretBuilder)((V1SecretBuilder)((V1SecretBuilder)((V1SecretFluent.MetadataNested)((V1SecretFluent.MetadataNested)new V1SecretBuilder().withNewMetadata().withName(secretName)).withNamespace(kubernetesNamespace)).endMetadata()).withStringData(data)).withType("kubernetes.io/dockercfg")).build();
        this.handleResource(secret);
    }

    private static void restoreProperty(String name, String value) {
        if (value == null) {
            System.clearProperty(name);
        } else {
            System.setProperty(name, value);
        }
    }

    public static String prepareSecretName(String nameCfg, String defaultName, EnvVars envVars) {
        String name = StringUtils.trimToEmpty((String)envVars.expand(nameCfg));
        if (name.length() > 253) {
            throw new IllegalArgumentException(Messages.KubernetesClientWrapper_secretNameTooLong(name));
        }
        if (!name.isEmpty()) {
            if (!Constants.KUBERNETES_NAME_PATTERN.matcher(name).matches()) {
                throw new IllegalArgumentException(Messages.KubernetesClientWrapper_illegalSecretName(name));
            }
            return name;
        }
        name = defaultName;
        if (StringUtils.isBlank((String)name)) {
            name = UUID.randomUUID().toString();
        }
        if ((name = "acs-plugin-" + name.replaceAll("[^0-9a-zA-Z]", "-").toLowerCase()).length() > 253) {
            name = name.substring(0, 253);
        }
        int suffixLength = 253 - name.length();
        int randomLength = 8;
        if (suffixLength > 8) {
            suffixLength = 8;
        }
        String suffix = CommonUtils.randomString(suffixLength, true);
        if ((name = name + suffix).charAt(name.length() - 1) == '-') {
            name = name.substring(0, name.length() - 1) + 'a';
        }
        return name;
    }

    private void log(String message) {
        if (this.logger != null) {
            this.logger.println(message);
        }
    }

    static {
        try {
            KubernetesClientWrapper.initModelMap();
        }
        catch (Exception ex) {
            LOGGER.error("Unexpected exception while loading classes: " + ex);
        }
    }
}

