/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes.credentials;

import com.microsoft.jenkins.kubernetes.Messages;
import com.microsoft.jenkins.kubernetes.credentials.ClientWrapperFactory;
import com.microsoft.jenkins.kubernetes.wrapper.KubernetesClientWrapper;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.FormValidation;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Deprecated
public class TextCredentials
extends AbstractDescribableImpl<TextCredentials>
implements ClientWrapperFactory.Builder {
    private String serverUrl;
    private String certificateAuthorityData;
    private String clientCertificateData;
    private String clientKeyData;

    @DataBoundConstructor
    public TextCredentials() {
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    @DataBoundSetter
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getCertificateAuthorityData() {
        return this.certificateAuthorityData;
    }

    @DataBoundSetter
    public void setCertificateAuthorityData(String certificateAuthorityData) {
        this.certificateAuthorityData = certificateAuthorityData;
    }

    public String getClientCertificateData() {
        return this.clientCertificateData;
    }

    @DataBoundSetter
    public void setClientCertificateData(String clientCertificateData) {
        this.clientCertificateData = clientCertificateData;
    }

    public String getClientKeyData() {
        return this.clientKeyData;
    }

    @DataBoundSetter
    public void setClientKeyData(String clientKeyData) {
        this.clientKeyData = clientKeyData;
    }

    @Override
    public ClientWrapperFactory buildClientWrapperFactory(Item owner) {
        return new ClientWrapperFactoryImpl(this.getServerUrl(), this.getCertificateAuthorityData(), this.getClientCertificateData(), this.getClientKeyData());
    }

    private static class ClientWrapperFactoryImpl
    implements ClientWrapperFactory {
        private static final long serialVersionUID = 1L;
        private final String serverUrl;
        private final String certificateAuthorityData;
        private final String clientCertificateData;
        private final String clientKeyData;

        ClientWrapperFactoryImpl(String serverUrl, String certificateAuthorityData, String clientCertificateData, String clientKeyData) {
            this.serverUrl = serverUrl;
            this.certificateAuthorityData = certificateAuthorityData;
            this.clientCertificateData = clientCertificateData;
            this.clientKeyData = clientKeyData;
        }

        @Override
        public KubernetesClientWrapper buildClient(FilePath workspace) throws Exception {
            return new KubernetesClientWrapper(this.serverUrl, this.certificateAuthorityData, this.clientCertificateData, this.clientKeyData);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<TextCredentials> {
        public FormValidation doCheckServerUrl(@QueryParameter String value) {
            if ((value = StringUtils.trimToEmpty((String)value)).isEmpty()) {
                return FormValidation.error((String)Messages.TextCredentials_serverUrlRequired());
            }
            if (!value.startsWith("https://")) {
                return FormValidation.error((String)Messages.TextCredentials_serverUrlShouldBeHttps());
            }
            return FormValidation.ok();
        }

        public String getDefaultServerUrl() {
            return "https://";
        }
    }
}

