/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.microsoft.jenkins.azurecommons.JobContext;
import com.microsoft.jenkins.azurecommons.command.BaseCommandContext;
import com.microsoft.jenkins.azurecommons.command.CommandService;
import com.microsoft.jenkins.azurecommons.command.IBaseCommandData;
import com.microsoft.jenkins.azurecommons.command.ICommand;
import com.microsoft.jenkins.azurecommons.command.SimpleBuildStepExecution;
import com.microsoft.jenkins.azurecommons.remote.SSHClient;
import com.microsoft.jenkins.kubernetes.KubernetesDeploy;
import com.microsoft.jenkins.kubernetes.Messages;
import com.microsoft.jenkins.kubernetes.command.DeploymentCommand;
import com.microsoft.jenkins.kubernetes.credentials.ClientWrapperFactory;
import com.microsoft.jenkins.kubernetes.credentials.ConfigFileCredentials;
import com.microsoft.jenkins.kubernetes.credentials.KubeconfigCredentials;
import com.microsoft.jenkins.kubernetes.credentials.KubernetesCredentialsType;
import com.microsoft.jenkins.kubernetes.credentials.ResolvedDockerRegistryEndpoint;
import com.microsoft.jenkins.kubernetes.credentials.SSHCredentials;
import com.microsoft.jenkins.kubernetes.credentials.TextCredentials;
import com.microsoft.jenkins.kubernetes.util.Constants;
import com.microsoft.jenkins.kubernetes.wrapper.KubernetesClientWrapper;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryToken;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class KubernetesDeployContext
extends BaseCommandContext
implements DeploymentCommand.IDeploymentCommand {
    private String kubeconfigId;
    private String credentialsType;
    private SSHCredentials ssh;
    private ConfigFileCredentials kubeConfig;
    private TextCredentials textCredentials;
    private String configs;
    private boolean enableConfigSubstitution = true;
    private String secretNamespace;
    private String secretName;
    private List<DockerRegistryEndpoint> dockerCredentials;
    private boolean deleteResource;

    @DataBoundConstructor
    public KubernetesDeployContext() {
    }

    public void configure(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        CommandService commandService = CommandService.builder().withSingleCommand(DeploymentCommand.class).withStartCommand(DeploymentCommand.class).build();
        JobContext jobContext = new JobContext(run, workspace, launcher, listener);
        super.configure(jobContext, commandService);
    }

    public String getKubeconfigId() {
        return this.kubeconfigId;
    }

    @DataBoundSetter
    public void setKubeconfigId(String kubeconfigId) {
        this.kubeconfigId = kubeconfigId;
    }

    @Deprecated
    public String getCredentialsType() {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.credentialsType)) {
            return KubernetesCredentialsType.DEFAULT.name();
        }
        return this.credentialsType;
    }

    @Deprecated
    public KubernetesCredentialsType getCredentialsTypeEnum() {
        return KubernetesCredentialsType.fromString(this.getCredentialsType());
    }

    @DataBoundSetter
    @Deprecated
    public void setCredentialsType(String credentialsType) {
        this.credentialsType = org.apache.commons.lang3.StringUtils.trimToEmpty((String)credentialsType);
    }

    @Deprecated
    public SSHCredentials getSsh() {
        return this.ssh;
    }

    @Deprecated
    @DataBoundSetter
    public void setSsh(SSHCredentials ssh) {
        this.ssh = ssh;
    }

    @Deprecated
    public ConfigFileCredentials getKubeConfig() {
        return this.kubeConfig;
    }

    @Deprecated
    @DataBoundSetter
    public void setKubeConfig(ConfigFileCredentials kubeConfig) {
        this.kubeConfig = kubeConfig;
    }

    @Deprecated
    public TextCredentials getTextCredentials() {
        return this.textCredentials;
    }

    @Deprecated
    @DataBoundSetter
    public void setTextCredentials(TextCredentials textCredentials) {
        this.textCredentials = textCredentials;
    }

    @Override
    public String getSecretNamespace() {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.secretNamespace) ? this.secretNamespace : "default";
    }

    @DataBoundSetter
    public void setSecretNamespace(String secretNamespace) {
        this.secretNamespace = "default".equals(secretNamespace) ? null : secretNamespace;
    }

    @Override
    public String getConfigs() {
        return this.configs;
    }

    @DataBoundSetter
    public void setConfigs(String configs) {
        this.configs = configs;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @DataBoundSetter
    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    @Override
    public boolean isEnableConfigSubstitution() {
        return this.enableConfigSubstitution;
    }

    @DataBoundSetter
    public void setEnableConfigSubstitution(boolean enableConfigSubstitution) {
        this.enableConfigSubstitution = enableConfigSubstitution;
    }

    public List<DockerRegistryEndpoint> getDockerCredentials() {
        if (this.dockerCredentials == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf(this.dockerCredentials);
    }

    @DataBoundSetter
    public void setDockerCredentials(List<DockerRegistryEndpoint> dockerCredentials) {
        ArrayList<DockerRegistryEndpoint> endpoints = new ArrayList<DockerRegistryEndpoint>();
        for (DockerRegistryEndpoint endpoint : dockerCredentials) {
            String credentialsId = StringUtils.trimToNull((String)endpoint.getCredentialsId());
            if (credentialsId == null) continue;
            String registryUrl = StringUtils.trimToNull((String)endpoint.getUrl());
            if (registryUrl != null && !Constants.URI_SCHEME_PREFIX.matcher(registryUrl).find()) {
                registryUrl = "http://" + registryUrl;
            }
            endpoints.add(new DockerRegistryEndpoint(registryUrl, credentialsId));
        }
        this.dockerCredentials = endpoints;
    }

    @Override
    public boolean isDeleteResource() {
        return this.deleteResource;
    }

    @DataBoundSetter
    public void setDeleteResource(boolean isDeleteResource) {
        this.deleteResource = isDeleteResource;
    }

    @Override
    public List<ResolvedDockerRegistryEndpoint> resolveEndpoints(Item context) throws IOException {
        ArrayList<ResolvedDockerRegistryEndpoint> endpoints = new ArrayList<ResolvedDockerRegistryEndpoint>();
        List<DockerRegistryEndpoint> configured = this.getDockerCredentials();
        for (DockerRegistryEndpoint endpoint : configured) {
            DockerRegistryToken token = endpoint.getToken(context);
            if (token == null) {
                throw new IllegalArgumentException("No credentials found for " + endpoint);
            }
            endpoints.add(new ResolvedDockerRegistryEndpoint(endpoint.getEffectiveUrl(), token));
        }
        return endpoints;
    }

    @Override
    public ClientWrapperFactory clientFactory(Item owner) {
        String configId = this.getKubeconfigId();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)configId)) {
            KubeconfigCredentials credentials = (KubeconfigCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(KubeconfigCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)configId));
            if (credentials == null) {
                throw new IllegalArgumentException("Cannot find kubeconfig credentials with id " + configId);
            }
            credentials.bindToAncestor(owner);
            return new ClientWrapperFactoryImpl(credentials);
        }
        switch (this.getCredentialsTypeEnum()) {
            case SSH: {
                return this.getSsh().buildClientWrapperFactory(owner);
            }
            case KubeConfig: {
                return this.getKubeConfig().buildClientWrapperFactory(owner);
            }
            case Text: {
                return this.getTextCredentials().buildClientWrapperFactory(owner);
            }
        }
        throw new IllegalStateException(Messages.KubernetesDeployContext_unknownCredentialsType((Object)this.getCredentialsTypeEnum()));
    }

    public IBaseCommandData getDataForCommand(ICommand command) {
        return this;
    }

    public StepExecution startImpl(StepContext context) throws Exception {
        return new SimpleBuildStepExecution((SimpleBuildStep)new KubernetesDeploy(this), context);
    }

    private static class ClientWrapperFactoryImpl
    implements ClientWrapperFactory {
        private final KubeconfigCredentials kubeconfig;

        ClientWrapperFactoryImpl(KubeconfigCredentials kubeconfig) {
            this.kubeconfig = kubeconfig;
        }

        @Override
        public KubernetesClientWrapper buildClient(FilePath workspace) {
            return new KubernetesClientWrapper(new StringReader(this.kubeconfig.getContent()));
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public ListBoxModel doFillCredentialsTypeItems() {
            ListBoxModel model = new ListBoxModel();
            for (KubernetesCredentialsType type : KubernetesCredentialsType.values()) {
                model.add(type.title(), type.name());
            }
            return model;
        }

        public ListBoxModel doFillKubeconfigIdItems(@AncestorInPath Item owner) {
            StandardListBoxModel model = new StandardListBoxModel();
            model.includeEmptyValue();
            model.includeAs(ACL.SYSTEM, owner, KubeconfigCredentials.class);
            return model;
        }

        public FormValidation doVerifyConfiguration(@AncestorInPath Item owner, @QueryParameter(value="kubeconfigId") String configId, @QueryParameter String credentialsType, @QueryParameter(value="path") String kubeconfigPath, @QueryParameter String sshServer, @QueryParameter String sshCredentialsId, @QueryParameter(value="serverUrl") String txtServerUrl, @QueryParameter(value="certificateAuthorityData") String txtCertificateAuthorityData, @QueryParameter(value="clientCertificateData") String txtClientCertificateData, @QueryParameter(value="clientKeyData") String txtClientKeyData, @QueryParameter String configs) {
            try {
                return this.verifyConfigurationInternal(owner, configId, credentialsType, kubeconfigPath, sshServer, sshCredentialsId, txtServerUrl, txtCertificateAuthorityData, txtClientCertificateData, txtClientKeyData, configs);
            }
            catch (Exception ex) {
                return FormValidation.error((String)ex.getMessage());
            }
        }

        /*
         * Unable to fully structure code
         */
        private FormValidation verifyConfigurationInternal(Item owner, String configId, String credentialsType, String kubeconfigPath, String sshServer, String sshCredentialsId, String txtServerUrl, String txtCertificateAuthorityData, String txtClientCertificateData, String txtClientKeyData, String configs) {
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)configId)) {
                credentials = (KubeconfigCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(KubeconfigCredentials.class, (Item)owner, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)configId));
                if (credentials == null) {
                    return FormValidation.error((String)Messages.KubernetesDeployContext_kubeconfigCredentialsNotFound(configId));
                }
                credentials.bindToAncestor(owner);
                content = credentials.getContent();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)content)) {
                    return FormValidation.error((String)Messages.KubernetesDeployContext_noKubeconfigContent());
                }
            } else {
                switch (1.$SwitchMap$com$microsoft$jenkins$kubernetes$credentials$KubernetesCredentialsType[KubernetesCredentialsType.fromString(credentialsType).ordinal()]) {
                    case 2: {
                        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)kubeconfigPath)) break;
                        return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_kubeconfigNotConfigured()));
                    }
                    case 1: {
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sshServer)) {
                            return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_sshServerNotConfigured()));
                        }
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)sshCredentialsId) || "*".equals(sshCredentialsId)) {
                            return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_sshCredentialsNotSelected()));
                        }
                        sshCredentials = new SSHCredentials();
                        sshCredentials.setSshCredentialsId(org.apache.commons.lang3.StringUtils.trimToEmpty((String)sshCredentialsId));
                        sshCredentials.setSshServer(org.apache.commons.lang3.StringUtils.trimToEmpty((String)sshServer));
                        client = new SSHClient(sshCredentials.getHost(), sshCredentials.getPort(), sshCredentials.getSshCredentials(owner));
                        connected = client.connect();
                        var15_18 = null;
                        try {
                            connected.execRemote("test -e .kube/config", false, false);
                        }
                        catch (SSHClient.ExitStatusException e) {
                            var17_22 = FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_cannotFindKubeconfigOnServer(".kube/config", sshServer)));
                            if (connected != null) {
                                if (var15_18 != null) {
                                    try {
                                        connected.close();
                                    }
                                    catch (Throwable var18_23) {
                                        var15_18.addSuppressed(var18_23);
                                    }
                                } else {
                                    connected.close();
                                }
                            }
                            return var17_22;
                        }
                        try {
                            if (connected == null) break;
                            if (var15_18 != null) {
                                try {
                                    connected.close();
                                }
                                catch (Throwable var16_20) {
                                    var15_18.addSuppressed(var16_20);
                                }
                                break;
                            }
                            connected.close();
                            ** break;
                            {
                                catch (Throwable var16_21) {
                                    try {
                                        var15_18 = var16_21;
                                        throw var16_21;
                                    }
                                    catch (Throwable var19_24) {
                                        if (connected != null) {
                                            if (var15_18 != null) {
                                                try {
                                                    connected.close();
                                                }
                                                catch (Throwable var20_25) {
                                                    var15_18.addSuppressed(var20_25);
                                                }
                                            } else {
                                                connected.close();
                                            }
                                        }
                                        throw var19_24;
lbl69:
                                        // 1 sources

                                        break;
                                    }
                                }
                            }
                        }
                        catch (Exception e) {
                            return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_failedOnSSH(e.getMessage())));
                        }
                    }
                    case 3: {
                        txtServerUrl = org.apache.commons.lang3.StringUtils.trimToEmpty((String)txtServerUrl);
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)txtServerUrl)) {
                            return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_serverUrlNotConfigured()));
                        }
                        if (!txtServerUrl.startsWith("https://")) {
                            return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_serverUrlNotHttps()));
                        }
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)txtCertificateAuthorityData)) {
                            return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_certificateAuthorityNotConfigured()));
                        }
                        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)txtClientCertificateData)) {
                            return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_clientCertificateDataNotConfigured()));
                        }
                        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)txtClientKeyData)) break;
                        return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_clientKeyDataNotConfigured()));
                    }
                }
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)configs)) {
                return FormValidation.error((String)Messages.errorMessage(Messages.KubernetesDeployContext_configsNotConfigured()));
            }
            return FormValidation.ok((String)Messages.KubernetesDeployContext_validateSuccess());
        }

        public String getDefaultSecretNamespace() {
            return "default";
        }

        public boolean getDefaultEnableConfigSubstitution() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class, Launcher.class, TaskListener.class, EnvVars.class);
        }

        public String getFunctionName() {
            return "kubernetesDeploy";
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.pluginDisplayName();
        }
    }
}

