/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jenkins.kubernetes;

import com.microsoft.jenkins.kubernetes.KubernetesDeployContext;
import com.microsoft.jenkins.kubernetes.Messages;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.DataBoundConstructor;

public class KubernetesDeploy
extends Builder
implements SimpleBuildStep {
    private final KubernetesDeployContext context;

    @DataBoundConstructor
    public KubernetesDeploy(KubernetesDeployContext context) {
        this.context = context;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println(Messages.KubernetesDeploy_starting());
        this.context.configure(run, workspace, launcher, listener);
        this.context.executeCommands();
        if (this.context.getLastCommandState().isError()) {
            run.setResult(Result.FAILURE);
            throw new AbortException(Messages.KubernetesDeploy_endWithErrorState(this.context.getCommandState()));
        }
        listener.getLogger().println(Messages.KubernetesDeploy_finished());
    }

    public KubernetesDeployContext getContext() {
        return this.context;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return Messages.pluginDisplayName();
        }
    }
}

