/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.koji.xmlrpc;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.xmlrpc.XmlRpcException;
import org.jenkinsci.plugins.koji.xmlrpc.KojiClient;
import org.jenkinsci.plugins.koji.xmlrpc.KojiSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLRPCTest {
    private KojiClient koji;
    private final String build = "classworlds-classworlds-1.1_alpha_2-1";
    private final String pkg = "classworlds-classworlds";
    private final String tag = "mead-import-maven-all";
    private Logger logger;

    public static void main(String[] args) {
        String kojiInstanceURL = "http://koji.localdomain/kojihub";
        XMLRPCTest kojiTest = new XMLRPCTest(kojiInstanceURL);
        kojiTest.executeTests();
    }

    private void initLogger() {
        this.logger = LogManager.getLogger(this.getClass());
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.DEBUG);
        RollingFileAppender fileAppender = null;
        try {
            fileAppender = new RollingFileAppender((Layout)new PatternLayout("%d{dd-MM-yyyy HH:mm:ss} %C %L %-5p:%m%n"), "file.log");
            this.logger.addAppender((Appender)fileAppender);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.logger.info((Object)"TEST LOG ENTRY");
    }

    public XMLRPCTest(String kojiInstanceURL) {
        this.initLogger();
        try {
            this.koji = KojiClient.getKojiClient(kojiInstanceURL);
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)e.getMessage());
        }
        this.koji.setDebug(true);
    }

    public void executeTests() {
        this.testKojiHello();
        this.testLogin();
        KojiClient.BuildParams buildParams = new KojiClient.BuildParamsBuilder().setTag("mead-import-maven-all").setPackage("classworlds-classworlds").setLatest(true).build();
    }

    private void testLogin() {
        KojiSession session = null;
        try {
            session = this.koji.login("kojiadmin", "kojiadmin");
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        System.out.println(this.koji.getSession());
    }

    public static void printMap(Map<String, String> map) {
        for (Map.Entry<String, String> m : map.entrySet()) {
            String key = m.getKey();
            String value = m.getValue();
            System.out.println(key + ": " + value);
        }
    }

    private void testKojiHello() {
        String hello = this.koji.sayHello();
        System.out.println(hello);
    }

    private void testListTaggedBuilds() {
        KojiClient.BuildParams buildParams = new KojiClient.BuildParamsBuilder().setTag("mead-import-maven-all").setPackage("classworlds-classworlds").setLatest(true).build();
        List<Map<String, String>> results = null;
        try {
            results = this.koji.listTaggedBuilds(buildParams);
        }
        catch (XmlRpcException e) {
            if (e.getMessage() == "empty") {
                System.out.println("No build with id=classworlds-classworlds-1.1_alpha_2-1 found in the database.");
                return;
            }
            e.printStackTrace();
        }
        for (Map<String, String> map : results) {
            XMLRPCTest.printMap(map);
        }
    }

    private void testGeBuildInfo() {
        Map<String, String> buildInfo = null;
        try {
            buildInfo = this.koji.getBuildInfo("classworlds-classworlds-1.1_alpha_2-1");
        }
        catch (XmlRpcException e) {
            if (e.getMessage() == "empty") {
                System.out.println("No build with id=classworlds-classworlds-1.1_alpha_2-1 found in the database.");
                return;
            }
            e.printStackTrace();
        }
        XMLRPCTest.printMap(buildInfo);
    }

    private void testGetLatestBuilds() {
        Map<String, String> result = null;
        try {
            result = this.koji.getLatestBuilds("mead-import-maven-all", "classworlds-classworlds");
        }
        catch (XmlRpcException e) {
            if (e.getMessage() == "empty") {
                System.out.println("No package classworlds-classworlds found for tag mead-import-maven-all");
                return;
            }
            System.out.println(e.getMessage());
            return;
        }
        XMLRPCTest.printMap(result);
    }
}

