/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.koji.xmlrpc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcCommonsTransport;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcStreamTransport;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.jenkinsci.plugins.koji.xmlrpc.MyLoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyXmlRpcCommonsTransportFactory
extends XmlRpcCommonsTransportFactory {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public MyXmlRpcCommonsTransportFactory(XmlRpcClient pClient) {
        super(pClient);
    }

    public XmlRpcTransport getTransport() {
        return new LoggingTransport(this);
    }

    private class LoggingTransport
    extends XmlRpcCommonsTransport {
        public LoggingTransport(MyXmlRpcCommonsTransportFactory pFactory) {
            super((XmlRpcCommonsTransportFactory)pFactory);
        }

        protected void writeRequest(XmlRpcStreamTransport.ReqWriter pWriter) throws XmlRpcException {
            super.writeRequest(pWriter);
            if (MyXmlRpcCommonsTransportFactory.this.logger.isDebugEnabled()) {
                MyLoggingUtils.logRequest(MyXmlRpcCommonsTransportFactory.this.logger, this.method.getRequestEntity());
            }
        }

        protected InputStream getInputStream() throws XmlRpcException {
            InputStream istream = super.getInputStream();
            if (MyXmlRpcCommonsTransportFactory.this.logger.isDebugEnabled()) {
                return new ByteArrayInputStream(MyLoggingUtils.logResponse(MyXmlRpcCommonsTransportFactory.this.logger, istream).getBytes());
            }
            return istream;
        }
    }
}

