/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.koji.xmlrpc;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KojiSession {
    private String sessionId;
    private String sessionKey;
    private String encodedSessionId;
    private String encodedSessionKey;
    private String kojiInstanceURL;

    public KojiSession(String kojiInstanceURL, Map<String, ?> xmlRpcResult) {
        this(kojiInstanceURL, KojiSession.parseSessionId(xmlRpcResult), (String)xmlRpcResult.get("session-key"));
    }

    public KojiSession(String kojiInstanceURL, String sessionId, String sessionKey) {
        this.kojiInstanceURL = kojiInstanceURL;
        this.sessionId = sessionId;
        this.sessionKey = sessionKey;
        this.encodedSessionId = this.encodeUTF(sessionId);
        this.encodedSessionKey = this.encodeUTF(sessionKey);
    }

    private String encodeUTF(String string) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return encoded;
    }

    private static String parseSessionId(Map<String, ?> xmlRpcResult) {
        Integer sessionIdInt = (Integer)xmlRpcResult.get("session-id");
        return sessionIdInt.toString();
    }

    public String getAuthenticatedHubURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.kojiInstanceURL);
        if (!this.kojiInstanceURL.endsWith("/")) {
            sb.append("/");
        }
        sb.append("?session-id=");
        sb.append(this.encodedSessionId);
        sb.append("&session-key=");
        sb.append(this.encodedSessionKey);
        return sb.toString();
    }
}

