/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.koji.xmlrpc;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcCommonsTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.apache.xmlrpc.common.TypeFactory;
import org.apache.xmlrpc.common.XmlRpcController;
import org.jenkinsci.plugins.koji.xmlrpc.KojiSession;
import org.jenkinsci.plugins.koji.xmlrpc.MyTypeFactory;
import org.jenkinsci.plugins.koji.xmlrpc.MyXmlRpcCommonsTransportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KojiClient {
    private XmlRpcClient koji;
    private static KojiClient instance;
    private String kojiInstanceURL;

    public String getKojiInstanceURL() {
        return this.kojiInstanceURL;
    }

    private KojiClient(String kojiInstanceURL) throws MalformedURLException {
        this.kojiInstanceURL = kojiInstanceURL;
        this.koji = this.connect(kojiInstanceURL);
    }

    public static KojiClient getKojiClient(String kojiInstanceURL) throws MalformedURLException {
        if (instance == null) {
            instance = new KojiClient(kojiInstanceURL);
        } else if (instance.getKojiInstanceURL() != kojiInstanceURL) {
            instance.setServerURL(kojiInstanceURL);
        }
        return instance;
    }

    public KojiSession login(String userName, String password) throws XmlRpcException {
        ArrayList<String> params = new ArrayList<String>();
        params.add(userName);
        params.add(password);
        Map session = null;
        session = (Map)this.koji.execute("login", params);
        KojiSession kojiSession = new KojiSession(this.kojiInstanceURL, session);
        this.setServerURL(kojiSession.getAuthenticatedHubURL());
        return kojiSession;
    }

    public Map<String, String> getLatestBuilds(String tag, String pkg) throws XmlRpcException {
        ArrayList<String> params = new ArrayList<String>();
        params.add(tag);
        params.add(null);
        params.add(pkg);
        Object[] latestBuilds = null;
        Map buildInfo = null;
        latestBuilds = (Object[])this.koji.execute("getLatestBuilds", params);
        if (latestBuilds == null) {
            throw new XmlRpcException("empty");
        }
        if (latestBuilds.length == 0) {
            throw new XmlRpcException("empty");
        }
        buildInfo = (Map)latestBuilds[0];
        return buildInfo;
    }

    public Map<String, String> getBuildInfo(String buildId) throws XmlRpcException {
        ArrayList<String> params = new ArrayList<String>();
        params.add(buildId);
        Map buildInfo = (Map)this.koji.execute("getBuild", params);
        if (buildInfo == null) {
            throw new XmlRpcException("empty");
        }
        return buildInfo;
    }

    public String getSession() {
        String result = null;
        try {
            result = (String)this.koji.execute("showSession", new Object[0]);
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Map<String, String>> listTaggedBuilds(BuildParams buildParams) throws XmlRpcException {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(buildParams.getTag());
        params.add(null);
        params.add(false);
        params.add(null);
        params.add(buildParams.isLatest());
        params.add(buildParams.getPkg());
        params.add(buildParams.getOwner());
        params.add(buildParams.getType());
        Object[] objects = null;
        objects = (Object[])this.koji.execute("listTagged", params);
        if (objects == null) {
            throw new XmlRpcException("empty");
        }
        LinkedList<Map<String, String>> results = new LinkedList<Map<String, String>>();
        for (Object o : objects) {
            Map map = (Map)o;
            results.add(map);
        }
        return results;
    }

    public String sayHello() {
        StringBuilder sb = new StringBuilder();
        try {
            Object result = this.koji.execute("hello", new Object[]{"Hello"});
            sb.append("Jenkins-Koji Plugin: Hello Koji server running at " + this.kojiInstanceURL);
            sb.append("\nKoji: " + result);
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private XmlRpcClient connect(String kojiInstanceURL) throws MalformedURLException {
        XmlRpcClient koji = new XmlRpcClient();
        koji.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(koji));
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        koji.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(koji));
        koji.setTypeFactory((TypeFactory)new MyTypeFactory((XmlRpcController)koji));
        config.setEnabledForExtensions(true);
        config.setEnabledForExceptions(true);
        config.setServerURL(new URL(kojiInstanceURL));
        koji.setConfig((XmlRpcClientConfig)config);
        return koji;
    }

    public void setServerURL(String kojiInstanceURL) {
        XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
        config.setEnabledForExtensions(true);
        config.setEnabledForExceptions(true);
        try {
            config.setServerURL(new URL(kojiInstanceURL));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        this.koji.setConfig((XmlRpcClientConfig)config);
    }

    private void initSSL() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        try {
            sc.init(null, trustAllCerts, new SecureRandom());
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
        SSLContext.setDefault(sc);
    }

    public void setDebug(boolean debug) {
        if (debug) {
            this.koji.setTransportFactory((XmlRpcTransportFactory)new MyXmlRpcCommonsTransportFactory(this.koji));
        } else {
            this.koji.setTransportFactory((XmlRpcTransportFactory)new XmlRpcCommonsTransportFactory(this.koji));
        }
    }

    static class BuildParamsBuilder {
        private String id = null;
        private String tag = null;
        private boolean latest = false;
        private String pkg = null;
        private String owner = null;
        private String type = null;

        BuildParamsBuilder() {
        }

        BuildParamsBuilder setId(String id) {
            this.id = id;
            return this;
        }

        BuildParamsBuilder setTag(String tag) {
            this.tag = tag;
            return this;
        }

        BuildParamsBuilder setLatest(boolean latest) {
            this.latest = latest;
            return this;
        }

        BuildParamsBuilder setPackage(String pkg) {
            this.pkg = pkg;
            return this;
        }

        BuildParamsBuilder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        BuildParamsBuilder setType(String type) {
            this.type = type;
            return this;
        }

        BuildParams build() {
            return new BuildParams(this.id, this.tag, this.latest, this.pkg, this.owner, this.type);
        }
    }

    static class BuildParams {
        private final String id;
        private final String tag;
        private final boolean latest;
        private final String pkg;
        private final String owner;
        private final String type;

        BuildParams(String id, String tag, boolean latest, String pkg, String owner, String type) {
            this.id = id;
            this.tag = tag;
            this.latest = latest;
            this.pkg = pkg;
            this.owner = owner;
            this.type = type;
        }

        public String getId() {
            return this.id;
        }

        public String getTag() {
            return this.tag;
        }

        public boolean isLatest() {
            return this.latest;
        }

        public String getPkg() {
            return this.pkg;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getType() {
            return this.type;
        }
    }
}

