/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.koji;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KojiLauncher {
    private final String workspacePath;
    private String[] command;
    private final AbstractBuild<?, ?> build;
    private final BuildListener listener;
    private Launcher launcher;

    public KojiLauncher(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.build = build;
        this.listener = listener;
        this.launcher = launcher;
        this.workspacePath = this.initWorkspacePath();
    }

    private String initWorkspacePath() {
        String workspace = "";
        try {
            workspace = this.build.getWorkspace().absolutize().getRemote();
        }
        catch (IOException e) {
            this.listener.getLogger().println("[Koji integration] Error executing Koji command.");
            this.listener.getLogger().println(e.getMessage());
            return null;
        }
        catch (InterruptedException e) {
            this.listener.getLogger().println("[Koji integration] Error executing Koji command.");
            this.listener.getLogger().println(e.getMessage());
            return null;
        }
        return workspace;
    }

    KojiLauncher moshiMoshiCommand() {
        this.command = new String[]{"koji", "moshimoshi"};
        return this;
    }

    KojiLauncher mavenBuildCommand(String options, String target, String sources) {
        String[] tmpCommand = new String[]{"koji", "maven-build", "-Dmaven.test.skip=true", target, sources};
        this.command = options.equals("") ? tmpCommand : KojiLauncher.concatenate(tmpCommand, new String[]{options});
        return this;
    }

    KojiLauncher watchTaskCommand(String taskId) {
        this.command = new String[]{"koji", "watch-task", taskId};
        return this;
    }

    KojiLauncher downloadCommand(String kojiBuild) {
        this.command = new String[]{"koji", "download-build", "--type=maven", kojiBuild};
        return this;
    }

    public boolean callKoji() {
        boolean successfull = true;
        boolean bl = successfull = this.workspacePath != null;
        if (!successfull) {
            return successfull;
        }
        try {
            int exitCode = this.launcher.launch().cmds(this.command).envs((Map)this.build.getEnvironment((TaskListener)this.listener)).pwd(this.build.getWorkspace()).stdout((TaskListener)this.listener).join();
            successfull = exitCode == 0;
        }
        catch (IOException e) {
            this.listener.getLogger().println("[Koji integration] Error executing Koji command.");
            this.listener.getLogger().println(e.getMessage());
            return false;
        }
        catch (InterruptedException e) {
            this.listener.getLogger().println("[Koji integration] Error executing Koji command.");
            this.listener.getLogger().println(e.getMessage());
            return false;
        }
        return successfull;
    }

    public static String[] concatenate(String[] A, String[] B) {
        int aLength = A.length;
        int bLength = B.length;
        String[] C = new String[aLength + bLength];
        System.arraycopy(A, 0, C, 0, aLength);
        System.arraycopy(B, 0, C, aLength, bLength);
        return C;
    }
}

