/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.koji;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.xmlrpc.XmlRpcException;
import org.jenkinsci.plugins.koji.KojiLauncher;
import org.jenkinsci.plugins.koji.xmlrpc.KojiClient;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class KojiBuilder
extends Builder {
    private final String kojiBuild;
    private final String kojiTarget;
    private final String kojiPackage;
    private final String kojiOptions;
    private final String kojiTask;
    private boolean kojiScratchBuild;
    private final String kojiScmUrl;
    private transient BuildListener listener;
    private transient KojiClient koji;

    @DataBoundConstructor
    public KojiBuilder(String kojiBuild, String kojiTarget, String kojiPackage, String kojiOptions, String kojiTask, boolean kojiScratchBuild, String kojiScmUrl) {
        this.kojiBuild = kojiBuild;
        this.kojiTarget = kojiTarget;
        this.kojiPackage = kojiPackage;
        this.kojiOptions = kojiOptions;
        this.kojiTask = kojiTask;
        this.kojiScmUrl = kojiScmUrl;
        this.kojiScratchBuild = kojiScratchBuild;
    }

    public String getKojiBuild() {
        return this.kojiBuild;
    }

    public String getKojiTarget() {
        return this.kojiTarget;
    }

    public String getKojiPackage() {
        return this.kojiPackage;
    }

    public String getKojiOptions() {
        return this.kojiOptions;
    }

    public String getKojiTask() {
        return this.kojiTask;
    }

    public boolean isKojiScratchBuild() {
        return this.kojiScratchBuild;
    }

    public void setKojiScratchBuild(boolean kojiScratchBuild) {
        this.kojiScratchBuild = kojiScratchBuild;
    }

    public String getKojiScmUrl() {
        return this.kojiScmUrl;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        try {
            this.init(listener);
        }
        catch (XmlRpcException e) {
            listener.getLogger().println("\n[Koji integration] " + e.getMessage());
        }
        boolean kojiRunSucceeded = false;
        KojiLauncher kojiLauncher = new KojiLauncher(build, launcher, listener);
        if (this.kojiTask.equals(KojiTask.mavenBuild.name())) {
            listener.getLogger().println("\n[Koji integration] Running maven build build for package " + this.kojiPackage + " in tag " + this.kojiTarget);
            kojiRunSucceeded = kojiLauncher.mavenBuildCommand(this.isScratchToString(), this.kojiTarget, this.kojiScmUrl).callKoji();
        } else if (this.kojiTask.equals(KojiTask.download.name())) {
            listener.getLogger().println("\n[Koji integration] Downloading artifacts for build " + this.kojiBuild);
            kojiRunSucceeded = kojiLauncher.downloadCommand(this.kojiBuild).callKoji();
        } else if (this.kojiTask.equals(KojiTask.listLatest.name())) {
            listener.getLogger().println("\n[Koji integration] Listing latest build information for package " + this.kojiPackage + " in tag " + this.kojiTarget);
            kojiRunSucceeded = this.getLatestBuilds(this.kojiPackage, this.kojiTarget);
        } else if (this.kojiTask.equals(KojiTask.moshimoshi.name())) {
            kojiLauncher.moshiMoshiCommand().callKoji();
            kojiRunSucceeded = true;
        }
        return kojiRunSucceeded;
    }

    private String isScratchToString() {
        if (this.kojiScratchBuild) {
            return "--scratch";
        }
        return "";
    }

    private boolean getLatestBuilds(String pkg, String tag) {
        Map<String, String> result = null;
        this.listener.getLogger().println("\n[Koji integration] Searching latest build for package " + pkg + " in tag " + tag);
        try {
            result = this.koji.getLatestBuilds(tag, pkg);
        }
        catch (XmlRpcException e) {
            if (e.getMessage() == "empty") {
                this.listener.getLogger().println("[Koji integration] No package " + pkg + " found for tag " + tag);
                return false;
            }
            this.listener.getLogger().println("[Koji integration] Error executing Koji command.");
            this.listener.getLogger().println(e.getMessage());
            return false;
        }
        for (Map.Entry<String, String> entry : result.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.listener.getLogger().println(key + ": " + value);
        }
        return true;
    }

    private void getBuildInfo(String build) {
        Map<String, String> buildInfo = null;
        this.listener.getLogger().println("\n[Koji integration] Searching for build information for " + build);
        try {
            buildInfo = this.koji.getBuildInfo(build);
        }
        catch (XmlRpcException e) {
            if (e.getMessage() == "empty") {
                this.listener.getLogger().println("[Koji integration] No build with id=" + build + " found in the database.");
                return;
            }
            this.listener.getLogger().println("[Koji integration] Error executing Koji command.");
            this.listener.getLogger().println(e.getMessage());
        }
        for (Map.Entry<String, String> entry : buildInfo.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.listener.getLogger().println(key + ": " + value);
        }
    }

    private void init(BuildListener listener) throws XmlRpcException {
        this.listener = listener;
        try {
            this.koji = KojiClient.getKojiClient(this.getDescriptor().getKojiInstanceURL());
        }
        catch (MalformedURLException e) {
            listener.getLogger().println("[Koji integration] Error executing Koji command.");
            listener.getLogger().println(e.getMessage());
        }
        if (this.getDescriptor().getAuthentication().equals(Authentication.plain.name())) {
            this.koji.login(this.getDescriptor().getKojiUsername(), this.getDescriptor().getKojiPassword());
        }
    }

    private void printDebugInfo() {
        this.listener.getLogger().println("This is the selected Koji Instance: " + this.getDescriptor().getKojiInstanceURL());
        this.listener.getLogger().println("This is the selected Koji Build: " + this.kojiBuild);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum KojiTask {
        mavenBuild,
        download,
        listLatest,
        moshimoshi;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Authentication {
        plain,
        openSSL,
        kerberos;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String kojiInstanceURL;
        private String authentication;
        private String kojiUsername;
        private String kojiPassword;
        private String sslCertificatePath;

        public DescriptorImpl() {
            super(KojiBuilder.class);
            this.load();
        }

        public FormValidation doCheckKojiInstanceURL(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set a Koji instance URL");
            }
            if (value.length() < 4) {
                return FormValidation.warning((String)"Isn't the Koji instance URL too short?");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public ListBoxModel doFillAuthenticationItems() {
            ListBoxModel authModel = new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("Username / Password", Authentication.plain.name()), new ListBoxModel.Option("OpenSSL", Authentication.openSSL.name()), new ListBoxModel.Option("Kerberos (TBD)", Authentication.kerberos.name())});
            if (this.authentication == null) {
                ((ListBoxModel.Option)authModel.get((int)0)).selected = true;
                return authModel;
            }
            for (ListBoxModel.Option option : authModel) {
                if (option.value.equals(Authentication.plain.name())) {
                    option.selected = this.authentication.equals(Authentication.plain.name());
                    continue;
                }
                if (option.value.equals(Authentication.openSSL.name())) {
                    option.selected = this.authentication.equals(Authentication.openSSL.name());
                    continue;
                }
                if (!option.value.equals(Authentication.kerberos.name())) continue;
                option.selected = this.authentication.equals(Authentication.kerberos.name());
            }
            return authModel;
        }

        public ListBoxModel doFillKojiTaskItems() {
            ListBoxModel kojiTaskModel = new ListBoxModel(new ListBoxModel.Option[]{new ListBoxModel.Option("Koji moshimoshi (validate client configuration)", KojiTask.moshimoshi.name()), new ListBoxModel.Option("Run a new maven build", KojiTask.mavenBuild.name()), new ListBoxModel.Option("Download maven build", KojiTask.download.name()), new ListBoxModel.Option("List latest build for package", KojiTask.listLatest.name())});
            return kojiTaskModel;
        }

        public static DescriptorImpl get() {
            return (DescriptorImpl)((Object)Builder.all().get(DescriptorImpl.class));
        }

        public String getDisplayName() {
            return "Koji integration";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.kojiInstanceURL = formData.getString("kojiInstanceURL");
            this.authentication = formData.getString("authentication");
            this.kojiUsername = formData.getString("kojiUsername");
            this.kojiPassword = formData.getString("kojiPassword");
            this.sslCertificatePath = formData.getString("sslCertificatePath");
            this.save();
            return super.configure(req, formData);
        }

        public String getKojiInstanceURL() {
            return this.kojiInstanceURL;
        }

        public void setKojiInstanceURL(String kojiInstanceURL) {
            this.kojiInstanceURL = kojiInstanceURL;
        }

        public String getAuthentication() {
            return this.authentication;
        }

        public void setAuthentication(String authentication) {
            this.authentication = authentication;
        }

        public String getKojiUsername() {
            return this.kojiUsername;
        }

        public void setKojiUsername(String kojiUsername) {
            this.kojiUsername = kojiUsername;
        }

        public String getKojiPassword() {
            return this.kojiPassword;
        }

        public void setKojiPassword(String kojiPassword) {
            this.kojiPassword = kojiPassword;
        }

        public String getSslCertificatePath() {
            return this.sslCertificatePath;
        }

        public void setSslCertificatePath(String sslCertificatePath) {
            this.sslCertificatePath = sslCertificatePath;
        }
    }
}

