/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.util;

import com.klocwork.kwjenkinsplugin.definitions.KlocworkSeverities;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkStatuses;
import com.klocwork.kwjenkinsplugin.util.KlocworkXMLReportHandler;
import hudson.AbortException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.file.Paths;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jenkins.security.MasterToSlaveCallable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KlocworkXMLReportParser
extends MasterToSlaveCallable<Integer, IOException>
implements Serializable {
    private final String workspace;
    private final String xmlReport;
    private final KlocworkSeverities enabledSeverites;
    private final KlocworkStatuses enabledStatuses;

    public KlocworkXMLReportParser(String workspace, String xmlReport, KlocworkSeverities enabledSeverites, KlocworkStatuses enabledStatuses) {
        this.workspace = workspace;
        this.xmlReport = xmlReport;
        this.enabledSeverites = enabledSeverites;
        this.enabledStatuses = enabledStatuses;
    }

    public Integer call() throws IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            FileInputStream xmlInput = null;
            xmlInput = Paths.get(this.xmlReport, new String[0]).isAbsolute() ? new FileInputStream(new File(this.xmlReport)) : new FileInputStream(new File(this.workspace, this.xmlReport));
            InputSource inputSource = new InputSource(new InputStreamReader((InputStream)xmlInput, "UTF-8"));
            inputSource.setEncoding("UTF-8");
            SAXParser saxParser = factory.newSAXParser();
            KlocworkXMLReportHandler handler = new KlocworkXMLReportHandler(false, this.enabledSeverites, this.enabledStatuses);
            saxParser.parse(inputSource, (DefaultHandler)handler);
            return handler.getTotalIssueCount();
        }
        catch (ParserConfigurationException | SAXException ex) {
            throw new AbortException(ex.getMessage());
        }
    }
}

