/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.pipeline;

import com.google.inject.Inject;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkXSyncBuilder;
import com.klocwork.kwjenkinsplugin.config.KlocworkXSyncConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class KlocworkXSyncStep
extends AbstractStepImpl {
    private KlocworkXSyncConfig syncConfig;

    @DataBoundConstructor
    public KlocworkXSyncStep(KlocworkXSyncConfig syncConfig) {
        this.syncConfig = syncConfig;
    }

    public KlocworkXSyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(KlocworkXSyncStepExecution.class);
        }

        public String getFunctionName() {
            return "klocworkIssueSync";
        }

        @Nonnull
        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_XSYNC_DISPLAY_NAME;
        }
    }

    private static class KlocworkXSyncStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient KlocworkXSyncStep step;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        private KlocworkXSyncStepExecution() {
        }

        protected Void run() throws Exception {
            KlocworkXSyncBuilder builder = new KlocworkXSyncBuilder(this.step.getSyncConfig());
            builder.perform(this.build, this.env, this.workspace, this.launcher, this.listener);
            return null;
        }
    }
}

