/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.pipeline;

import com.google.inject.Inject;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkServerLoadBuilder;
import com.klocwork.kwjenkinsplugin.config.KlocworkReportConfig;
import com.klocwork.kwjenkinsplugin.config.KlocworkServerLoadConfig;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KlocworkServerLoadStep
extends AbstractStepImpl {
    private KlocworkServerLoadConfig serverConfig;
    private KlocworkReportConfig reportConfig;

    @DataBoundConstructor
    public KlocworkServerLoadStep(KlocworkServerLoadConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    @DataBoundSetter
    public void setReportConfig(KlocworkReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    public KlocworkServerLoadConfig getServerConfig() {
        return this.serverConfig;
    }

    public KlocworkReportConfig getReportConfig() {
        return this.reportConfig;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(KlocworkServerLoadStepExecution.class);
        }

        public String getFunctionName() {
            return "klocworkIntegrationStep2";
        }

        @Nonnull
        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_SERVER_LOAD_DISPLAY_NAME;
        }
    }

    private static class KlocworkServerLoadStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient KlocworkServerLoadStep step;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        private KlocworkServerLoadStepExecution() {
        }

        protected Void run() throws Exception {
            if (this.step.getServerConfig() == null) {
                throw new AbortException("Klocwork server configuration is null. Please update klocworkIntegrationStep2 pipeline step. This is due to an update to include a Klocwork trend chart. Sorry for any inconvenience caused! Enjoy the chart :)");
            }
            KlocworkServerLoadBuilder builder = this.step.getReportConfig() == null ? new KlocworkServerLoadBuilder(this.step.getServerConfig()) : new KlocworkServerLoadBuilder(this.step.getServerConfig(), this.step.getReportConfig());
            builder.perform(this.build, this.env, this.workspace, this.launcher, this.listener);
            return null;
        }
    }
}

