/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.pipeline;

import com.google.inject.Inject;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkServerAnalysisBuilder;
import com.klocwork.kwjenkinsplugin.config.KlocworkServerAnalysisConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class KlocworkServerAnalysisStep
extends AbstractStepImpl {
    private KlocworkServerAnalysisConfig serverConfig;

    @DataBoundConstructor
    public KlocworkServerAnalysisStep(KlocworkServerAnalysisConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public KlocworkServerAnalysisConfig getServerConfig() {
        return this.serverConfig;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(KlocworkServerAnalysisStepExecution.class);
        }

        public String getFunctionName() {
            return "klocworkIntegrationStep1";
        }

        @Nonnull
        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_SERVER_ANALYSIS_DISPLAY_NAME;
        }
    }

    private static class KlocworkServerAnalysisStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient KlocworkServerAnalysisStep step;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        private KlocworkServerAnalysisStepExecution() {
        }

        protected Void run() throws Exception {
            KlocworkServerAnalysisBuilder builder = new KlocworkServerAnalysisBuilder(this.step.getServerConfig());
            builder.perform(this.build, this.env, this.workspace, this.launcher, this.listener);
            return null;
        }
    }
}

