/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.pipeline;

import com.google.inject.Inject;
import com.klocwork.kwjenkinsplugin.KlocworkCiBuilder;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.config.KlocworkCiConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Items;
import hudson.model.Run;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class KlocworkCiStep
extends AbstractStepImpl {
    private transient KlocworkCiConfig desktopConfig;
    private KlocworkCiConfig ciConfig;

    protected Object readResolve() {
        if (this.desktopConfig != null) {
            this.ciConfig = this.desktopConfig;
        }
        return this;
    }

    @DataBoundConstructor
    public KlocworkCiStep(KlocworkCiConfig ciConfig) {
        this.ciConfig = ciConfig;
    }

    public KlocworkCiConfig getCiConfig() {
        return this.ciConfig;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(KlocworkCiStepExecution.class);
        }

        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("com.klocwork.kwjenkinsplugin.pipeline.KlocworkDesktopStep", KlocworkCiStep.class);
            Run.XSTREAM2.addCompatibilityAlias("com.klocwork.kwjenkinsplugin.pipeline.KlocworkDesktopStep", KlocworkCiStep.class);
        }

        public String getFunctionName() {
            return "klocworkIncremental";
        }

        @Nonnull
        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_CI_BUILDER_DISPLAY_NAME;
        }
    }

    private static class KlocworkCiStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient KlocworkCiStep step;
        @StepContextParameter
        private transient Run build;
        @StepContextParameter
        private transient FilePath workspace;
        @StepContextParameter
        private transient Launcher launcher;
        @StepContextParameter
        private transient TaskListener listener;
        @StepContextParameter
        private transient EnvVars env;

        private KlocworkCiStepExecution() {
        }

        protected Void run() throws Exception {
            KlocworkCiBuilder builder = new KlocworkCiBuilder(this.step.getCiConfig());
            builder.perform(this.build, this.env, this.workspace, this.launcher, this.listener);
            return null;
        }
    }
}

