/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.dto;

import com.klocwork.kwjenkinsplugin.dto.HtmlIssueDataTrace;
import com.klocwork.kwjenkinsplugin.dto.HtmlIssueDataTraceLine;
import com.klocwork.kwjenkinsplugin.dto.JsonIssueTraceBlock;
import com.klocwork.kwjenkinsplugin.dto.JsonIssueTraceLine;
import com.klocwork.kwjenkinsplugin.dto.KlocworkJsonIssue;
import java.util.ArrayList;
import java.util.List;

public class HtmlDetailedIssueData {
    Integer id;
    String code;
    String file;
    String message;
    Boolean system;
    String status;
    String severity;
    String supportLevel;
    Integer severityCode;
    Integer supportLevelCode;
    String state;
    String method;
    Integer line;
    List<HtmlIssueDataTrace> trace = new ArrayList<HtmlIssueDataTrace>();

    public static HtmlDetailedIssueData fromJsonIssue(KlocworkJsonIssue jsonIssue) {
        HtmlDetailedIssueData result = new HtmlDetailedIssueData();
        result.id = jsonIssue.getId() == null ? null : Integer.valueOf(Integer.parseInt(jsonIssue.getId()));
        result.code = jsonIssue.getCode();
        result.file = jsonIssue.getFile();
        result.message = jsonIssue.getMessage();
        result.system = jsonIssue.getSystem();
        result.status = jsonIssue.getCitingStatus();
        result.severityCode = jsonIssue.getSeverityCode() != null ? Integer.parseInt(jsonIssue.getSeverityCode()) : 0;
        result.severity = jsonIssue.getSeverity();
        result.supportLevelCode = jsonIssue.getSupportLevelCode() != null ? Integer.parseInt(jsonIssue.getSupportLevelCode()) : 0;
        result.supportLevel = jsonIssue.getSupportLevel();
        result.state = jsonIssue.getState();
        result.method = jsonIssue.getParent();
        result.line = jsonIssue.getLine() == null ? null : Integer.valueOf(Integer.parseInt(jsonIssue.getLine()));
        ArrayList<HtmlIssueDataTrace> traceResult = new ArrayList<HtmlIssueDataTrace>();
        if (jsonIssue.getTrace() != null) {
            for (JsonIssueTraceBlock jsonTraceBlock : jsonIssue.getTrace().getTraceBlocks()) {
                HtmlIssueDataTrace resultTraceBlock = new HtmlIssueDataTrace();
                resultTraceBlock.file = jsonTraceBlock.getFile();
                resultTraceBlock.entity = jsonTraceBlock.getMethod();
                for (JsonIssueTraceLine jsonTraceLine : jsonTraceBlock.lines) {
                    HtmlIssueDataTraceLine resultTraceLine = new HtmlIssueDataTraceLine();
                    resultTraceLine.line = jsonTraceLine.getLine();
                    resultTraceLine.text = jsonTraceLine.getText();
                    resultTraceBlock.lines.add(resultTraceLine);
                }
                traceResult.add(resultTraceBlock);
            }
            result.trace = traceResult;
        }
        return result;
    }

    public Integer getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getFile() {
        return this.file;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean isSystem() {
        return this.system;
    }

    public String getStatus() {
        return this.status;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getSupportLevel() {
        return this.supportLevel;
    }

    public Integer getSeverityCode() {
        return this.severityCode;
    }

    public Integer getSupportLevelCode() {
        return this.supportLevelCode;
    }

    public String getState() {
        return this.state;
    }

    public String getMethod() {
        return this.method;
    }

    public Integer getLine() {
        return this.line;
    }

    public List<HtmlIssueDataTrace> getTrace() {
        return this.trace;
    }

    public String toString() {
        return "DetailedIssueData{system=" + this.system + ", status='" + this.status + '\'' + ", severity='" + this.severity + '\'' + ", severityCode=" + this.severityCode + ", supportLevel='" + this.supportLevel + '\'' + ", supportLevelCode=" + this.supportLevelCode + ", state='" + this.state + '\'' + ", code='" + this.code + '\'' + ", method='" + this.method + '\'' + ", line=" + this.line + ", trace=" + this.trace + '}';
    }
}

