/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.definitions;

import java.util.HashMap;
import java.util.Map;

public enum Status {
    ANALYZE(1, "Analyze"),
    IGNORE(2, "Ignore"),
    NOT_A_PROBLEM(3, "Not a Problem"),
    FIX(4, "Fix"),
    FIX_IN_NEXT_RELEASE(5, "Fix in Next Release"),
    FIX_IN_LATER_RELEASE(6, "Fix in Later Release"),
    DEFER(7, "Defer"),
    FILTER(8, "Filter");

    private static final Map<String, Status> NAME_VALUES;
    private static final Map<Integer, Status> ID_VALUES;
    private final int id;
    private final String name;

    private Status(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public static Status getValue(String value) {
        if (value == null) {
            return null;
        }
        Status result = NAME_VALUES.get(value);
        if (result == null) {
            throw new IllegalArgumentException("There is no status for value " + value);
        }
        return result;
    }

    public static Status getValue(int value) {
        Status result = ID_VALUES.get(value);
        if (result == null) {
            throw new IllegalArgumentException("There is no status for id " + value);
        }
        return result;
    }

    static {
        NAME_VALUES = new HashMap<String, Status>();
        for (Status status : Status.values()) {
            NAME_VALUES.put(status.name, status);
        }
        ID_VALUES = new HashMap<Integer, Status>();
        for (Status status : Status.values()) {
            ID_VALUES.put(status.id, status);
        }
    }
}

