/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ArgumentListBuilder;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KlocworkServerLoadConfig
extends AbstractDescribableImpl<KlocworkServerLoadConfig> {
    private String tablesDir;
    private String buildName;
    private String additionalOpts;

    @DataBoundConstructor
    public KlocworkServerLoadConfig(String tablesDir, String buildName, String additionalOpts) {
        this.tablesDir = tablesDir;
        this.buildName = buildName;
        this.additionalOpts = additionalOpts;
    }

    public ArgumentListBuilder getVersionCmd() {
        ArgumentListBuilder versionCmd = new ArgumentListBuilder(new String[]{"kwadmin"});
        versionCmd.add("--version");
        return versionCmd;
    }

    public ArgumentListBuilder getKwadminLoadCmd(EnvVars envVars, FilePath workspace) {
        ArgumentListBuilder kwadminCmd = new ArgumentListBuilder(new String[]{"kwadmin"});
        kwadminCmd.add(new String[]{"--url", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL)});
        kwadminCmd.add("load");
        kwadminCmd.add(new String[]{"--name", KlocworkUtil.getDefaultBuildName(this.buildName, envVars)});
        kwadminCmd.add((String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT));
        kwadminCmd.add(envVars.expand(KlocworkUtil.getDefaultKwtablesDir(this.tablesDir)));
        if (!StringUtils.isEmpty((CharSequence)this.additionalOpts)) {
            kwadminCmd.addTokenized(envVars.expand(this.additionalOpts));
        }
        return kwadminCmd;
    }

    @DataBoundSetter
    public void setTablesDir(String tablesDir) {
        this.tablesDir = tablesDir;
    }

    @DataBoundSetter
    public void setBuildName(String buildName) {
        this.buildName = buildName;
    }

    @DataBoundSetter
    public void setAdditionalOpts(String additionalOpts) {
        this.additionalOpts = additionalOpts;
    }

    public String getTablesDir() {
        return this.tablesDir;
    }

    public String getBuildName() {
        return this.buildName;
    }

    public String getAdditionalOpts() {
        return this.additionalOpts;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkServerLoadConfig> {
        public String getDisplayName() {
            return null;
        }
    }
}

