/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import com.klocwork.kwjenkinsplugin.config.Messages;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KlocworkServerConfig
extends AbstractDescribableImpl<KlocworkServerConfig> {
    private final String name;
    private final String url;
    private final boolean specificLicense;
    private final String licenseHost;
    private final String licensePort;

    @DataBoundConstructor
    public KlocworkServerConfig(String name, String url, boolean specificLicense, String licenseHost, String licensePort) {
        this.name = name;
        this.url = url;
        this.specificLicense = specificLicense;
        this.licenseHost = licenseHost;
        this.licensePort = licensePort;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSpecificLicense() {
        return this.specificLicense;
    }

    public String getLicenseHost() {
        return this.licenseHost;
    }

    public String getLicensePort() {
        return this.licensePort;
    }

    @Symbol(value={"serverConfigs"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkServerConfig> {
        public String getDisplayName() {
            return null;
        }

        public FormValidation doCheckUrl(@QueryParameter String value) throws IOException, ServletException {
            try {
                URL klocworkUrl = new URL(value);
                if (klocworkUrl.getPort() == -1) {
                    return FormValidation.error((String)Messages.KlocworkServerConfig_port_needed());
                }
                if (!klocworkUrl.getProtocol().equals("http") && !klocworkUrl.getProtocol().equals("https")) {
                    return FormValidation.error((String)Messages.KlocworkServerConfig_http_protocol_needed());
                }
            }
            catch (MalformedURLException ex) {
                return FormValidation.error((String)Messages.KlocworkServerConfig_invalid_url_format());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckLicensePort(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isNumeric((CharSequence)value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.KlocworkServerConfig_port_must_be_a_number());
        }
    }
}

