/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.ArgumentListBuilder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class KlocworkServerAnalysisConfig
extends AbstractDescribableImpl<KlocworkServerAnalysisConfig> {
    private final String buildSpec;
    private final String tablesDir;
    private final boolean incrementalAnalysis;
    private final boolean ignoreCompileErrors;
    private final String importConfig;
    private final String additionalOpts;
    private final boolean disableKwdeploy;
    private boolean enabledCreateProject;
    private String duplicateFrom;

    @DataBoundSetter
    public void setDuplicateFrom(String duplicateFrom) {
        this.duplicateFrom = duplicateFrom;
    }

    public String getDuplicateFrom() {
        return this.duplicateFrom;
    }

    @DataBoundConstructor
    public KlocworkServerAnalysisConfig(String buildSpec, String tablesDir, boolean incrementalAnalysis, boolean ignoreCompileErrors, String importConfig, String additionalOpts, boolean disableKwdeploy) {
        this.buildSpec = buildSpec;
        this.tablesDir = tablesDir;
        this.incrementalAnalysis = incrementalAnalysis;
        this.ignoreCompileErrors = ignoreCompileErrors;
        this.importConfig = importConfig;
        this.additionalOpts = additionalOpts;
        this.disableKwdeploy = disableKwdeploy;
    }

    @DataBoundSetter
    public void setEnabledCreateProject(boolean enabledCreateProject) {
        this.enabledCreateProject = enabledCreateProject;
    }

    public ArgumentListBuilder getVersionCmd() {
        ArgumentListBuilder versionCmd = new ArgumentListBuilder(new String[]{"kwbuildproject"});
        versionCmd.add("--version");
        return versionCmd;
    }

    public ArgumentListBuilder getKwdeployCmd(EnvVars envVars, FilePath workspace) {
        ArgumentListBuilder kwdeployCmd = new ArgumentListBuilder(new String[]{"kwdeploy"});
        kwdeployCmd.add("sync");
        kwdeployCmd.add(new String[]{"--url", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL)});
        return kwdeployCmd;
    }

    public List<ArgumentListBuilder> getKwadminImportConfigCmds(EnvVars envVars) {
        ArrayList<ArgumentListBuilder> kwadminCmds = new ArrayList<ArgumentListBuilder>();
        for (String configFile : this.importConfig.split(",")) {
            ArgumentListBuilder kwadminCmd = new ArgumentListBuilder(new String[]{"kwadmin"});
            kwadminCmd.add(new String[]{"--url", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL)});
            kwadminCmd.add("import-config");
            kwadminCmd.add((String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT));
            kwadminCmd.add(envVars.expand(configFile));
            kwadminCmds.add(kwadminCmd);
        }
        return kwadminCmds;
    }

    public ArgumentListBuilder getKwbuildprojectCmd(EnvVars envVars) throws AbortException {
        ArgumentListBuilder kwbuildprojectCmd = new ArgumentListBuilder(new String[]{"kwbuildproject"});
        kwbuildprojectCmd.add(new String[]{"--tables-directory", envVars.expand(KlocworkUtil.getDefaultKwtablesDir(this.tablesDir))});
        kwbuildprojectCmd.add("--url");
        kwbuildprojectCmd.add(KlocworkUtil.getKlocworkProjectUrl(envVars));
        if (!StringUtils.isEmpty((CharSequence)((CharSequence)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_HOST)))) {
            kwbuildprojectCmd.add(new String[]{"--license-host", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_HOST)});
            if (!StringUtils.isEmpty((CharSequence)((CharSequence)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_PORT)))) {
                kwbuildprojectCmd.add(new String[]{"--license-port", (String)envVars.get((Object)KlocworkConstants.KLOCWORK_LICENSE_PORT)});
            }
        }
        if (this.incrementalAnalysis) {
            kwbuildprojectCmd.add("--incremental");
        } else {
            kwbuildprojectCmd.add("--force");
        }
        if (!StringUtils.isEmpty((CharSequence)this.additionalOpts)) {
            kwbuildprojectCmd.addTokenized(envVars.expand(this.additionalOpts));
        }
        kwbuildprojectCmd.add(envVars.expand(KlocworkUtil.getDefaultBuildSpec(this.buildSpec)));
        return kwbuildprojectCmd;
    }

    public boolean hasImportConfig() {
        return !StringUtils.isEmpty((CharSequence)this.importConfig);
    }

    public String getBuildSpec() {
        return this.buildSpec;
    }

    public String getTablesDir() {
        return this.tablesDir;
    }

    public boolean getIncrementalAnalysis() {
        return this.incrementalAnalysis;
    }

    public boolean getIgnoreCompileErrors() {
        return this.ignoreCompileErrors;
    }

    public String getImportConfig() {
        return this.importConfig;
    }

    public String getAdditionalOpts() {
        return this.additionalOpts;
    }

    public boolean getDisableKwdeploy() {
        return this.disableKwdeploy;
    }

    public boolean isEnabledCreateProject() {
        return this.enabledCreateProject;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkServerAnalysisConfig> {
        public String getDisplayName() {
            return null;
        }
    }
}

