/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin.config;

import com.klocwork.kwjenkinsplugin.config.Messages;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KlocworkDifferentialAnalysisConfig
extends AbstractDescribableImpl<KlocworkDifferentialAnalysisConfig> {
    private final String diffType;
    private final String gitPreviousCommit;
    private final String diffFileList;

    @DataBoundConstructor
    public KlocworkDifferentialAnalysisConfig(String diffType, String gitPreviousCommit, String diffFileList) {
        this.diffType = diffType;
        this.gitPreviousCommit = gitPreviousCommit;
        this.diffFileList = diffFileList;
    }

    public boolean isGitDiffType() {
        return this.diffType.equals("git");
    }

    public boolean isManualDiffType() {
        return this.diffType.equals("manual");
    }

    public String getDiffType() {
        return this.diffType;
    }

    public String getGitPreviousCommit() {
        return this.gitPreviousCommit;
    }

    public String getDiffFileList() {
        if (StringUtils.isEmpty((CharSequence)this.diffFileList)) {
            return "diff_file_list.txt";
        }
        return this.diffFileList;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<KlocworkDifferentialAnalysisConfig> {
        public String getDisplayName() {
            return null;
        }

        public FormValidation doCheckDiffFileList(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.ok((String)(Messages.KlocworkDifferentialAnalysisConfig_default_value() + "diff_file_list.txt"));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGitPreviousCommit(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.error((String)Messages.KlocworkDifferentialAnalysisConfig_previous_commit_mandatory());
            }
            return FormValidation.ok();
        }
    }
}

