/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkBuildAction;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkLogger;
import com.klocwork.kwjenkinsplugin.config.KlocworkReportConfig;
import com.klocwork.kwjenkinsplugin.config.KlocworkServerLoadConfig;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.HashMap;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

public class KlocworkServerLoadBuilder
extends Builder
implements SimpleBuildStep {
    private KlocworkServerLoadConfig serverConfig;
    private KlocworkReportConfig reportConfig;

    protected Object readResolve() {
        if (this.reportConfig == null) {
            this.reportConfig = new KlocworkReportConfig(false);
        }
        return this;
    }

    @DataBoundConstructor
    public KlocworkServerLoadBuilder(KlocworkServerLoadConfig serverConfig) {
        this.serverConfig = serverConfig;
        this.reportConfig = new KlocworkReportConfig(false);
    }

    public KlocworkServerLoadBuilder(KlocworkServerLoadConfig serverConfig, KlocworkReportConfig reportConfig) {
        this.serverConfig = serverConfig;
        this.reportConfig = reportConfig;
    }

    @DataBoundSetter
    public void setReportConfig(KlocworkReportConfig reportConfig) {
        this.reportConfig = reportConfig;
    }

    @DataBoundSetter
    public void setServerConfig(KlocworkServerLoadConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public KlocworkServerLoadConfig getServerConfig() {
        return this.serverConfig;
    }

    public KlocworkReportConfig getReportConfig() {
        return this.reportConfig;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
        this.perform(build, envVars, workspace, launcher, listener);
    }

    public void perform(Run<?, ?> build, EnvVars envVars, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        KlocworkLogger logger = new KlocworkLogger("KlocworkServerLoadConfig", listener.getLogger());
        logger.logMessage("Starting Klocwork Server Analysis Load Step");
        KlocworkUtil.validateServerConfigs(envVars);
        KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.serverConfig.getVersionCmd(), true);
        KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.serverConfig.getKwadminLoadCmd(envVars, workspace));
        if (this.reportConfig != null && this.reportConfig.isDisplayChart()) {
            this.createBuildAction(logger, build, envVars, launcher);
        }
    }

    private void createBuildAction(KlocworkLogger logger, Run<?, ?> build, EnvVars envVars, Launcher launcher) throws AbortException {
        String request = KlocworkUtil.createKlocworkAPIRequestOld("search", this.reportConfig.getQuery(), envVars);
        logger.logMessage("Using query: " + request);
        JSONArray response = KlocworkUtil.getJSONResponse(request, envVars, launcher);
        logger.logMessage("Number of issues returned : " + Integer.toString(response.size()));
        HashMap<String, Integer> severityMap = new HashMap<String, Integer>();
        for (int i = 0; i < response.size(); ++i) {
            String severity = response.getJSONObject(i).getString("severityCode");
            if (StringUtils.isEmpty((CharSequence)severity) || StringUtils.isEmpty((CharSequence)this.getSeverity_en(severity))) {
                logger.logMessage(String.format("WARNING: found empty severity %s", severity));
                continue;
            }
            severityMap.put(this.getSeverity_en(severity), severityMap.getOrDefault(this.getSeverity_en(severity), 0) + 1);
        }
        request = KlocworkUtil.createKlocworkAPIRequest("projects", new HashMap<String, String>());
        logger.logMessage("Using query: " + request);
        response = KlocworkUtil.getJSONResponse(request, envVars, launcher);
        String projectId = "";
        for (int i = 0; i < response.size(); ++i) {
            String projectName = response.getJSONObject(i).getString("name");
            if (StringUtils.isEmpty((CharSequence)projectName) || !projectName.equals(envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT))) continue;
            projectId = response.getJSONObject(i).getString("id");
            break;
        }
        build.addAction((Action)new KlocworkBuildAction(build, severityMap, envVars, this.serverConfig.getBuildName(), this.reportConfig, projectId));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    private String getSeverity_en(String severityCode) {
        String severity_en = "";
        int severityLevel = 0;
        try {
            severityLevel = Integer.parseInt(severityCode);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        switch (severityLevel) {
            case 1: {
                severity_en = KlocworkConstants.KLOCWORK_ISSUE_CRITICAL;
                break;
            }
            case 2: {
                severity_en = KlocworkConstants.KLOCWORK_ISSUE_ERROR;
                break;
            }
            case 3: {
                severity_en = KlocworkConstants.KLOCWORK_ISSUE_WARNING;
                break;
            }
            case 4: {
                severity_en = KlocworkConstants.KLOCWORK_ISSUE_REVIEW;
            }
        }
        return severity_en;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_SERVER_LOAD_DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

