/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkLogger;
import com.klocwork.kwjenkinsplugin.config.KlocworkServerAnalysisConfig;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KlocworkServerAnalysisBuilder
extends Builder
implements SimpleBuildStep {
    private final KlocworkServerAnalysisConfig serverConfig;

    @DataBoundConstructor
    public KlocworkServerAnalysisBuilder(KlocworkServerAnalysisConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public KlocworkServerAnalysisConfig getServerConfig() {
        return this.serverConfig;
    }

    public void perform(Run<?, ?> build, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws AbortException {
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
        this.perform(build, envVars, workspace, launcher, listener);
    }

    public void perform(Run<?, ?> build, EnvVars envVars, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        int rc_kwbuild;
        KlocworkLogger logger = new KlocworkLogger("ServerAnalysisBuilder", listener.getLogger());
        logger.logMessage("Starting Klocwork Server Analysis Build Step");
        KlocworkUtil.validateServerConfigs(envVars);
        KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.serverConfig.getVersionCmd());
        if (this.serverConfig.isEnabledCreateProject()) {
            logger.logMessage("Checking if project: " + (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT) + " exists");
            Map<KlocworkUtil.StreamReferences, ByteArrayOutputStream> kwadminProjectListOutputs = KlocworkUtil.executeCommandParseOutput(launcher, workspace, envVars, KlocworkUtil.getProjectListCmd((String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL), workspace));
            ByteArrayOutputStream kwadminProjectListOutput = (ByteArrayOutputStream)kwadminProjectListOutputs.get((Object)KlocworkUtil.StreamReferences.OUT_STREAM);
            if (kwadminProjectListOutput != null) {
                if (KlocworkUtil.projectExists(kwadminProjectListOutput, launcher, (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT))) {
                    logger.logMessage("\tproject exists, continuing");
                } else {
                    logger.logMessage("\tproject does not exist");
                    KlocworkUtil.executeCommandParseOutput(launcher, workspace, envVars, KlocworkUtil.getCreateOrDuplicateCmd((String)envVars.get((Object)KlocworkConstants.KLOCWORK_URL), (String)envVars.get((Object)KlocworkConstants.KLOCWORK_PROJECT), this.serverConfig.getDuplicateFrom(), workspace));
                }
            }
        }
        if (!this.serverConfig.getDisableKwdeploy()) {
            KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.serverConfig.getKwdeployCmd(envVars, workspace));
        }
        if (this.serverConfig.hasImportConfig()) {
            logger.logMessage("Detected config files to import. Running kwadmin import-config for each");
            for (ArgumentListBuilder cmd : this.serverConfig.getKwadminImportConfigCmds(envVars)) {
                KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, cmd);
            }
        }
        if ((rc_kwbuild = KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.serverConfig.getKwbuildprojectCmd(envVars), true)) != 0) {
            if (this.serverConfig.getIgnoreCompileErrors() && rc_kwbuild == 2) {
                logger.logMessage("Return code 2 indicates compile errors. Check the build.log. Job config says to ignore return code");
            } else {
                throw new AbortException("Non-zero return code: " + Integer.toString(rc_kwbuild));
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_SERVER_ANALYSIS_DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

