/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkBuildAction;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.util.ArrayList;
import org.json.JSONObject;

public class KlocworkProjectAction
implements Action {
    private final Job<?, ?> job;

    public KlocworkProjectAction(Job<?, ?> job) {
        this.job = job;
    }

    public String getIconFileName() {
        return "/plugin/klocwork/icons/klocwork-24.gif";
    }

    public String getDisplayName() {
        return KlocworkConstants.DISPLAY_NAME;
    }

    public String getUrlName() {
        KlocworkBuildAction buildAction = this.getLatestBuildAction();
        if (buildAction != null) {
            if (buildAction.getProjectId() == null || buildAction.getProjectId().equals("")) {
                return KlocworkUtil.getIssueListUrl(buildAction.getKlocworkURL(), buildAction.getKlocworkProject());
            }
            return KlocworkUtil.getIssueListUrl(buildAction.getKlocworkURL(), buildAction.getProjectId());
        }
        return "";
    }

    public String getChartWidth() {
        return this.getLatestBuildAction().getChartWidth();
    }

    public String getChartHeight() {
        return this.getLatestBuildAction().getChartHeight();
    }

    public Job<?, ?> getJob() {
        return this.job;
    }

    public String getChartData() {
        JSONObject data = new JSONObject();
        ArrayList<String> labels = new ArrayList<String>();
        JSONObject criticalIssuedata = new JSONObject();
        JSONObject errorIssuedata = new JSONObject();
        JSONObject warningIssuedata = new JSONObject();
        JSONObject reviewIssuedata = new JSONObject();
        for (Run build = this.getJob().getFirstBuild(); build != null; build = build.getNextBuild()) {
            KlocworkBuildAction kwBuildAction = (KlocworkBuildAction)build.getAction(KlocworkBuildAction.class);
            if (kwBuildAction == null) continue;
            labels.add(kwBuildAction.getBuildName());
            criticalIssuedata.append("data", (Object)kwBuildAction.getCriticalCount());
            errorIssuedata.append("data", (Object)kwBuildAction.getErrorCount());
            warningIssuedata.append("data", (Object)kwBuildAction.getWarningCount());
            reviewIssuedata.append("data", (Object)kwBuildAction.getReviewCount());
        }
        criticalIssuedata.put("label", (Object)KlocworkConstants.KLOCWORK_ISSUE_CRITICAL);
        criticalIssuedata.put("backgroundColor", (Object)"#dc0d0e");
        criticalIssuedata.put("borderColor", (Object)"#dc0d0e");
        criticalIssuedata.put("fill", (Object)"true");
        errorIssuedata.put("label", (Object)KlocworkConstants.KLOCWORK_ISSUE_ERROR);
        errorIssuedata.put("backgroundColor", (Object)"#de890d");
        errorIssuedata.put("borderColor", (Object)"#de890d");
        errorIssuedata.put("fill", (Object)"true");
        warningIssuedata.put("label", (Object)KlocworkConstants.KLOCWORK_ISSUE_WARNING);
        warningIssuedata.put("backgroundColor", (Object)"#3fa45b");
        warningIssuedata.put("borderColor", (Object)"#3fa45b");
        warningIssuedata.put("fill", (Object)"true");
        reviewIssuedata.put("label", (Object)KlocworkConstants.KLOCWORK_ISSUE_REVIEW);
        reviewIssuedata.put("backgroundColor", (Object)"#848f94");
        reviewIssuedata.put("borderColor", (Object)"#848f94");
        reviewIssuedata.put("fill", (Object)"true");
        data.put("labels", labels);
        data.append("datasets", (Object)criticalIssuedata);
        data.append("datasets", (Object)errorIssuedata);
        data.append("datasets", (Object)warningIssuedata);
        data.append("datasets", (Object)reviewIssuedata);
        return data.toString();
    }

    public boolean isVisible() {
        KlocworkBuildAction kwBuildAction = this.getLatestBuildAction();
        if (kwBuildAction != null) {
            return kwBuildAction.isDisplayChart();
        }
        return false;
    }

    public KlocworkBuildAction getLatestBuildAction() {
        for (Run build : this.getJob().getBuilds()) {
            KlocworkBuildAction kwBuildAction = (KlocworkBuildAction)build.getAction(KlocworkBuildAction.class);
            if (kwBuildAction == null) continue;
            return kwBuildAction;
        }
        return null;
    }
}

