/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkLogger;
import com.klocwork.kwjenkinsplugin.config.KlocworkFailureConditionCiConfig;
import com.klocwork.kwjenkinsplugin.config.KlocworkFailureConditionConfig;
import com.klocwork.kwjenkinsplugin.config.KlocworkFailureConditionServerConfig;
import com.klocwork.kwjenkinsplugin.definitions.KlocworkIssue;
import com.klocwork.kwjenkinsplugin.reporting.KlocworkDashboard;
import com.klocwork.kwjenkinsplugin.reporting.KlocworkResultsAction;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import com.klocwork.kwjenkinsplugin.util.KlocworkXMLReportParserIssueList;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KlocworkFailureConditionPublisher
extends Publisher
implements SimpleBuildStep {
    private static final Logger debugLogger = Logger.getLogger(KlocworkFailureConditionPublisher.class.getName());
    private final KlocworkFailureConditionConfig failureConditionConfig;

    @DataBoundConstructor
    public KlocworkFailureConditionPublisher(KlocworkFailureConditionConfig failureConditionConfig) {
        this.failureConditionConfig = failureConditionConfig;
    }

    public KlocworkFailureConditionConfig getFailureConditionConfig() {
        return this.failureConditionConfig;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
        this.perform(build, envVars, workspace, launcher, listener);
    }

    public void perform(Run<?, ?> build, EnvVars envVars, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        KlocworkLogger logger = new KlocworkLogger("KlocworkFailureConditionPublisher", listener.getLogger());
        boolean stopBuild = false;
        boolean shouldDashboardLocal = false;
        boolean shouldDashboardServer = false;
        ArrayList<KlocworkIssue> localIssues = new ArrayList<KlocworkIssue>();
        ArrayList<KlocworkIssue> serverIssues = new ArrayList<KlocworkIssue>();
        debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Performing Failure Condition validation");
        if (this.failureConditionConfig.getEnableServerFailureCondition()) {
            debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Entered server Failure Condition validation");
            logger.logMessage("Performing Klocwork Server Build Failure Condition validation");
            KlocworkUtil.validateServerConfigs(envVars);
            for (KlocworkFailureConditionServerConfig pfConfig : this.failureConditionConfig.getFailureConditionServerConfigs()) {
                debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - " + pfConfig.toString());
                String request = KlocworkUtil.createKlocworkAPIRequestOld("search", pfConfig.getQuery(), envVars);
                logger.logMessage("Condition Name : " + pfConfig.getConditionName());
                logger.logMessage("Using query: " + request);
                JSONArray response = KlocworkUtil.getJSONResponse(request, envVars, launcher);
                logger.logMessage("Number of issues returned : " + Integer.toString(response.size()));
                debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - returns " + Integer.toString(response.size()) + " issues");
                logger.logMessage("Configured Threshold : " + pfConfig.getThreshold());
                if (response.size() >= Integer.parseInt(pfConfig.getThreshold())) {
                    debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Build Failure Condition triggered");
                    logger.logMessage("Threshold exceeded. Marking build as failed.");
                    build.setResult(pfConfig.getResultValue());
                    if (pfConfig.getStopBuild()) {
                        stopBuild = true;
                    }
                } else {
                    debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Build Failure Condition passed");
                }
                if (pfConfig.isEnableHTMLReporting() && !shouldDashboardServer) {
                    debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - setting shouldDashboardServer to true");
                    shouldDashboardServer = true;
                }
                for (int i = 0; i < response.size(); ++i) {
                    JSONObject jObj = response.getJSONObject(i);
                    if (pfConfig.isEnableHTMLReporting()) {
                        if (this.isIssueInList(jObj.getString("id"), serverIssues)) continue;
                        String line = "";
                        if (jObj.containsKey((Object)"line")) {
                            line = jObj.getString("line");
                        }
                        serverIssues.add(new KlocworkIssue(jObj.getString("id"), jObj.getString("code"), jObj.getString("message"), jObj.getString("file"), line, jObj.getString("severity"), jObj.getString("severityCode"), jObj.getString("status")));
                        continue;
                    }
                    debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - not setting shouldDashboardServer");
                    logger.logMessage(jObj.toString());
                }
            }
        }
        if (this.failureConditionConfig.getEnableCiFailureCondition()) {
            logger.logMessage("Performing Klocwork Ci Build Failure Condition validation");
            if (this.failureConditionConfig.getFailureConditionCiConfigs() != null) {
                debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Entered ci Failure Condition validation");
                for (KlocworkFailureConditionCiConfig ciConfig : this.failureConditionConfig.getFailureConditionCiConfigs()) {
                    debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - " + ciConfig.toString());
                    ArrayList failureConditionIssuesList = new ArrayList();
                    logger.logMessage("Checking ci Failure Condition validation: " + ciConfig.getName());
                    String xmlReport = envVars.expand(KlocworkUtil.getDefaultReportFileName(ciConfig.getReportFile()));
                    logger.logMessage("Working with report file: " + xmlReport);
                    try {
                        if (ciConfig.isEnableHTMLReporting()) {
                            shouldDashboardLocal = true;
                        }
                        failureConditionIssuesList = (ArrayList)launcher.getChannel().call((Callable)new KlocworkXMLReportParserIssueList(workspace.getRemote(), xmlReport, ciConfig.getEnabledSeverites(), ciConfig.getEnabledStatuses()));
                        int failureConditionIssuesCount = failureConditionIssuesList.size();
                        for (KlocworkIssue issue : failureConditionIssuesList) {
                            if (this.isIssueInList(issue.getId(), localIssues)) continue;
                            localIssues.add(issue);
                        }
                        logger.logMessage("Total Ci Issues : " + failureConditionIssuesCount);
                        debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - returns " + failureConditionIssuesCount + " issues");
                        logger.logMessage("Configured Threshold : " + ciConfig.getThreshold());
                        if (failureConditionIssuesCount >= Integer.parseInt(ciConfig.getThreshold())) {
                            debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Build Failure Condition triggered");
                            logger.logMessage("Threshold exceeded. Marking build as failed.");
                            if (ciConfig.getFailUnstable()) {
                                build.setResult(Result.UNSTABLE);
                            } else {
                                build.setResult(Result.FAILURE);
                            }
                            if (!ciConfig.getStopBuild()) continue;
                            stopBuild = true;
                            continue;
                        }
                        debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Build Failure Condition passed");
                    }
                    catch (IOException | InterruptedException ex) {
                        debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - exception thrown: " + ex.getMessage());
                        throw new AbortException(ex.getMessage());
                    }
                }
            } else {
                debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Build Failure Conditions enabled, but could not find configuration");
                logger.logMessage("WARNING: Build Failure Conditions enabled, but could not find configuration");
                build.setResult(Result.UNSTABLE);
            }
        }
        if (shouldDashboardLocal) {
            debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Entered addAction [ shouldDashboardLocal:" + shouldDashboardLocal + ", shouldDashboardServer:" + shouldDashboardServer + " ]");
            build.addAction((Action)new KlocworkResultsAction(build, workspace.getRemote(), workspace.getChannel(), launcher, envVars, listener, this.failureConditionConfig));
        } else if (shouldDashboardServer) {
            build.addAction((Action)new KlocworkDashboard(localIssues, serverIssues, shouldDashboardLocal, shouldDashboardServer));
        } else {
            debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - Not entered addAction [ shouldDashboardLocal:" + shouldDashboardLocal + ", shouldDashboardServer:" + shouldDashboardServer + " ]");
        }
        if (stopBuild) {
            debugLogger.fine("[" + ((Object)((Object)this)).getClass().getName() + "] - stopped build");
            throw new AbortException("Stopping build due to configuration");
        }
    }

    private boolean isIssueInList(String issue_id, List<? extends KlocworkIssue> issues) {
        for (KlocworkIssue klocworkIssue : issues) {
            if (!klocworkIssue.getId().equals(issue_id)) continue;
            return true;
        }
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_BUILD_FAILURE_CONDITION_DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

