/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.CiException;
import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkLogger;
import com.klocwork.kwjenkinsplugin.config.KlocworkCiConfig;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Items;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KlocworkCiBuilder
extends Builder
implements SimpleBuildStep {
    private transient KlocworkCiConfig desktopConfig;
    private KlocworkCiConfig ciConfig;
    private final boolean analysisSkipped;

    @DataBoundConstructor
    public KlocworkCiBuilder(KlocworkCiConfig ciConfig) {
        this.ciConfig = ciConfig;
        this.analysisSkipped = false;
    }

    public KlocworkCiConfig getCiConfig() {
        return this.ciConfig;
    }

    public boolean isAnalysisSkipped() {
        return this.analysisSkipped;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        EnvVars envVars;
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
        this.perform(build, envVars, workspace, launcher, listener);
    }

    public void perform(Run<?, ?> build, EnvVars envVars, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        KlocworkLogger logger = new KlocworkLogger("CiBuilder", listener.getLogger());
        logger.logMessage("Starting Klocwork CI Analysis");
        try {
            boolean foundTool = false;
            if (KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, KlocworkCiConfig.getVersionCiAgentCmd(), true) == 0) {
                foundTool = true;
            }
            if (!foundTool) {
                if (KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, KlocworkCiConfig.getVersionKwCheckCmd(), true) == 0) {
                    logger.logMessage("");
                    logger.logMessage("*******************************************************************************");
                    logger.logMessage("");
                    logger.logMessage("Note: Differential analysis no longer consumes a user license (kwcheck).");
                    logger.logMessage("Differential analysis requires a CI agent license (kwciagent).");
                    logger.logMessage("Contact your Klocwork representative to ensure you have a sufficient number of CI agent licenses.");
                    logger.logMessage("");
                    logger.logMessage("*******************************************************************************");
                    logger.logMessage("");
                    throw new CiException("Differential Analysis tool, KwCheck, is no longer supported.\nSee log for details.");
                }
                throw new CiException(String.format("Cannot find differential analysis tool: %s", KlocworkCiConfig.getCiTool()));
            }
            if (!this.ciConfig.hasExistingProject(workspace, envVars)) {
                KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.ciConfig.getCiToolCreateCmd(envVars, workspace));
            } else {
                KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.ciConfig.getCiToolSetCmd(envVars, workspace));
            }
            String diffListFile = "";
            if (this.ciConfig.getIncrementalAnalysis() && (diffListFile = this.ciConfig.getDiffFileList(envVars)).length() > 0) {
                logger.logMessage("Performing incremental analysis using change list specified in " + this.ciConfig.getDiffFileList(envVars));
                if (this.ciConfig.isGitDiffType()) {
                    if (this.ciConfig.hasPreviousCommitConfig(envVars)) {
                        logger.logMessage("Executing git diff to get change list");
                        try {
                            KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.ciConfig.getGitDiffCmd(envVars));
                        }
                        catch (AbortException e) {
                            logger.logMessage("Unable to run 'git diff' command. Cause: " + e.getMessage());
                            build.setResult(Result.UNSTABLE);
                            diffListFile = "";
                        }
                    } else {
                        logger.logMessage("No previous git commit specified to generate diff file list.");
                        build.setResult(Result.UNSTABLE);
                        diffListFile = "";
                    }
                }
            }
            if (diffListFile.isEmpty()) {
                logger.logMessage("Performing full CI analysis.");
            }
            KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.ciConfig.getCiToolRunCmd(envVars, workspace, diffListFile), true);
            Map<KlocworkUtil.StreamReferences, ByteArrayOutputStream> xmlFormatIssuesStreams = KlocworkUtil.executeCommandParseOutput(launcher, workspace, envVars, this.ciConfig.getCiToolListCmd(envVars, workspace, diffListFile, "xml"));
            if (xmlFormatIssuesStreams.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM).size() > 0) {
                throw new AbortException(xmlFormatIssuesStreams.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM).toString());
            }
            String xmlFilePath = envVars.expand(KlocworkUtil.getDefaultReportFileName(this.ciConfig.getReportFile()));
            this.writeIssuesToFile(workspace, launcher, listener, logger, xmlFilePath, xmlFormatIssuesStreams);
        }
        catch (CiException | IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
    }

    private void writeIssuesToFile(FilePath workspace, Launcher launcher, TaskListener listener, KlocworkLogger logger, String outputFilePath, Map<KlocworkUtil.StreamReferences, ByteArrayOutputStream> toolListStreams) {
        ByteArrayOutputStream issueListOutputStream = toolListStreams.get((Object)KlocworkUtil.StreamReferences.OUT_STREAM);
        if (issueListOutputStream != null) {
            File isAbs = new File(outputFilePath);
            FilePath reportFile = isAbs.isAbsolute() ? new FilePath(launcher.getChannel(), outputFilePath) : new FilePath(workspace, outputFilePath);
            KlocworkUtil.generateKwListOutput(reportFile, issueListOutputStream, listener, KlocworkCiConfig.getCiTool(), launcher);
        } else {
            logger.logMessage("Unable to generate differential analysis output");
            ByteArrayOutputStream errorStream = toolListStreams.get((Object)KlocworkUtil.StreamReferences.ERR_STREAM);
            if (errorStream != null) {
                logger.logMessage(errorStream.toString());
            }
        }
    }

    protected Object readResolve() {
        if (this.desktopConfig != null) {
            this.ciConfig = this.desktopConfig;
        }
        return this;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @Initializer(before=InitMilestone.PLUGINS_STARTED)
        public static void addAliases() {
            Items.XSTREAM2.addCompatibilityAlias("com.klocwork.kwjenkinsplugin.KlocworkDesktopBuilder", KlocworkCiBuilder.class);
            Run.XSTREAM2.addCompatibilityAlias("com.klocwork.kwjenkinsplugin.KlocworkDesktopBuilder", KlocworkCiBuilder.class);
        }

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_CI_BUILDER_DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

