/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkLogger;
import com.klocwork.kwjenkinsplugin.Messages;
import com.klocwork.kwjenkinsplugin.config.KlocworkInstallConfig;
import com.klocwork.kwjenkinsplugin.config.KlocworkServerConfig;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildWrapper;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class KlocworkBuildWrapper
extends SimpleBuildWrapper {
    private final String serverConfig;
    private final String installConfig;
    private final String serverProject;
    private final String ltoken;

    @DataBoundConstructor
    public KlocworkBuildWrapper(String serverConfig, String installConfig, String serverProject, String ltoken) {
        this.serverConfig = serverConfig;
        this.installConfig = installConfig;
        this.serverProject = serverProject;
        this.ltoken = ltoken;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        KlocworkLogger logger = new KlocworkLogger("BuildWrapper", listener.getLogger());
        logger.logMessage(Messages.KlocworkBuildWrapper_setup_environment_variables());
        KlocworkServerConfig server = this.getDescriptor().getServerConfig(this.serverConfig);
        KlocworkInstallConfig install = this.getDescriptor().getInstallConfig(this.installConfig);
        if (server != null) {
            if (StringUtils.isEmpty((CharSequence)server.getUrl())) {
                logger.logMessage("WARNING: Server URL for configuration \"" + server.getName() + "\" is empty");
            } else {
                logger.logMessage("Adding the Klocwork Server URL " + server.getUrl());
                context.env(KlocworkConstants.KLOCWORK_URL, server.getUrl());
            }
            if (server.isSpecificLicense()) {
                logger.logMessage("Using specific License for given server " + server.getLicensePort() + "@" + server.getLicenseHost());
                context.env(KlocworkConstants.KLOCWORK_LICENSE_HOST, server.getLicenseHost());
                context.env(KlocworkConstants.KLOCWORK_LICENSE_PORT, server.getLicensePort());
            } else {
                logger.logMessage("Using Global License Settings " + this.getDescriptor().getGlobalLicensePort() + "@" + this.getDescriptor().getGlobalLicenseHost());
                context.env(KlocworkConstants.KLOCWORK_LICENSE_HOST, this.getDescriptor().getGlobalLicenseHost());
                context.env(KlocworkConstants.KLOCWORK_LICENSE_PORT, this.getDescriptor().getGlobalLicensePort());
            }
        } else {
            logger.logMessage("WARNING: No Klocwork server selected. Klocwork cannot perform server builds or synchronisations without a server.");
            logger.logMessage("Using Global License Settings " + this.getDescriptor().getGlobalLicensePort() + "@" + this.getDescriptor().getGlobalLicenseHost());
            context.env(KlocworkConstants.KLOCWORK_LICENSE_HOST, this.getDescriptor().getGlobalLicenseHost());
            context.env(KlocworkConstants.KLOCWORK_LICENSE_PORT, this.getDescriptor().getGlobalLicensePort());
        }
        if (StringUtils.isEmpty((CharSequence)this.serverProject)) {
            logger.logMessage("WARNING: No Klocwork project provided. Klocwork cannot perform server builds or synchronisations without a project.");
        } else {
            context.env(KlocworkConstants.KLOCWORK_PROJECT, this.serverProject);
        }
        if (install != null) {
            logger.logMessage("Adding Klocwork paths. Using install \"" + install.getName() + "\"");
            String separator = launcher.isUnix() ? ":" : ";";
            String paths = install.getPaths() + separator;
            String path = (String)initialEnvironment.get((Object)"PATH");
            context.env("PATH", paths + path);
        }
        if (StringUtils.isEmpty((CharSequence)this.ltoken)) {
            logger.logMessage("No ltoken file specified. KLOCWORK_LTOKEN will not be set.");
        } else {
            logger.logMessage("Detected ltoken file. Setting KLOCWORK_LTOKEN to \"" + this.ltoken + "\"");
            context.env(KlocworkConstants.KLOCWORK_LTOKEN, initialEnvironment.expand(this.ltoken));
        }
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public String getInstallConfig() {
        return this.installConfig;
    }

    public String getServerProject() {
        return this.serverProject;
    }

    public String getLtoken() {
        return this.ltoken;
    }

    public static final String getNoneValue() {
        return Messages.KlocworkBuildWrapper_none_value();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Symbol(value={"klocworkWrapper"})
    @Extension
    public static final class DescriptorImpl
    extends BuildWrapperDescriptor {
        private String globalLicenseHost;
        private String globalLicensePort;
        private List<KlocworkServerConfig> serverConfigs = new ArrayList<KlocworkServerConfig>();
        private List<KlocworkInstallConfig> installConfigs = new ArrayList<KlocworkInstallConfig>();

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_BUILD_WRAPPER_DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.serverConfigs.clear();
            this.serverConfigs.addAll(req.bindJSONToList(KlocworkServerConfig.class, formData.get("serverConfigs")));
            this.installConfigs.clear();
            this.installConfigs.addAll(req.bindJSONToList(KlocworkInstallConfig.class, formData.get("installConfigs")));
            req.bindJSON((Object)this, formData);
            this.save();
            return super.configure(req, formData);
        }

        public String getGlobalLicenseHost() {
            return this.globalLicenseHost;
        }

        @DataBoundSetter
        public void setGlobalLicenseHost(String globalLicenseHost) {
            this.globalLicenseHost = globalLicenseHost;
        }

        public String getGlobalLicensePort() {
            return this.globalLicensePort;
        }

        @DataBoundSetter
        public void setGlobalLicensePort(String globalLicensePort) {
            this.globalLicensePort = globalLicensePort;
        }

        public KlocworkServerConfig[] getServerConfigs() {
            return this.serverConfigs.toArray(new KlocworkServerConfig[0]);
        }

        @DataBoundSetter
        public void setServerConfigs(ArrayList<KlocworkServerConfig> serverConfigs) {
            this.serverConfigs = serverConfigs;
        }

        public KlocworkInstallConfig[] getInstallConfigs() {
            return this.installConfigs.toArray(new KlocworkInstallConfig[0]);
        }

        @DataBoundSetter
        public void setInstallConfigs(ArrayList<KlocworkInstallConfig> installConfigs) {
            this.installConfigs = installConfigs;
        }

        public KlocworkServerConfig getServerConfig(String name) {
            for (KlocworkServerConfig config : this.serverConfigs) {
                if (!config.getName().equals(name)) continue;
                return config;
            }
            return null;
        }

        public KlocworkInstallConfig getInstallConfig(String name) {
            for (KlocworkInstallConfig config : this.installConfigs) {
                if (!config.getName().equals(name)) continue;
                return config;
            }
            return null;
        }

        public FormValidation doCheckGlobalLicensePort(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isNumeric((CharSequence)value)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.KlocworkBuildWrapper_port_must_be_a_number());
        }

        public ListBoxModel doFillServerConfigItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(KlocworkBuildWrapper.getNoneValue());
            for (KlocworkServerConfig config : this.serverConfigs) {
                items.add(config.getName());
            }
            return items;
        }

        public FormValidation doCheckServerConfig(@QueryParameter String value) throws IOException, ServletException {
            if (value.equals(KlocworkBuildWrapper.getNoneValue())) {
                return FormValidation.warning((String)Messages.KlocworkBuildWrapper_server_configuration_required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckServerProject(@QueryParameter String value) throws IOException, ServletException {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return FormValidation.warning((String)Messages.KlocworkBuildWrapper_server_project_required());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillInstallConfigItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(KlocworkBuildWrapper.getNoneValue());
            for (KlocworkInstallConfig config : this.installConfigs) {
                items.add(config.getName());
            }
            return items;
        }
    }
}

