/*
 * Decompiled with CFR 0.152.
 */
package com.klocwork.kwjenkinsplugin;

import com.klocwork.kwjenkinsplugin.KlocworkConstants;
import com.klocwork.kwjenkinsplugin.KlocworkLogger;
import com.klocwork.kwjenkinsplugin.config.KlocworkBuildSpecConfig;
import com.klocwork.kwjenkinsplugin.util.KlocworkUtil;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class KlocworkBuildSpecBuilder
extends Builder
implements SimpleBuildStep {
    private KlocworkBuildSpecConfig buildSpecConfig;

    @DataBoundConstructor
    public KlocworkBuildSpecBuilder(KlocworkBuildSpecConfig buildSpecConfig) {
        this.buildSpecConfig = buildSpecConfig;
    }

    public KlocworkBuildSpecConfig getBuildSpecConfig() {
        return this.buildSpecConfig;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment(listener);
        }
        catch (IOException | InterruptedException ex) {
            throw new AbortException(ex.getMessage());
        }
        this.perform(build, envVars, workspace, launcher, listener);
    }

    public void perform(Run<?, ?> build, EnvVars envVars, FilePath workspace, Launcher launcher, TaskListener listener) throws AbortException {
        KlocworkLogger logger = new KlocworkLogger("BuildSpecBuilder", listener.getLogger());
        logger.logMessage("Starting Klocwork Build Specification Generation Step");
        KlocworkUtil.validateServerConfigs(envVars);
        KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.buildSpecConfig.getVersionCmd());
        int rc_bstool = KlocworkUtil.executeCommand(launcher, listener, workspace, envVars, this.buildSpecConfig.getToolCmd(envVars), true);
        if (rc_bstool != 0) {
            if (this.buildSpecConfig.isIgnoreErrors()) {
                logger.logMessage("Return code " + rc_bstool + " from build spec generation ignored");
            } else {
                throw new AbortException("Non-zero return code: " + Integer.toString(rc_bstool));
            }
        }
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return KlocworkConstants.KLOCWORK_BUILD_SPEC_DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }
}

