/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.security.SecurityRealm;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class KeycloakAuthentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 1L;
    private final String userName;
    private String refreshToken;
    private String accessToken;
    private transient AccessTokenResponse accessTokenResponse = null;
    private Calendar lastRefresh = Calendar.getInstance();

    public KeycloakAuthentication(IDToken idToken, AccessToken accessToken, String refreshToken, AccessTokenResponse tokenResponse) {
        super(KeycloakAuthentication.buildRoles(accessToken));
        this.userName = idToken.getPreferredUsername();
        this.setRefreshToken(refreshToken);
        this.setAccessTokenResponse(tokenResponse);
        this.setAuthenticated(true);
    }

    private static GrantedAuthority[] buildRoles(AccessToken accessToken) {
        ArrayList<Object> roles = new ArrayList<Object>();
        if (accessToken != null && accessToken.getRealmAccess() != null) {
            for (String role : accessToken.getRealmAccess().getRoles()) {
                roles.add(new GrantedAuthorityImpl(role));
            }
        }
        if (accessToken != null && accessToken.getOtherClaims().containsKey("roles")) {
            for (String role : (List)accessToken.getOtherClaims().get("roles")) {
                roles.add(new GrantedAuthorityImpl(role));
            }
        }
        roles.add(SecurityRealm.AUTHENTICATED_AUTHORITY);
        return roles.toArray(new GrantedAuthority[roles.size()]);
    }

    public String getName() {
        return this.userName;
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.userName;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public AccessTokenResponse getAccessTokenResponse() {
        return this.accessTokenResponse;
    }

    public void setAccessTokenResponse(AccessTokenResponse accessTokenResponse) {
        this.accessTokenResponse = accessTokenResponse;
        this.setRefreshToken(accessTokenResponse.getRefreshToken());
        this.setLastRefresh(new Date());
    }

    public Date getLastRefresh() {
        return this.lastRefresh.getTime();
    }

    public Calendar getLastRefreshDateAsCalendar() {
        return this.lastRefresh;
    }

    public void setLastRefresh(Date lastRefresh) {
        this.lastRefresh.setTime(lastRefresh);
    }

    public boolean isRefreshExpired() {
        if (this.accessTokenResponse == null) {
            return true;
        }
        Calendar compareDate = Calendar.getInstance();
        compareDate.add(13, (int)this.accessTokenResponse.getRefreshExpiresIn() * -1);
        return compareDate.after(this.lastRefresh);
    }

    public boolean isAccessExpired() {
        if (this.accessTokenResponse == null) {
            return true;
        }
        Calendar compareDate = Calendar.getInstance();
        compareDate.add(13, (int)this.accessTokenResponse.getExpiresIn() * -1);
        return compareDate.after(this.lastRefresh);
    }
}

