/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.security.SecurityRealm;
import hudson.tasks.Mailer;
import hudson.util.FormValidation;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.cert.X509Certificate;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.security.SecurityListener;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.jenkinsci.plugins.KeycloakAuthentication;
import org.jenkinsci.plugins.KeycloakUserDetails;
import org.jenkinsci.plugins.RefreshFilter;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.adapters.spi.AuthenticationError;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.spi.LogoutError;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.TokenUtil;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class KeycloakSecurityRealm
extends SecurityRealm {
    private static final String JENKINS_LOGIN_URL = "securityRealm/commenceLogin";
    public static final String JENKINS_FINISH_LOGIN_URL = "securityRealm/finishLogin";
    public static final String AUTH_REQUESTED = "AUTH_REQUESTED";
    private static final Logger LOGGER = Logger.getLogger(KeycloakSecurityRealm.class.getName());
    private static final String REFERER_ATTRIBUTE = KeycloakSecurityRealm.class.getName() + ".referer";
    private transient KeycloakDeployment keycloakDeployment;
    private transient RefreshFilter filter;

    @DataBoundConstructor
    public KeycloakSecurityRealm() throws IOException {
        this.createFilter();
    }

    synchronized void createFilter() {
        if (this.filter == null || !this.filter.isInitCalled()) {
            try {
                LOGGER.log(Level.INFO, "Create Filter");
                this.filter = new RefreshFilter();
                PluginServletFilter.addFilter((Filter)this.filter);
            }
            catch (ServletException e) {
                LOGGER.log(Level.SEVERE, "createFilter", e);
            }
        }
    }

    public HttpResponse doCommenceLogin(StaplerRequest request, StaplerResponse response, @Header(value="Referer") String referer) throws IOException {
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)referer);
        String scopeParam = TokenUtil.attachOIDCScope(null);
        String redirect = this.redirectUrl(request);
        String state = UUID.randomUUID().toString();
        KeycloakUriBuilder builder = this.getKeycloakDeployment().getAuthUrl().clone().queryParam("client_id", new Object[]{this.getKeycloakDeployment().getResourceName()}).queryParam("redirect_uri", new Object[]{redirect}).queryParam("state", new Object[]{state}).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{scopeParam});
        String keycloakIdp = this.getKeycloakIdp();
        if (!"".equals(keycloakIdp) && keycloakIdp != null) {
            builder.queryParam("kc_idp_hint", new Object[]{keycloakIdp});
        }
        String authUrl = builder.build(new Object[0]).toString();
        request.getSession().setAttribute(AUTH_REQUESTED, (Object)true);
        this.createFilter();
        return new HttpRedirect(authUrl);
    }

    private String redirectUrl(StaplerRequest request) {
        String refererURL = request.getReferer();
        String requestURL = request.getRequestURL().toString();
        if (refererURL != null && requestURL != null && refererURL.startsWith("https:") && requestURL.startsWith("http:")) {
            requestURL = requestURL.replace("http:", "https:");
        }
        KeycloakUriBuilder builder = KeycloakUriBuilder.fromUri((String)requestURL).replacePath(request.getContextPath()).replaceQuery(null).path(JENKINS_FINISH_LOGIN_URL);
        String redirect = builder.toTemplate();
        return redirect;
    }

    private KeycloakDeployment resolveDeployment(KeycloakDeployment baseDeployment, HttpServletRequest request) {
        ServletFacade facade = new ServletFacade(request);
        return new AdapterDeploymentContext(baseDeployment).resolveDeployment((HttpFacade)facade);
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        block9: {
            String redirect = this.redirectUrl(request);
            try {
                LOGGER.log(Level.FINE, "Code" + request.getParameter("code"));
                LOGGER.log(Level.FINE, "Redirect" + redirect);
                KeycloakDeployment resolvedDeployment = this.resolveDeployment(this.getKeycloakDeployment(), (HttpServletRequest)request);
                LOGGER.log(Level.FINE, "TokenURL" + resolvedDeployment.getTokenUrl());
                AccessTokenResponse tokenResponse = ServerRequest.invokeAccessCodeToToken((KeycloakDeployment)resolvedDeployment, (String)request.getParameter("code"), (String)redirect, null);
                String tokenString = tokenResponse.getToken();
                String idTokenString = tokenResponse.getIdToken();
                String refreshToken = tokenResponse.getRefreshToken();
                AccessToken token = AdapterTokenVerifier.verifyToken((String)tokenString, (KeycloakDeployment)resolvedDeployment);
                if (idTokenString != null) {
                    JWSInput input = new JWSInput(idTokenString);
                    IDToken idToken = (IDToken)input.readJsonContent(IDToken.class);
                    KeycloakAuthentication auth = new KeycloakAuthentication(idToken, token, refreshToken, tokenResponse);
                    SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
                    User currentUser = User.current();
                    if (currentUser != null) {
                        currentUser.setFullName(idToken.getPreferredUsername());
                        if (!((Mailer.UserProperty)currentUser.getProperty(Mailer.UserProperty.class)).hasExplicitlyConfiguredAddress()) {
                            currentUser.addProperty((UserProperty)new Mailer.UserProperty(idToken.getEmail()));
                        }
                        KeycloakUserDetails userDetails = new KeycloakUserDetails(idToken.getPreferredUsername(), auth.getAuthorities());
                        SecurityListener.fireAuthenticated((UserDetails)userDetails);
                    }
                }
            }
            catch (Exception e) {
                Throwable cause;
                ServerRequest.HttpFailure hf = null;
                LOGGER.log(Level.SEVERE, "Authentication Exception ", e);
                if (e instanceof ServerRequest.HttpFailure) {
                    hf = (ServerRequest.HttpFailure)e;
                }
                if ((cause = e.getCause()) != null) {
                    LOGGER.log(Level.SEVERE, "Original exception", cause);
                    if (cause instanceof ServerRequest.HttpFailure) {
                        hf = (ServerRequest.HttpFailure)cause;
                    }
                }
                if (hf == null) break block9;
                LOGGER.log(Level.SEVERE, "Failure Message" + ((ServerRequest.HttpFailure)e).getError());
                LOGGER.log(Level.SEVERE, "Failure HTTP Status" + ((ServerRequest.HttpFailure)e).getStatus());
            }
        }
        String referer = (String)request.getSession().getAttribute(REFERER_ATTRIBUTE);
        if (referer != null) {
            LOGGER.log(Level.FINEST, "Redirecting to " + referer);
            return HttpResponses.redirectTo((String)referer);
        }
        return HttpResponses.redirectToContextRoot();
    }

    public boolean allowsSignup() {
        return false;
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        SecurityRealm.SecurityComponents sc = new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof KeycloakAuthentication) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        });
        return sc;
    }

    public String getLoginUrl() {
        return JENKINS_LOGIN_URL;
    }

    public void doLogout(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof KeycloakAuthentication) {
            KeycloakAuthentication keycloakAuthentication = (KeycloakAuthentication)authentication;
            try {
                ServerRequest.invokeLogout((KeycloakDeployment)this.getKeycloakDeployment(), (String)keycloakAuthentication.getRefreshToken());
            }
            catch (ServerRequest.HttpFailure e) {
                LOGGER.log(Level.SEVERE, "Logout Exception ", e);
            }
        }
        req.getSession().setAttribute(AUTH_REQUESTED, (Object)false);
        super.doLogout(req, rsp);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getKeycloakJson() {
        return this.getDescriptor().getKeycloakJson();
    }

    public String getKeycloakIdp() {
        return this.getDescriptor().getKeycloakIdp();
    }

    public boolean checkKeycloakOnEachRequest() {
        return this.getDescriptor().isKeycloakValidate();
    }

    public boolean respectAccessTokenTimeout() {
        return this.getDescriptor().isKeycloakRespectAccessTokenTimeout();
    }

    public synchronized KeycloakDeployment getKeycloakDeployment() throws IOException {
        if (this.keycloakDeployment == null || this.keycloakDeployment.getClient() == null) {
            AdapterConfig adapterConfig = (AdapterConfig)JsonSerialization.readValue((String)this.getKeycloakJson(), AdapterConfig.class);
            this.keycloakDeployment = KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig);
        }
        return this.keycloakDeployment;
    }

    public static class ServletFacade
    implements OIDCHttpFacade {
        private final HttpServletRequest servletRequest;

        private ServletFacade(HttpServletRequest servletRequest) {
            this.servletRequest = servletRequest;
        }

        public KeycloakSecurityContext getSecurityContext() {
            throw new IllegalStateException("Not yet implemented");
        }

        public HttpFacade.Request getRequest() {
            return new HttpFacade.Request(){

                public String getFirstParam(String param) {
                    return ServletFacade.this.servletRequest.getParameter(param);
                }

                public String getMethod() {
                    return ServletFacade.this.servletRequest.getMethod();
                }

                public String getURI() {
                    return ServletFacade.this.servletRequest.getRequestURL().toString();
                }

                public String getRelativePath() {
                    return ServletFacade.this.servletRequest.getServletPath();
                }

                public boolean isSecure() {
                    return ServletFacade.this.servletRequest.isSecure();
                }

                public String getQueryParamValue(String param) {
                    return ServletFacade.this.servletRequest.getParameter(param);
                }

                public HttpFacade.Cookie getCookie(String cookieName) {
                    return null;
                }

                public String getHeader(String name) {
                    return ServletFacade.this.servletRequest.getHeader(name);
                }

                public List<String> getHeaders(String name) {
                    return null;
                }

                public InputStream getInputStream() {
                    try {
                        return ServletFacade.this.servletRequest.getInputStream();
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }

                public String getRemoteAddr() {
                    return ServletFacade.this.servletRequest.getRemoteAddr();
                }

                public void setError(AuthenticationError error) {
                    ServletFacade.this.servletRequest.setAttribute(AuthenticationError.class.getName(), (Object)error);
                }

                public void setError(LogoutError error) {
                    ServletFacade.this.servletRequest.setAttribute(LogoutError.class.getName(), (Object)error);
                }

                public InputStream getInputStream(boolean buffered) {
                    try {
                        return ServletFacade.this.servletRequest.getInputStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
        }

        public HttpFacade.Response getResponse() {
            throw new IllegalStateException("Not yet implemented");
        }

        public X509Certificate[] getCertificateChain() {
            throw new IllegalStateException("Not yet implemented");
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        private String keycloakJson = "";
        private String keycloakIdp = "";
        private boolean keycloakValidate = false;
        private boolean keycloakRespectAccessTokenTimeout = true;

        public String getHelpFile() {
            return "/plugin/keycloak/help/help-security-realm.html";
        }

        public String getDisplayName() {
            return "Keycloak Authentication Plugin";
        }

        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckKeycloakJson(@QueryParameter String value) throws ServletException {
            try {
                if (value != null && !value.isEmpty()) {
                    JsonSerialization.readValue((String)value, AdapterConfig.class);
                }
            }
            catch (IOException ex) {
                return FormValidation.error((String)"Invalid adapter config");
            }
            return FormValidation.ok();
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            json = json.getJSONObject("keycloak");
            this.keycloakJson = json.getString("keycloakJson");
            this.keycloakIdp = json.getString("keycloakIdp");
            if (json.containsKey((Object)"keycloakValidate")) {
                LOGGER.log(Level.FINE, "Keycloakvalidate set to true");
                this.keycloakValidate = true;
                JSONObject validate = json.getJSONObject("keycloakValidate");
                if (validate.containsKey((Object)"keycloakRespectAccessTokenTimeout")) {
                    this.keycloakRespectAccessTokenTimeout = validate.getBoolean("keycloakRespectAccessTokenTimeout");
                    LOGGER.log(Level.FINE, "Respect access token timeout is set to " + this.keycloakRespectAccessTokenTimeout);
                }
            } else {
                this.keycloakValidate = false;
                this.keycloakRespectAccessTokenTimeout = true;
            }
            this.save();
            return true;
        }

        public String getKeycloakJson() {
            return this.keycloakJson;
        }

        public void setKeycloakJson(String keycloakJson) {
            this.keycloakJson = keycloakJson;
        }

        public SecurityRealm newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            return (SecurityRealm)super.newInstance(req, formData);
        }

        public boolean isKeycloakValidate() {
            return this.keycloakValidate;
        }

        public void setKeycloakValidate(boolean keycloakValidate) {
            this.keycloakValidate = keycloakValidate;
        }

        public boolean isKeycloakRespectAccessTokenTimeout() {
            return this.keycloakRespectAccessTokenTimeout;
        }

        public void setKeycloakRespectAccessTokenTimeout(boolean keycloakRespectAccessTokenTimeout) {
            this.keycloakRespectAccessTokenTimeout = keycloakRespectAccessTokenTimeout;
        }

        public String getKeycloakIdp() {
            return this.keycloakIdp;
        }

        public void setKeycloakIdp(String keycloakIdp) {
            this.keycloakIdp = keycloakIdp;
        }
    }
}

