/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLEntityResolver
implements EntityResolver {
    private static final String TESTNG_HTTP_NAMESPACE = "http://testng.org/";
    private static final String TESTNG_HTTPS_NAMESPACE = "https://testng.org/";
    private static final Logger LOGGER = Logger.getLogger(XMLEntityResolver.class.getName());

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Will try to resolve systemId [" + systemId + "]");
            }
            if (systemId.startsWith(TESTNG_HTTP_NAMESPACE) || systemId.startsWith(TESTNG_HTTPS_NAMESPACE)) {
                LOGGER.fine("It's a TestNG document, will try to lookup DTD in classpath");
                String dtdFileName = StringUtils.substringAfterLast((String)systemId, (String)"/");
                URL url = this.getClass().getClassLoader().getResource(dtdFileName);
                if (url != null) {
                    return new InputSource(url.toString());
                }
            }
        }
        return new InputSource();
    }
}

