/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResultActionIterable;
import hudson.tasks.test.TestResultTrendChart;
import io.jenkins.plugins.echarts.AsyncTrendChart;
import io.jenkins.plugins.junit.storage.FileJunitTestResultStorage;
import io.jenkins.plugins.junit.storage.JunitTestResultStorage;
import io.jenkins.plugins.junit.storage.TestResultImpl;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class TestResultProjectAction
implements Action,
AsyncTrendChart {
    public final Job<?, ?> job;
    @Deprecated
    public final AbstractProject<?, ?> project;
    private static final String FAILURE_ONLY_COOKIE = "TestResultAction_failureOnly";

    public TestResultProjectAction(Job<?, ?> job) {
        this.job = job;
        this.project = job instanceof AbstractProject ? (AbstractProject)job : null;
    }

    @Deprecated
    public TestResultProjectAction(AbstractProject<?, ?> project) {
        this((Job<?, ?>)project);
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Test Report";
    }

    public String getUrlName() {
        return "test";
    }

    public AbstractTestResultAction getLastTestResultAction() {
        Run tb = this.job.getLastSuccessfulBuild();
        for (Run b = this.job.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            AbstractTestResultAction a = (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class);
            if (a != null && !b.isBuilding()) {
                return a;
            }
            if (b != tb) continue;
            return null;
        }
        return null;
    }

    protected LinesChartModel createChartModel() {
        Run lastCompletedBuild = this.job.getLastCompletedBuild();
        JunitTestResultStorage storage = JunitTestResultStorage.find();
        if (!(storage instanceof FileJunitTestResultStorage)) {
            TestResultImpl pluggableStorage = storage.load(lastCompletedBuild.getParent().getFullName(), lastCompletedBuild.getNumber());
            return new TestResultTrendChart().create(pluggableStorage.getTrendTestResultSummary());
        }
        TestResultActionIterable buildHistory = this.createBuildHistory(lastCompletedBuild);
        if (buildHistory == null) {
            return new LinesChartModel();
        }
        return new TestResultTrendChart().create(buildHistory, new ChartModelConfiguration());
    }

    @CheckForNull
    private TestResultActionIterable createBuildHistory(Run<?, ?> lastCompletedBuild) {
        if (lastCompletedBuild == null) {
            return null;
        }
        AbstractTestResultAction action = (AbstractTestResultAction)lastCompletedBuild.getAction(AbstractTestResultAction.class);
        if (action == null) {
            Run currentBuild = lastCompletedBuild;
            while (action == null) {
                if ((currentBuild = currentBuild.getPreviousBuild()) == null) {
                    return null;
                }
                action = (AbstractTestResultAction)currentBuild.getAction(AbstractTestResultAction.class);
            }
        }
        return new TestResultActionIterable(action);
    }

    @Deprecated
    public void doTrend(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        AbstractTestResultAction a = this.getLastTestResultAction();
        if (a != null) {
            a.doGraph(req, rsp);
        } else {
            rsp.setStatus(404);
        }
    }

    @Deprecated
    public void doTrendMap(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        AbstractTestResultAction a = this.getLastTestResultAction();
        if (a != null) {
            a.doGraphMap(req, rsp);
        } else {
            rsp.setStatus(404);
        }
    }

    public void doFlipTrend(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        boolean failureOnly = false;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(FAILURE_ONLY_COOKIE)) continue;
                failureOnly = Boolean.parseBoolean(cookie.getValue());
            }
        }
        failureOnly = !failureOnly;
        Cookie cookie = new Cookie(FAILURE_ONLY_COOKIE, String.valueOf(failureOnly));
        List anc = req.getAncestors();
        Ancestor a = (Ancestor)anc.get(anc.size() - 2);
        cookie.setPath(a.getUrl());
        cookie.setMaxAge(31536000);
        rsp.addCookie(cookie);
        rsp.sendRedirect("..");
    }

    @JavaScriptMethod
    public String getBuildTrendModel() {
        return new JacksonFacade().toJson((Object)this.createChartModel());
    }

    public boolean isTrendVisible() {
        return true;
    }
}

