/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.model.Run;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.PackageResult;
import hudson.tasks.junit.TestNameTransformer;
import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class ClassResult
extends TabulatedResult
implements Comparable<ClassResult> {
    private final String className;
    private transient String safeName;
    private final List<CaseResult> cases = new ArrayList<CaseResult>();
    private int passCount;
    private int failCount;
    private int skipCount;
    private float duration;
    private final PackageResult parent;
    private static final long serialVersionUID = 1L;

    ClassResult(PackageResult parent, String className) {
        this.parent = parent;
        this.className = className;
    }

    @Override
    public Run<?, ?> getRun() {
        return this.parent == null ? null : this.parent.getRun();
    }

    @Override
    public PackageResult getParent() {
        return this.parent;
    }

    @Override
    public ClassResult getPreviousResult() {
        if (this.parent == null) {
            return null;
        }
        TestResult pr = this.parent.getPreviousResult();
        if (pr == null) {
            return null;
        }
        if (pr instanceof PackageResult) {
            return ((PackageResult)pr).getClassResult(this.getName());
        }
        return null;
    }

    @Override
    public TestResult findCorrespondingResult(String id) {
        CaseResult child;
        String myID = ClassResult.safe(this.getName());
        String caseName = id;
        int base = id.indexOf(myID);
        if (base > 0) {
            int caseNameStart = base + myID.length() + 1;
            if (id.length() > caseNameStart) {
                caseName = id.substring(caseNameStart);
            }
        }
        if ((child = this.getCaseResult(caseName)) != null) {
            return child;
        }
        return null;
    }

    @Override
    public String getTitle() {
        return Messages.ClassResult_getTitle(this.getDisplayName());
    }

    @Override
    public String getChildTitle() {
        return "Class Results";
    }

    @Override
    @Exported(visibility=999)
    public String getName() {
        int idx = this.className.lastIndexOf(46);
        if (idx < 0) {
            return this.className;
        }
        return this.className.substring(idx + 1);
    }

    @Override
    public synchronized String getSafeName() {
        if (this.safeName != null) {
            return this.safeName;
        }
        this.safeName = this.uniquifyName(this.parent.getChildren(), ClassResult.safe(this.getName()));
        return this.safeName;
    }

    public CaseResult getCaseResult(String name) {
        for (CaseResult c : this.cases) {
            if (!c.getSafeName().equals(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        CaseResult c = this.getCaseResult(name);
        if (c != null) {
            return c;
        }
        return super.getDynamic(name, req, rsp);
    }

    @Exported(name="child")
    public List<CaseResult> getChildren() {
        return this.cases;
    }

    @Override
    public boolean hasChildren() {
        return this.cases != null && this.cases.size() > 0;
    }

    @Override
    public float getDuration() {
        return this.duration;
    }

    @Override
    @Exported
    public int getPassCount() {
        return this.passCount;
    }

    @Override
    @Exported
    public int getFailCount() {
        return this.failCount;
    }

    @Override
    @Exported
    public int getSkipCount() {
        return this.skipCount;
    }

    public void add(CaseResult r) {
        this.cases.add(r);
    }

    @Override
    public void tally() {
        this.skipCount = 0;
        this.failCount = 0;
        this.passCount = 0;
        this.duration = 0.0f;
        for (CaseResult r : this.cases) {
            r.setClass(this);
            if (r.isSkipped()) {
                ++this.skipCount;
            } else if (r.isPassed()) {
                ++this.passCount;
            } else {
                ++this.failCount;
            }
            this.duration += r.getDuration();
        }
    }

    void freeze() {
        this.tally();
        Collections.sort(this.cases);
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public int compareTo(ClassResult that) {
        if (this.equals(that)) {
            return 0;
        }
        int r = this.className.compareTo(that.className);
        if (r != 0) {
            return r;
        }
        return System.identityHashCode(this) >= System.identityHashCode(that) ? 1 : -1;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String getDisplayName() {
        return TestNameTransformer.getTransformedName(this.getName());
    }

    @Override
    public String getFullName() {
        return this.getParent().getName() + "." + this.className;
    }

    @Override
    public String getFullDisplayName() {
        return this.getParent().getDisplayName() + "." + TestNameTransformer.getTransformedName(this.className);
    }

    @Override
    public String getRelativePathFrom(TestObject it) {
        if (it instanceof CaseResult) {
            return "..";
        }
        return super.getRelativePathFrom(it);
    }
}

