/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TimeToFloat;
import hudson.tasks.junit.XMLEntityResolver;
import hudson.tasks.test.PipelineTestDetails;
import hudson.tasks.test.TestObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.xml.sax.EntityResolver;

@ExportedBean
public final class SuiteResult
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(SuiteResult.class.getName());
    private final String file;
    private final String name;
    private final String stdout;
    private final String stderr;
    private float duration;
    private String timestamp;
    private String id;
    private String time;
    private String nodeId;
    private final List<String> enclosingBlocks = new ArrayList<String>();
    private final List<String> enclosingBlockNames = new ArrayList<String>();
    private final List<CaseResult> cases = new ArrayList<CaseResult>();
    private transient Map<String, CaseResult> casesByName;
    private transient TestResult parent;
    private static final long serialVersionUID = 1L;
    private static final Pattern SUREFIRE_FILENAME = Pattern.compile("TEST-(.+)\\.xml");

    @Deprecated
    SuiteResult(String name, String stdout, String stderr) {
        this(name, stdout, stderr, null);
    }

    SuiteResult(String name, String stdout, String stderr, @CheckForNull PipelineTestDetails pipelineTestDetails) {
        this.name = name;
        this.stderr = stderr;
        this.stdout = stdout;
        if (pipelineTestDetails != null && pipelineTestDetails.getNodeId() != null) {
            this.nodeId = pipelineTestDetails.getNodeId();
            this.enclosingBlocks.addAll(pipelineTestDetails.getEnclosingBlocks());
            this.enclosingBlockNames.addAll(pipelineTestDetails.getEnclosingBlockNames());
        } else {
            this.nodeId = null;
        }
        this.file = null;
    }

    private synchronized Map<String, CaseResult> casesByName() {
        if (this.casesByName == null) {
            this.casesByName = new HashMap<String, CaseResult>();
            for (CaseResult c : this.cases) {
                this.casesByName.put(c.getTransformedTestName(), c);
            }
        }
        return this.casesByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<SuiteResult> parse(File xmlReport, boolean keepLongStdio, PipelineTestDetails pipelineTestDetails) throws DocumentException, IOException, InterruptedException {
        ArrayList<SuiteResult> r = new ArrayList<SuiteResult>();
        SAXReader saxReader = new SAXReader();
        saxReader.setEntityResolver((EntityResolver)new XMLEntityResolver());
        try (FileInputStream xmlReportStream = new FileInputStream(xmlReport);){
            Document result = saxReader.read((InputStream)xmlReportStream);
            Element root = result.getRootElement();
            SuiteResult.parseSuite(xmlReport, keepLongStdio, r, root, pipelineTestDetails);
        }
        return r;
    }

    private static void parseSuite(File xmlReport, boolean keepLongStdio, List<SuiteResult> r, Element root, PipelineTestDetails pipelineTestDetails) throws DocumentException, IOException {
        List testSuites = root.elements("testsuite");
        for (Element suite : testSuites) {
            SuiteResult.parseSuite(xmlReport, keepLongStdio, r, suite, pipelineTestDetails);
        }
        if (root.element("testcase") != null || root.element("error") != null) {
            r.add(new SuiteResult(xmlReport, root, keepLongStdio, pipelineTestDetails));
        }
    }

    private SuiteResult(File xmlReport, Element suite, boolean keepLongStdio, @CheckForNull PipelineTestDetails pipelineTestDetails) throws DocumentException, IOException {
        File mavenOutputFile;
        Matcher m;
        Element ex;
        this.file = xmlReport.getAbsolutePath();
        String name = suite.attributeValue("name");
        if (name == null) {
            name = '(' + xmlReport.getName() + ')';
        } else {
            String pkg = suite.attributeValue("package");
            if (pkg != null && pkg.length() > 0) {
                name = pkg + '.' + name;
            }
        }
        this.name = TestObject.safe(name);
        this.timestamp = suite.attributeValue("timestamp");
        this.id = suite.attributeValue("id");
        if (pipelineTestDetails != null && pipelineTestDetails.getNodeId() != null) {
            this.nodeId = pipelineTestDetails.getNodeId();
            this.enclosingBlocks.addAll(pipelineTestDetails.getEnclosingBlocks());
            this.enclosingBlockNames.addAll(pipelineTestDetails.getEnclosingBlockNames());
        }
        if ((this.time = suite.attributeValue("time")) != null) {
            this.duration = new TimeToFloat(this.time).parse();
        }
        if ((ex = suite.element("error")) != null) {
            this.addCase(new CaseResult(this, suite, "<init>", keepLongStdio));
        }
        List testCases = suite.elements("testcase");
        for (Element e : testCases) {
            String classname = e.attributeValue("classname");
            if (classname == null) {
                classname = suite.attributeValue("name");
            }
            this.addCase(new CaseResult(this, e, classname, keepLongStdio));
        }
        String stdout = CaseResult.possiblyTrimStdio(this.cases, keepLongStdio, suite.elementText("system-out"));
        String stderr = CaseResult.possiblyTrimStdio(this.cases, keepLongStdio, suite.elementText("system-err"));
        if (stdout == null && stderr == null && (m = SUREFIRE_FILENAME.matcher(xmlReport.getName())).matches() && (mavenOutputFile = new File(xmlReport.getParentFile(), m.group(1) + "-output.txt")).exists()) {
            try {
                stdout = CaseResult.possiblyTrimStdio(this.cases, keepLongStdio, mavenOutputFile);
            }
            catch (IOException e) {
                throw new IOException("Failed to read " + mavenOutputFile, e);
            }
        }
        this.stdout = stdout;
        this.stderr = stderr;
    }

    void addCase(CaseResult cr) {
        this.cases.add(cr);
        this.casesByName().put(cr.getTransformedTestName(), cr);
        if (!this.hasTimeAttr()) {
            this.duration += cr.getDuration();
        }
    }

    private boolean hasTimeAttr() {
        return this.time != null;
    }

    @Exported(visibility=9)
    public String getName() {
        return this.name;
    }

    @Exported(visibility=9)
    public float getDuration() {
        return this.duration;
    }

    @Exported(visibility=9)
    @CheckForNull
    public String getNodeId() {
        return this.nodeId;
    }

    @Exported(visibility=9)
    @Nonnull
    public List<String> getEnclosingBlocks() {
        if (this.enclosingBlocks != null) {
            return Collections.unmodifiableList(this.enclosingBlocks);
        }
        return Collections.emptyList();
    }

    @Exported(visibility=9)
    @Nonnull
    public List<String> getEnclosingBlockNames() {
        if (this.enclosingBlockNames != null) {
            return Collections.unmodifiableList(this.enclosingBlockNames);
        }
        return Collections.emptyList();
    }

    @Exported
    public String getStdout() {
        return this.stdout;
    }

    @Exported
    public String getStderr() {
        return this.stderr;
    }

    public String getFile() {
        return this.file;
    }

    public TestResult getParent() {
        return this.parent;
    }

    @Exported(visibility=9)
    public String getTimestamp() {
        return this.timestamp;
    }

    @Exported(visibility=9)
    public String getId() {
        return this.id;
    }

    @Exported(inline=true, visibility=9)
    public List<CaseResult> getCases() {
        return this.cases;
    }

    public SuiteResult getPreviousResult() {
        hudson.tasks.test.TestResult pr = this.parent.getPreviousResult();
        if (pr == null) {
            return null;
        }
        if (pr instanceof TestResult) {
            return ((TestResult)pr).getSuite(this.name);
        }
        return null;
    }

    public CaseResult getCase(String name) {
        return this.casesByName().get(name);
    }

    public Set<String> getClassNames() {
        HashSet<String> result = new HashSet<String>();
        for (CaseResult c : this.cases) {
            result.add(c.getClassName());
        }
        return result;
    }

    void setParent(TestResult parent) {
        this.parent = parent;
    }

    boolean freeze(TestResult owner) {
        if (this.parent != null) {
            return false;
        }
        this.parent = owner;
        for (CaseResult c : this.cases) {
            c.freeze(this);
        }
        return true;
    }

    public void merge(SuiteResult sr) {
        if (sr.hasTimeAttr() ^ this.hasTimeAttr()) {
            LOGGER.warning("Merging of suiteresults with incompatible time attribute may lead to incorrect durations in reports.( " + this.getFile() + ", " + sr.getFile() + ")");
        }
        if (this.hasTimeAttr()) {
            this.duration += sr.getDuration();
        }
        for (CaseResult cr : sr.getCases()) {
            this.addCase(cr);
            cr.replaceParent(this);
        }
    }

    @Deprecated
    public static class SuiteResultParserConfigurationContext {
        public final File xmlReport;

        SuiteResultParserConfigurationContext(File xmlReport) {
            this.xmlReport = xmlReport;
        }
    }
}

