/*
 * The MIT License
 *
 * Copyright (c) 2004-2009, Sun Microsystems, Inc., Tom Huybrechts
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
package hudson.tasks.junit;

import hudson.model.Action;
import org.kohsuke.stapler.export.ExportedBean;

/**
 * 
 * Jelly (all optional):
 * <ul>
 * <li>index.jelly: included at the top of the test page</li>
 * <li>summary.jelly: included in a collapsed panel on the test parent page</li>
 * <li>badge.jelly: shown after the test link on the test parent page</li>
 * </ul>
 * 
 * @author tom
 * @since 1.320
 * @see TestDataPublisher
 */
@ExportedBean
public abstract class TestAction implements Action {

	/**
	 * Returns text with annotations.
	 * @param text Text to annotate.
	 *
	 * @return the text with the annotations.
	 */
	public String annotate(String text) {
		return text;
	}

}
