/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.SuiteResult;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestObject;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestResultProjectAction;
import hudson.util.HeapSpaceStringConverter;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.stapler.StaplerProxy;

public class TestResultAction
extends AbstractTestResultAction<TestResultAction>
implements StaplerProxy,
SimpleBuildStep.LastBuildAction {
    private transient WeakReference<TestResult> result;
    private int failCount;
    private int skipCount;
    private Integer totalCount;
    private Double healthScaleFactor;
    private List<Data> testData = new ArrayList<Data>();
    private static final Logger logger = Logger.getLogger(TestResultAction.class.getName());
    private static final XStream XSTREAM = new XStream2();

    @Deprecated
    public TestResultAction(AbstractBuild owner, TestResult result, BuildListener listener) {
        this((Run)owner, result, (TaskListener)listener);
    }

    public TestResultAction(Run owner, TestResult result, TaskListener listener) {
        super(owner);
        this.setResult(result, listener);
    }

    public TestResultAction(TestResult result, BuildListener listener) {
        this(null, result, listener);
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.singleton(new TestResultProjectAction(this.run.getParent()));
    }

    public synchronized void setResult(TestResult result, TaskListener listener) {
        result.freeze(this);
        this.totalCount = result.getTotalCount();
        this.failCount = result.getFailCount();
        this.skipCount = result.getSkipCount();
        try {
            this.getDataFile().write((Object)result);
        }
        catch (IOException e) {
            e.printStackTrace(listener.fatalError("Failed to save the JUnit test result"));
        }
        this.result = new WeakReference<TestResult>(result);
    }

    @Deprecated
    public void setResult(TestResult result, BuildListener listener) {
        this.setResult(result, (TaskListener)listener);
    }

    private XmlFile getDataFile() {
        return new XmlFile(XSTREAM, new File(this.run.getRootDir(), "junitResult.xml"));
    }

    @Override
    public synchronized TestResult getResult() {
        TestResult r;
        if (this.result == null) {
            r = this.load();
            this.result = new WeakReference<TestResult>(r);
        } else {
            r = (TestResult)this.result.get();
        }
        if (r == null) {
            r = this.load();
            this.result = new WeakReference<TestResult>(r);
        }
        if (this.totalCount == null) {
            this.totalCount = r.getTotalCount();
            this.failCount = r.getFailCount();
            this.skipCount = r.getSkipCount();
        }
        return r;
    }

    @Override
    public int getFailCount() {
        if (this.totalCount == null) {
            this.getResult();
        }
        return this.failCount;
    }

    @Override
    public int getSkipCount() {
        if (this.totalCount == null) {
            this.getResult();
        }
        return this.skipCount;
    }

    @Override
    public int getTotalCount() {
        if (this.totalCount == null) {
            this.getResult();
        }
        return this.totalCount;
    }

    @Override
    public double getHealthScaleFactor() {
        return this.healthScaleFactor == null ? 1.0 : this.healthScaleFactor;
    }

    public void setHealthScaleFactor(double healthScaleFactor) {
        this.healthScaleFactor = Math.max(0.0, healthScaleFactor);
    }

    @Override
    public List<CaseResult> getFailedTests() {
        return this.getResult().getFailedTests();
    }

    private TestResult load() {
        TestResult r;
        try {
            r = (TestResult)this.getDataFile().read();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to load " + this.getDataFile(), e);
            r = new TestResult();
        }
        r.freeze(this);
        return r;
    }

    public Object getTarget() {
        return this.getResult();
    }

    public List<TestAction> getActions(hudson.tasks.test.TestObject object) {
        ArrayList<TestAction> result = new ArrayList<TestAction>();
        if (this.testData != null) {
            for (Data data : this.testData) {
                for (TestAction testAction : data.getTestAction(object)) {
                    if (testAction == null) continue;
                    result.add(testAction);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    List<Data> getData() {
        return this.testData;
    }

    public void setData(List<Data> testData) {
        this.testData = testData;
    }

    void mergeResult(TestResult additionalResult, TaskListener listener) {
        TestResult original = this.getResult();
        original.merge(additionalResult);
        this.setResult(original, listener);
    }

    @Override
    public Object readResolve() {
        super.readResolve();
        if (this.testData == null) {
            this.testData = new ArrayList<Data>(0);
        }
        return this;
    }

    static {
        XSTREAM.alias("result", TestResult.class);
        XSTREAM.alias("suite", SuiteResult.class);
        XSTREAM.alias("case", CaseResult.class);
        XSTREAM.registerConverter((SingleValueConverter)new HeapSpaceStringConverter(), 100);
    }

    public static abstract class Data {
        public abstract List<? extends TestAction> getTestAction(TestObject var1);
    }
}

