/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.tasks.test.AbstractTestResultAction;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultProjectAction
implements Action {
    public final AbstractProject<?, ?> project;
    private static final String FAILURE_ONLY_COOKIE = "TestResultAction_failureOnly";

    public TestResultProjectAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Test Report";
    }

    public String getUrlName() {
        return "test";
    }

    public AbstractTestResultAction getLastTestResultAction() {
        AbstractBuild tb = (AbstractBuild)this.project.getLastSuccessfulBuild();
        for (AbstractBuild b = this.project.getLastBuild(); b != null; b = b.getPreviousBuild()) {
            AbstractTestResultAction a = (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class);
            if (a != null && !b.isBuilding()) {
                return a;
            }
            if (b != tb) continue;
            return null;
        }
        return null;
    }

    public void doTrend(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        AbstractTestResultAction a = this.getLastTestResultAction();
        if (a != null) {
            a.doGraph(req, rsp);
        } else {
            rsp.setStatus(404);
        }
    }

    public void doTrendMap(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        AbstractTestResultAction a = this.getLastTestResultAction();
        if (a != null) {
            a.doGraphMap(req, rsp);
        } else {
            rsp.setStatus(404);
        }
    }

    public void doFlipTrend(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        boolean failureOnly = false;
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(FAILURE_ONLY_COOKIE)) continue;
                failureOnly = Boolean.parseBoolean(cookie.getValue());
            }
        }
        failureOnly = !failureOnly;
        Cookie cookie = new Cookie(FAILURE_ONLY_COOKIE, String.valueOf(failureOnly));
        List anc = req.getAncestors();
        Ancestor a = (Ancestor)anc.get(anc.size() - 2);
        cookie.setPath(a.getUrl());
        cookie.setMaxAge(31536000);
        rsp.addCookie(cookie);
        rsp.sendRedirect("..");
    }
}

