/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.tasks.junit.TestAction;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TestResult
extends TestObject {
    public void setParentAction(AbstractTestResultAction action) {
    }

    public AbstractTestResultAction getParentAction() {
        return (AbstractTestResultAction)this.getOwner().getAction(AbstractTestResultAction.class);
    }

    public void tally() {
    }

    public void setParent(TestObject parent) {
    }

    public String getTitle() {
        return "";
    }

    public Result getBuildResult() {
        if (this.getFailCount() > 0) {
            return Result.UNSTABLE;
        }
        return null;
    }

    @Override
    public float getDuration() {
        return 0.0f;
    }

    @Override
    public int getPassCount() {
        return 0;
    }

    @Override
    public int getFailCount() {
        return 0;
    }

    @Override
    public int getSkipCount() {
        return 0;
    }

    @Override
    public TestResult getPreviousResult() {
        TestResult result;
        AbstractTestResultAction r;
        AbstractBuild b = this.getOwner();
        if (b == null) {
            return null;
        }
        do {
            if ((b = b.getPreviousBuild()) != null) continue;
            return null;
        } while ((r = (AbstractTestResultAction)b.getAction(this.getParentAction().getClass())) == null || (result = r.findCorrespondingResult(this.getId())) == null);
        return result;
    }

    @Override
    public TestResult getResultInBuild(AbstractBuild<?, ?> build) {
        AbstractTestResultAction tra = (AbstractTestResultAction)build.getAction(this.getParentAction().getClass());
        if (tra == null) {
            tra = (AbstractTestResultAction)build.getAction(AbstractTestResultAction.class);
        }
        return tra == null ? null : tra.findCorrespondingResult(this.getId());
    }

    public Collection<? extends TestResult> getFailedTests() {
        return Collections.emptyList();
    }

    public Collection<? extends TestResult> getPassedTests() {
        return Collections.emptyList();
    }

    public Collection<? extends TestResult> getSkippedTests() {
        return Collections.emptyList();
    }

    public int getFailedSince() {
        return 0;
    }

    public Run<?, ?> getFailedSinceRun() {
        return null;
    }

    public String getStdout() {
        return "";
    }

    public String getStderr() {
        return "";
    }

    public String getErrorStackTrace() {
        return "";
    }

    public String getErrorDetails() {
        return "";
    }

    public boolean isPassed() {
        return this.getSkipCount() == 0 && this.getFailCount() == 0;
    }

    public String toPrettyString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Name: ").append(this.getName()).append(", ");
        sb.append("Result: ").append(this.getBuildResult()).append(",\n");
        sb.append("Total Count: ").append(this.getTotalCount()).append(", ");
        sb.append("Fail: ").append(this.getFailCount()).append(", ");
        sb.append("Skipt: ").append(this.getSkipCount()).append(", ");
        sb.append("Pass: ").append(this.getPassCount()).append(",\n");
        sb.append("Test Result Class: ").append(this.getClass().getName()).append(" }\n");
        return sb.toString();
    }

    public String annotate(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace("&", "&amp;").replace("<", "&lt;").replaceAll("\\b(https?://[^\\s)>]+)", "<a href=\"$1\">$1</a>");
        for (TestAction action : this.getTestActions()) {
            text = action.annotate(text);
        }
        return text;
    }
}

