/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.tasks.test.TestResult;
import hudson.tasks.test.TestResultParser;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultTestResultParserImpl
extends TestResultParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean IGNORE_TIMESTAMP_CHECK = Boolean.getBoolean(TestResultParser.class.getName() + ".ignoreTimestampCheck");

    protected abstract TestResult parse(List<File> var1, Launcher var2, TaskListener var3) throws InterruptedException, IOException;

    @Override
    public TestResult parse(final String testResultLocations, final AbstractBuild build, final Launcher launcher, final TaskListener listener) throws InterruptedException, IOException {
        return (TestResult)build.getWorkspace().act((FilePath.FileCallable)new FilePath.FileCallable<TestResult>(){
            final boolean ignoreTimestampCheck = IGNORE_TIMESTAMP_CHECK;
            final long buildTime = build.getTimestamp().getTimeInMillis();
            final long nowMaster = System.currentTimeMillis();

            public TestResult invoke(File dir, VirtualChannel channel) throws IOException, InterruptedException {
                long nowSlave = System.currentTimeMillis();
                long localBuildTime = this.buildTime + (nowSlave - this.nowMaster);
                FilePath[] paths = new FilePath(dir).list(testResultLocations);
                if (paths.length == 0) {
                    throw new AbortException("No test reports that matches " + testResultLocations + " found. Configuration error?");
                }
                ArrayList<File> files = new ArrayList<File>(paths.length);
                for (FilePath path : paths) {
                    File report = new File(path.getRemote());
                    if (!this.ignoreTimestampCheck && localBuildTime - 3000L >= report.lastModified()) continue;
                    files.add(report);
                }
                if (files.isEmpty()) {
                    throw new AbortException(String.format("Test reports were found but none of them are new. Did tests run? %nFor example, %s is %s old%n", paths[0].getRemote(), Util.getTimeSpanString((long)(localBuildTime - paths[0].lastModified()))));
                }
                return DefaultTestResultParserImpl.this.parse(files, launcher, listener);
            }
        });
    }
}

