/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.test;

import hudson.model.AbstractBuild;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public abstract class AggregatedTestResultAction
extends AbstractTestResultAction {
    private int failCount;
    private int skipCount;
    private int totalCount;
    public final List<Child> children = new ArrayList<Child>();

    @Deprecated
    public AggregatedTestResultAction(AbstractBuild owner) {
        super(owner);
    }

    public AggregatedTestResultAction() {
    }

    protected void update(List<? extends AbstractTestResultAction> children) {
        this.totalCount = 0;
        this.skipCount = 0;
        this.failCount = 0;
        this.children.clear();
        for (AbstractTestResultAction abstractTestResultAction : children) {
            this.add(abstractTestResultAction);
        }
    }

    protected void add(AbstractTestResultAction child) {
        this.failCount += child.getFailCount();
        this.skipCount += child.getSkipCount();
        this.totalCount += child.getTotalCount();
        this.children.add(new Child(this.getChildName(child), child.owner.number));
    }

    @Override
    public int getFailCount() {
        return this.failCount;
    }

    @Override
    public int getSkipCount() {
        return this.skipCount;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public List<ChildReport> getResult() {
        return this.getChildReports();
    }

    @Override
    public List<? extends TestResult> getFailedTests() {
        ArrayList<? extends TestResult> failedTests = new ArrayList<TestResult>(this.failCount);
        for (ChildReport childReport : this.getChildReports()) {
            if (!(childReport.result instanceof TestResult)) continue;
            failedTests.addAll(((TestResult)childReport.result).getFailedTests());
        }
        return failedTests;
    }

    @Exported(inline=true)
    public List<ChildReport> getChildReports() {
        return new AbstractList<ChildReport>(){

            @Override
            public ChildReport get(int index) {
                return new ChildReport(AggregatedTestResultAction.this.resolveChild(AggregatedTestResultAction.this.children.get(index)), AggregatedTestResultAction.this.getChildReport(AggregatedTestResultAction.this.children.get(index)));
            }

            @Override
            public int size() {
                return AggregatedTestResultAction.this.children.size();
            }
        };
    }

    protected abstract String getChildName(AbstractTestResultAction var1);

    public abstract AbstractBuild<?, ?> resolveChild(Child var1);

    protected AbstractTestResultAction getChildReport(Child child) {
        AbstractBuild<?, ?> b = this.resolveChild(child);
        if (b == null) {
            return null;
        }
        return (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class);
    }

    @Override
    protected final String getDescription(TestObject object) {
        throw new AssertionError();
    }

    @Override
    protected final void setDescription(TestObject object, String description) {
        throw new AssertionError();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ExportedBean(defaultVisibility=2)
    public static final class ChildReport {
        @Exported
        public final AbstractBuild<?, ?> child;
        @Exported
        public final Object result;

        public ChildReport(AbstractBuild<?, ?> child, AbstractTestResultAction result) {
            this.child = child;
            this.result = result != null ? result.getResult() : null;
        }
    }

    public static final class Child {
        public final String name;
        public final int build;

        public Child(String name, int build) {
            this.name = name;
            this.build = build;
        }
    }
}

