/*
 * Decompiled with CFR 0.152.
 */
package hudson.tasks.junit;

import hudson.Extension;
import hudson.tasks.junit.SuiteResult;
import hudson.util.io.ParserConfigurator;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Extension
public class XMLEntityResolver
extends ParserConfigurator
implements EntityResolver {
    private static final String TESTNG_NAMESPACE = "http://testng.org/";
    private static final Logger LOGGER = Logger.getLogger(XMLEntityResolver.class.getName());

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Will try to resolve systemId [" + systemId + "]");
            }
            if (systemId.startsWith(TESTNG_NAMESPACE)) {
                LOGGER.fine("It's a TestNG document, will try to lookup DTD in classpath");
                String dtdFileName = systemId.substring(TESTNG_NAMESPACE.length());
                URL url = this.getClass().getClassLoader().getResource(dtdFileName);
                if (url != null) {
                    return new InputSource(url.toString());
                }
            }
        }
        return null;
    }

    public void configure(SAXReader reader, Object context) {
        if (context instanceof SuiteResult.SuiteResultParserConfigurationContext) {
            reader.setEntityResolver((EntityResolver)this);
        }
    }
}

